/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DecimalColumnDesc
extends NumberColumnDesc {
    private static final Log log = LogFactory.getLog(DecimalColumnDesc.class);

    public DecimalColumnDesc(String key, DecimalProp decProp, IDataEntityProperty fieldProp) {
        super(key, (IDataEntityProperty)decProp, fieldProp);
    }

    @Override
    public Object getValue(DynamicObject o) {
        return this.resolveFormat(o);
    }

    @Override
    protected boolean isZero(Object value) {
        return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected void defaultFormat(Object value, Object[] results) {
        results[0] = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : value.toString();
    }

    @Override
    public Object formatCell(DynamicObject dr, Object value, boolean forExport) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        int minimumFractionDigits = this.caculatePrecision(dr, value);
        String formatString = this.getDisplayFormatString();
        if (StringUtils.isBlank((CharSequence)formatString)) {
            FormatObject fo = this.getUserFormatObject();
            if (fo != null) {
                NumberFormatObject nfo = fo.getNumberFormat();
                nfo.setMinimumFractionDigits(minimumFractionDigits);
                IFormat format = this.getFormat();
                String result = format.getFormat(fo).format(value);
                return forExport ? this.buildExportValue(null, nfo.getMinimumFractionDigits(), value, null) : format.formatZeroPos(result, (BigDecimal)value, nfo);
            }
            return value;
        }
        return forExport ? this.buildExportValue(null, minimumFractionDigits, value, this.getDisplayFormatString()) : this.getFormat().getNumberFormat(this.getDisplayFormatString(), minimumFractionDigits, minimumFractionDigits, 3).format(value);
    }

    public Object formatCell(DynamicObject dr, BigDecimal value) {
        return this.formatCell(dr, value, false);
    }

    protected int getFieldPrecision(DynamicObject dr) {
        DecimalProp prop = (DecimalProp)this.getSrcFieldProp();
        int minimumFractionDigits = prop.getScale();
        if (StringUtils.isNotBlank((CharSequence)prop.getControlPropName()) && prop instanceof QtyProp) {
            IDataEntityType dt = prop.getParent();
            DynamicObject unit = null;
            String objectKey = prop.getControlPropName();
            boolean found = false;
            int cycle = 1;
            while (dt != null && !found && cycle <= 10) {
                found = dt.getProperties().containsKey((Object)prop.getControlPropName());
                if (!found) {
                    dt = dt.getParent();
                    ++cycle;
                    continue;
                }
                if (dt instanceof SubEntryType) {
                    objectKey = dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName();
                    continue;
                }
                if (dt instanceof EntryType) {
                    objectKey = dt.getName() + "." + prop.getControlPropName();
                    continue;
                }
                objectKey = prop.getControlPropName();
            }
            if (found) {
                try {
                    unit = dr.getDynamicObject(objectKey);
                    if (unit != null) {
                        minimumFractionDigits = unit.getInt("precision");
                    }
                }
                catch (KDException e) {
                    log.error("get unit precision error : " + e.getMessage());
                }
            }
        }
        return minimumFractionDigits;
    }

    protected int caculatePrecision(DynamicObject dr, Object value) {
        FormatObject formatObject;
        int minimumFractionDigits = this.getFieldPrecision(dr);
        boolean isreportColumn = false;
        Object columnType = this.getFormatParams().get("columntype");
        if (columnType != null && "report".equals(columnType.toString())) {
            isreportColumn = true;
        }
        boolean isShowTailzeroWithReport = true;
        Object noDisplayScaleZeroWithReport = this.getFormatParams().get("noDisplayScaleZeroWithReport");
        if (noDisplayScaleZeroWithReport != null) {
            isShowTailzeroWithReport = (Boolean)noDisplayScaleZeroWithReport == false;
        }
        boolean isMobListNoZero = false;
        if (this.isMobNoDisplayScaleZero()) {
            isMobListNoZero = true;
        }
        boolean showTailzero = true;
        if (!(this.getListUserOption() != null && this.getListUserOption().isShowZero() || isreportColumn || isMobListNoZero)) {
            showTailzero = false;
        }
        if (this.getListShowZeroConfig() != null && this.getListShowZeroConfig().isShowZeroSystem() && !isreportColumn && !isMobListNoZero && !this.isShowZeroBySystemParam()) {
            showTailzero = false;
        }
        if (isreportColumn && !isShowTailzeroWithReport) {
            showTailzero = false;
        }
        if (isMobListNoZero) {
            showTailzero = false;
        }
        if (isreportColumn && !(formatObject = this.getUserFormatObject()).getNumberFormat().isShowZero()) {
            showTailzero = false;
        }
        if (isreportColumn && !(formatObject = this.getUserFormatObject()).getNumberFormat().isShowZero()) {
            showTailzero = false;
        }
        String formatString = this.getDisplayFormatString();
        if (value instanceof BigDecimal) {
            minimumFractionDigits = this.getFmtDecimalPrecision(formatString, showTailzero, (BigDecimal)value, minimumFractionDigits);
        } else if (!showTailzero) {
            minimumFractionDigits = ((BigDecimal)value).stripTrailingZeros().scale();
        }
        return minimumFractionDigits;
    }

    @Override
    protected boolean isShowZeroBySystemParam() {
        if (this.getListShowZeroConfig() != null) {
            if (DecimalProp.class == this.getSrcFieldProp().getClass()) {
                return this.getListShowZeroConfig().isDecimalFieldIsShowZero();
            }
            return super.isShowZeroBySystemParam();
        }
        return super.isShowZeroBySystemParam();
    }
}

