/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.text.DecimalFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.property.IntegerProp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class IntegerColumnDesc
extends NumberColumnDesc {
    public IntegerColumnDesc(String key, IntegerProp intProp, IDataEntityProperty fieldProp) {
        super(key, (IDataEntityProperty)intProp, fieldProp);
    }

    @Override
    public Object getValue(DynamicObject dr) {
        return this.resolveFormat(dr);
    }

    @Override
    protected boolean isZero(Object value) {
        return value instanceof Long && (Long)value == 0L || value instanceof Integer && ((Integer)value).longValue() == 0L;
    }

    @Override
    protected void defaultFormat(Object value, Object[] results) {
        DecimalFormat format = new DecimalFormat("0");
        results[0] = format.format(value);
    }

    @Override
    public Object formatCell(DynamicObject dr, Object value, boolean forExport) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        Object retValue = value;
        String formatString = this.getDisplayFormatString();
        if (StringUtils.isBlank((CharSequence)formatString)) {
            FormatObject fo = this.getUserFormatObject();
            if (fo != null) {
                NumberFormatObject nfo = fo.getNumberFormat();
                nfo.setMinimumFractionDigits(0);
                return forExport ? this.buildExportValue(null, nfo.getMinimumFractionDigits(), value, formatString) : this.getFormat().getFormat(fo).format(retValue);
            }
            return value;
        }
        return forExport ? this.buildExportValue(null, 0, value, formatString) : this.getFormat().getNumberFormat(formatString, 0, 3).format(value);
    }

    public Object formatCell(DynamicObject dr, Object value) {
        return this.formatCell(dr, value, false);
    }
}

