/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.option.ListShowZeroConfig;
import kd.bos.exception.KDBizException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class NumberColumnDesc
extends ColumnDesc {
    protected IFormat format;
    private boolean zeroShow;
    private ListShowZeroConfig listShowZeroConfig;
    private boolean isMobNoDisplayScaleZero;
    private DecimalFormat dfWithoutFmtStr = null;
    private Map<String, DecimalFormat> dfWithFmtStr = new HashMap<String, DecimalFormat>(3);

    public ListShowZeroConfig getListShowZeroConfig() {
        return this.listShowZeroConfig;
    }

    public void setListShowZeroConfig(ListShowZeroConfig listShowZeroConfig) {
        this.listShowZeroConfig = listShowZeroConfig;
    }

    public boolean isMobNoDisplayScaleZero() {
        return this.isMobNoDisplayScaleZero;
    }

    public void setMobNoDisplayScaleZero(boolean mobNoDisplayScaleZero) {
        this.isMobNoDisplayScaleZero = mobNoDisplayScaleZero;
    }

    public boolean isZeroShow() {
        return this.zeroShow;
    }

    public void setZeroShow(boolean zeroShow) {
        this.zeroShow = zeroShow;
    }

    protected IFormat getFormat() {
        if (this.format == null) {
            this.format = FormatFactory.get(FormatTypes.Number);
        }
        return this.format;
    }

    protected Object resolveFormat(DynamicObject dr) {
        Object value = super.getValue(dr);
        Object[] results = new Object[]{null, value};
        if (value == null || this.isZero(value)) {
            if (!this.isZeroShow()) {
                results[0] = null;
            } else if (this.isZeroShow() && !this.getSrcFieldProp().isEnableNull()) {
                results[0] = this.formatCell(dr, BigDecimal.ZERO, false);
            } else if (value != null && this.getSrcFieldProp().isEnableNull()) {
                results[0] = this.formatCell(dr, value, false);
            }
        } else if (this.getFormaType() == 0 || this.getFormaType() == 2) {
            results[0] = this.formatCell(dr, value, false);
        } else {
            this.defaultFormat(value, results);
        }
        return results;
    }

    protected boolean isZero(Object value) {
        return false;
    }

    protected void defaultFormat(Object value, Object[] results) {
    }

    public NumberColumnDesc(String key, IDataEntityProperty srcFieldProp, IDataEntityProperty fieldProp) {
        super(key, srcFieldProp, fieldProp);
    }

    public Object formatCell(DynamicObject dr, Object value, boolean forExport) {
        return value;
    }

    protected Map<String, Object> buildExportValue(String currencySymbols, int minimumFractionDigits, Object value, String fmt) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("sign", currencySymbols);
        valueMap.put("showSign", currencySymbols != null && !currencySymbols.isEmpty());
        valueMap.put("precision", minimumFractionDigits);
        valueMap.put("result", value);
        valueMap.put("fmt", fmt);
        return valueMap;
    }

    protected int getFmtDecimalPrecision(String pattern, boolean showTailZero, BigDecimal value, int oldCtlPrecision) {
        boolean useFmtStr = StringUtils.isNotBlank((CharSequence)pattern);
        DecimalFormat fmt = null;
        if (useFmtStr) {
            fmt = this.dfWithFmtStr.get(pattern);
            if (fmt == null) {
                try {
                    fmt = new DecimalFormat(pattern);
                }
                catch (IllegalArgumentException e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u5f02\u5e38\uff0c\u4e0d\u5408\u89c4\u7684\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\uff1a%s", (String)"NumberColumnDesc_0", (String)"bos-entity-metadata", (Object[])new Object[0]), pattern));
                }
                this.dfWithFmtStr.put(pattern, fmt);
            }
        } else {
            if (this.dfWithoutFmtStr == null) {
                this.dfWithoutFmtStr = new DecimalFormat("0");
            }
            fmt = this.dfWithoutFmtStr;
        }
        int p = oldCtlPrecision;
        if (useFmtStr) {
            p = fmt.getMaximumFractionDigits();
        }
        if (showTailZero) {
            return p;
        }
        return value.setScale(p, RoundingMode.HALF_UP).stripTrailingZeros().scale();
    }

    protected boolean isShowZeroBySystemParam() {
        return true;
    }
}

