/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.property.BaseUnitqtyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QtyColumnDesc
extends DecimalColumnDesc {
    private static final Log log = LogFactory.getLog(QtyColumnDesc.class);

    public QtyColumnDesc(String key, DecimalProp srcFieldProp, IDataEntityProperty fieldProp) {
        super(key, srcFieldProp, fieldProp);
    }

    @Override
    protected int getFieldPrecision(DynamicObject dr) {
        DecimalProp prop = (DecimalProp)this.getSrcFieldProp();
        int minimumFractionDigits = prop.getScale();
        if (prop instanceof QtyProp) {
            DynamicObject materiel;
            Map<String, Object> fmtInfo;
            DynamicObject unit = this.getRelatedUnitData((QtyProp)prop, dr);
            if (unit != null) {
                try {
                    minimumFractionDigits = unit.getInt("precision");
                }
                catch (KDException var11) {
                    log.warn("get list qtyfield precision error : " + var11.getMessage());
                }
            }
            if (this.applyMaterialPrecision() && (fmtInfo = FmtInfoUtils.getUnitFmt(unit, materiel = this.getRelatedMaterielData((QtyProp)prop, dr))) != null) {
                Object precision = fmtInfo.get("ps");
                minimumFractionDigits = Integer.parseInt(precision != null ? precision.toString() : String.valueOf(prop.getScale()));
            }
        } else {
            minimumFractionDigits = super.getFieldPrecision(dr);
        }
        return minimumFractionDigits;
    }

    private DynamicObject getRelatedUnitData(QtyProp prop, DynamicObject dr) {
        String unitKey = prop.getRelatedUnit();
        return this.getRelatedData((IDataEntityProperty)prop, unitKey, dr);
    }

    private DynamicObject getRelatedMaterielData(QtyProp prop, DynamicObject dr) {
        String materiel = prop.getRelatedMaterielKey();
        IDataEntityType dt = prop.getParent();
        int maxCycle = 10;
        for (int i = 0; dt != null && !(dt instanceof MainEntityType) && i < maxCycle; dt = dt.getParent(), ++i) {
        }
        if (dt == null || !(dt instanceof MainEntityType)) {
            return null;
        }
        MainEntityType mainDt = (MainEntityType)dt;
        IDataEntityProperty unitProp = mainDt.getAllFields().get(prop.getRelatedUnit());
        return this.getRelatedData(unitProp, materiel, dr);
    }

    private boolean applyMaterialPrecision() {
        if (this.getFormatParams() == null && this.getFormatParams().size() == 0) {
            return false;
        }
        return Boolean.parseBoolean(String.valueOf(this.getFormatParams().get("ismaterialprecisionenable")));
    }

    private DynamicObject getRelatedData(IDataEntityProperty prop, String relatedKey, DynamicObject dr) {
        DynamicObject controlObj = null;
        if (prop == null) {
            return null;
        }
        IDataEntityType dt = prop.getParent();
        if (StringUtils.isBlank((CharSequence)relatedKey)) {
            return null;
        }
        String objectKey = relatedKey;
        boolean found = false;
        int cycle = 1;
        while (dt != null && !found && cycle <= 10) {
            found = dt.getProperties().containsKey((Object)relatedKey);
            if (!found) {
                dt = dt.getParent();
                ++cycle;
                continue;
            }
            if (dt instanceof SubEntryType) {
                objectKey = dt.getParent().getName() + "." + dt.getName() + "." + relatedKey;
                continue;
            }
            if (dt instanceof EntryType) {
                objectKey = dt.getName() + "." + relatedKey;
                continue;
            }
            objectKey = relatedKey;
        }
        if (found) {
            controlObj = (DynamicObject)dr.get(objectKey);
        }
        return controlObj;
    }

    @Override
    protected boolean isShowZeroBySystemParam() {
        if (this.getListShowZeroConfig() != null) {
            if (QtyProp.class == this.getSrcFieldProp().getClass()) {
                return this.getListShowZeroConfig().isQtyFieldIsShowZero();
            }
            if (BaseUnitqtyProp.class == this.getSrcFieldProp().getClass()) {
                return this.getListShowZeroConfig().isBaseUnitQtyFieldIsShowZero();
            }
            return super.isShowZeroBySystemParam();
        }
        return super.isShowZeroBySystemParam();
    }
}

