/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.text.DateFormat;
import java.util.GregorianCalendar;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TransType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TimeColumnDesc
extends ColumnDesc {
    private static Log log = LogFactory.getLog(TimeColumnDesc.class);
    private IFormat format;
    private TimeProp timeProp;

    protected IFormat getFormat() {
        if (this.format == null) {
            this.format = FormatFactory.get(FormatTypes.Time);
        }
        return this.format;
    }

    @Override
    public void setMask(String mask) {
        this.mask = mask;
    }

    @Override
    public void setDisplayFormatString(String displayFormatString) {
        this.displayFormatString = displayFormatString;
    }

    @Override
    public String getMask() {
        return StringUtils.isEmpty((CharSequence)this.mask) ? "HH:mm:ss" : this.mask;
    }

    @Override
    public String getDisplayFormatString() {
        return StringUtils.isEmpty((CharSequence)this.displayFormatString) ? "" : this.displayFormatString;
    }

    public TimeColumnDesc(String key, TimeProp timeProp, IDataEntityProperty fieldProp) {
        super(key, (IDataEntityProperty)timeProp, fieldProp);
        this.timeProp = timeProp;
    }

    @Override
    public Object getValue(DynamicObject dr) {
        if (this.formaType == 0) {
            Object[] results = new Object[2];
            Object value = null;
            if (this.fieldProp != null) {
                value = this.fieldProp.getValueFast((Object)dr);
            }
            results[1] = value;
            if (value instanceof Integer) {
                value = this.formatTimeStr((Integer)value);
            }
            if (value == null) {
                return null;
            }
            results[0] = value;
            return results;
        }
        Object value = null;
        if (this.fieldProp != null) {
            value = this.fieldProp.getValueFast((Object)dr);
        }
        return value;
    }

    private Object formatTimeStr(Integer timeObj) {
        if (timeObj == null || timeObj <= -1) {
            return "";
        }
        int time = timeObj;
        int second = time % 60;
        int minute = time / 60 % 60;
        int hour = time / 3600 % 24;
        GregorianCalendar c = new GregorianCalendar(1900, 1, 1, hour, minute, second);
        IFormat format1 = this.getFormat();
        FormatObject fo = this.getUserFormatObject();
        InteTimeZone zone = this.getTimeZone(0L);
        this.bindTimeZone(zone, fo);
        c.setTimeZone(zone.getTimeZone());
        String formatString = this.getDisplayFormatString();
        if (this.getFormaType() == 0 || this.getFormaType() == 2) {
            if (StringUtils.isBlank((CharSequence)formatString) && fo != null) {
                formatString = fo.getTimeFormat().getTimeFormat();
            }
            if (StringUtils.isBlank((CharSequence)formatString)) {
                formatString = "HH:mm:ss";
            }
            return zone.format(c.getTime(), (DateFormat)format1.getDateTimeFormat(formatString));
        }
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    private InteTimeZone getTimeZone(Long orgId) {
        InteTimeZone timeZone;
        switch (TransType.get((int)this.timeProp.getTimeZoneTransType())) {
            case USERTIMEZONE: {
                timeZone = InteTimeZone.getUserTimeZone((long)Long.parseLong(RequestContext.getOrCreate().getUserId()));
                break;
            }
            case ORGTIMEZONE: {
                timeZone = InteTimeZone.getOrgTimeZone((Long)orgId);
                break;
            }
            default: {
                timeZone = InteTimeZone.getSysTimeZone();
            }
        }
        return timeZone;
    }

    private void bindTimeZone(InteTimeZone zone, FormatObject fo) {
        if (fo != null && fo.isTimeNotEmpty()) {
            fo.getTimeFormat().setTimeArea(zone.getTimeArea());
            fo.getDateFormat().setTimeArea(zone.getTimeArea());
        }
    }
}

