/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.option;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListUserOption
implements Serializable {
    private static final long serialVersionUID = -3119413333211230670L;
    private static final String MAX_RETURN_DATA = "maxreturndata";
    private Map<String, Object> listUserOptions;
    private boolean hideSeq;
    private boolean showEntrySeq;
    private boolean mergeRow = false;
    private boolean showZero = true;
    private boolean gridStriped;
    private boolean cellSum;
    private boolean noHeaderSpan = true;
    private boolean defaultExportListAll = true;
    private int maxReturnData = 10000;

    public ListUserOption() {
    }

    public ListUserOption(Map<String, Object> listUserOptions) {
        this.listUserOptions = listUserOptions;
        this.hideSeq = Boolean.parseBoolean(String.valueOf(listUserOptions.get("ishideseq")));
        this.showEntrySeq = Boolean.parseBoolean(String.valueOf(listUserOptions.get("isshowentryseq")));
        this.mergeRow = !Boolean.parseBoolean(String.valueOf(listUserOptions.get("ismergerows")));
        this.showZero = listUserOptions.get("isshowzero") == null || Boolean.parseBoolean(String.valueOf(listUserOptions.get("isshowzero")));
        this.gridStriped = Boolean.parseBoolean(String.valueOf(listUserOptions.get("isgridstriped")));
        this.cellSum = Boolean.parseBoolean(String.valueOf(listUserOptions.get("iscellsum")));
        boolean bl = this.noHeaderSpan = listUserOptions.get("noheaderspan") == null || Boolean.parseBoolean(String.valueOf(listUserOptions.get("noheaderspan")));
        if (StringUtils.isNotBlank((Object)listUserOptions.get(MAX_RETURN_DATA)) && this.IsIntNumber(listUserOptions.get(MAX_RETURN_DATA).toString())) {
            this.maxReturnData = Integer.parseInt(listUserOptions.get(MAX_RETURN_DATA).toString());
        }
        this.defaultExportListAll = listUserOptions.get("isdefaultexportlistall") == null || Boolean.parseBoolean(String.valueOf(listUserOptions.get("isdefaultexportlistall")));
    }

    private boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private boolean IsIntNumber(String str) {
        String regex = "^\\+?[1-9][0-9]*$";
        return this.match(regex, str);
    }

    public void setListUserOptions(Map<String, Object> listUserOptions) {
        this.listUserOptions = listUserOptions;
    }

    @SimplePropertyAttribute(name="CellSum")
    public boolean isCellSum() {
        return this.cellSum;
    }

    public void setCellSum(boolean cellSum) {
        this.cellSum = cellSum;
    }

    @SimplePropertyAttribute(name="NoHeaderSpan")
    @DefaultValueAttribute(value="true")
    public boolean isNoHeaderSpan() {
        return this.noHeaderSpan;
    }

    public void setNoHeaderSpan(boolean noHeaderSpan) {
        this.noHeaderSpan = noHeaderSpan;
    }

    @SimplePropertyAttribute(name="GridStriped")
    public boolean isGridStriped() {
        return this.gridStriped;
    }

    public void setGridStriped(boolean gridStriped) {
        this.gridStriped = gridStriped;
    }

    @SimplePropertyAttribute(name="HideSeq")
    public boolean isHideSeq() {
        return this.hideSeq;
    }

    @SimplePropertyAttribute(name="ShowEntrySeq")
    public boolean isShowEntrySeq() {
        return this.showEntrySeq;
    }

    @SimplePropertyAttribute(name="MergeRow")
    public boolean isMergeRow() {
        return this.mergeRow;
    }

    public boolean isMergeRow(Map<String, Object> params) {
        String opKey = "ismergerows";
        if (params != null && params.containsKey(opKey)) {
            return Boolean.parseBoolean(String.valueOf(params.get(opKey)));
        }
        return this.mergeRow;
    }

    @SimplePropertyAttribute(name="ShowZero")
    @DefaultValueAttribute(value="true")
    public boolean isShowZero() {
        return this.showZero;
    }

    public void setHideSeq(boolean hideSeq) {
        this.hideSeq = hideSeq;
    }

    public void setShowEntrySeq(boolean showEntrySeq) {
        this.showEntrySeq = showEntrySeq;
    }

    public void setMergeRow(boolean mergeRow) {
        this.mergeRow = mergeRow;
    }

    public void setShowZero(boolean showZero) {
        this.showZero = showZero;
    }

    @SimplePropertyAttribute(name="ListUserOptions")
    public Map<String, Object> getListUserOptions() {
        return this.listUserOptions;
    }

    @SimplePropertyAttribute(name="MaxReturnData")
    public int getMaxReturnData() {
        return this.maxReturnData;
    }

    public void setMaxReturnData(int maxReturnData) {
        this.maxReturnData = maxReturnData;
    }

    @SimplePropertyAttribute(name="DefaultExportListAll")
    @DefaultValueAttribute(value="true")
    public boolean isDefaultExportListAll() {
        return this.defaultExportListAll;
    }

    public void setDefaultExportListAll(boolean defaultExportListAll) {
        this.defaultExportListAll = defaultExportListAll;
    }
}

