/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.nameversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.nameversion.NameVersionEntry;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

public class NameVersionBDFilter {
    private static final Log log = LogFactory.getLog(NameVersionBDFilter.class);
    private QFilter originalFilter;
    private boolean isChangeFilter = false;
    private final List<Object> matchIdList = new ArrayList<Object>();
    private String matchProperty;
    private static final String ENABLENAMEVERSION = "basedata.enablenameversion";
    private static NameVersionBDFilter nameVersionBDFilter = null;

    private static boolean isEnableNameVersion() {
        String property = System.getProperty(ENABLENAMEVERSION);
        if (StringUtils.isBlank((CharSequence)property)) {
            return true;
        }
        return property.equalsIgnoreCase("true");
    }

    public static List<QFilter> convertFilter(List<QFilter> qFilters, IDataEntityType billEntityType) {
        try {
            if (NameVersionBDFilter.isEnableNameVersion()) {
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                for (QFilter qFilter : qFilters) {
                    List<QFilter> qFilterList = NameVersionBDFilter.getQuickFtLikeQFilter(qFilter);
                    if (qFilterList != null) {
                        QFilter newFilter = null;
                        boolean changed = false;
                        for (QFilter filter : qFilterList) {
                            NameVersionBDFilter bdFilter = NameVersionBDFilter.getNameVersionBDFilter();
                            bdFilter.parseFilter(filter, billEntityType);
                            if (bdFilter.isChangeFilter) {
                                changed = true;
                                if (newFilter == null) {
                                    newFilter = bdFilter.getConvertQFilter();
                                    continue;
                                }
                                newFilter.or(bdFilter.getConvertQFilter());
                                continue;
                            }
                            if (newFilter != null) {
                                newFilter.or(filter);
                                continue;
                            }
                            newFilter = filter;
                        }
                        if (!changed) {
                            list.add(qFilter);
                            continue;
                        }
                        list.add(newFilter);
                        continue;
                    }
                    NameVersionBDFilter.parseNestQFilter(qFilter, billEntityType);
                    list.add(qFilter);
                }
                return list;
            }
            return qFilters;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return qFilters;
        }
    }

    private static NameVersionBDFilter getNameVersionBDFilter() {
        if (nameVersionBDFilter == null) {
            return new NameVersionBDFilter();
        }
        return nameVersionBDFilter;
    }

    private static void parseNestQFilter(QFilter qFilter, IDataEntityType billEntityType) {
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestQFilter = nest.getFilter();
            NameVersionBDFilter.parseNestQFilter(nestQFilter, billEntityType);
        }
        NameVersionBDFilter bdFilter = NameVersionBDFilter.getNameVersionBDFilter();
        bdFilter.parseFilter(qFilter, billEntityType);
        if (bdFilter.isChangeFilter) {
            QFilter qFilter2 = bdFilter.getConvertQFilter();
        }
    }

    protected static List<QFilter> getQuickFtLikeQFilter(QFilter filter) {
        if (filter.getCP().equals("ftlike") && filter.getProperty().equals("1")) {
            String values = filter.getOriginValue().toString();
            int i = values.indexOf("#");
            if (i < 0) {
                return null;
            }
            String properties = values.substring(0, i);
            String[] propertyArray = properties.split(",");
            values = values.substring(i + 1);
            String[] valueArray = values.split("\b");
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            for (String property : propertyArray) {
                for (String value : valueArray) {
                    QFilter qFilter = NameVersionBDFilter.copyQFilter(filter, property, value);
                    list.add(qFilter);
                }
            }
            return list;
        }
        return null;
    }

    public boolean isChangeFilter() {
        return this.isChangeFilter;
    }

    protected void parseFilter(QFilter filter, IDataEntityType entityType) {
        this.originalFilter = filter;
        if (filter.getCP().equalsIgnoreCase("is null") || filter.getCP().equalsIgnoreCase("is not null") || filter.getCP().equalsIgnoreCase("!=")) {
            return;
        }
        this.parseProperty("", filter.getProperty(), entityType);
    }

    private void parseProperty(String baseProperty, String property, IDataEntityType entityType) {
        String[] split = property.split("\\.");
        IDataEntityProperty first = (IDataEntityProperty)entityType.getProperties().get((Object)split[0]);
        if (first instanceof BasedataProp) {
            if (split.length != 2) {
                return;
            }
            IDataEntityType baseDataTypeWithName = this.getBaseDataTypeWithName(entityType, split[0], split[1]);
            if (baseDataTypeWithName == null) {
                return;
            }
            String idProp = baseDataTypeWithName.getPrimaryKey().getName();
            log.info("parseProperty {},{}", (Object)property, (Object)this.originalFilter);
            this.matchProperty = baseProperty + (StringUtils.isEmpty((CharSequence)baseProperty) ? "" : ".") + first + ".id";
            if (this.isNotCP(this.originalFilter.getCP())) {
                CompareTypeEnum compareTypeEnum = this.getNotCompareTypeEnum(this.originalFilter.getCP());
                String value = this.getFilterValue(this.originalFilter.getValue());
                NameVersionEntry[] nameVersionEntries = this.getAllContainName(baseDataTypeWithName.getName(), compareTypeEnum, value);
                if (nameVersionEntries == null || nameVersionEntries.length == 0) {
                    return;
                }
                HashSet<Long> nameVersionId = new HashSet<Long>(nameVersionEntries.length);
                for (NameVersionEntry nameVersionEntry : nameVersionEntries) {
                    nameVersionId.add(nameVersionEntry.getId());
                }
                this.matchIdList.addAll(nameVersionId);
                this.isChangeFilter = true;
            } else {
                CompareTypeEnum compareTypeEnum = this.getCompareTypeEnum(this.originalFilter.getCP(), this.originalFilter.getValue().toString());
                String value = this.getFilterValue(this.originalFilter.getValue());
                NameVersionEntry[] nameVersionEntries = this.getAllContainName(baseDataTypeWithName.getName(), compareTypeEnum, value);
                if (nameVersionEntries == null || nameVersionEntries.length == 0) {
                    return;
                }
                HashSet<Long> nameVersionId = new HashSet<Long>(nameVersionEntries.length);
                for (NameVersionEntry nameVersionEntry : nameVersionEntries) {
                    nameVersionId.add(nameVersionEntry.getId());
                }
                this.matchIdList.addAll(nameVersionId);
                this.isChangeFilter = true;
            }
        } else if (first instanceof EntryProp) {
            if (split[0].length() + 1 >= property.length()) {
                this.isChangeFilter = false;
                return;
            }
            this.parseProperty(baseProperty + (StringUtils.isEmpty((CharSequence)baseProperty) ? "" : ".") + split[0], property.substring(split[0].length() + 1), ((EntryProp)first).getItemType());
        }
    }

    private String getFilterValue(Object value) {
        if (value instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue multiBaseDataFilterValue = (MultiBaseDataFilterValue)value;
            if (multiBaseDataFilterValue.getValue() instanceof List) {
                List list = (List)multiBaseDataFilterValue.getValue();
                if (!list.isEmpty()) {
                    return list.get(0).toString();
                }
                return "";
            }
            return value.toString();
        }
        return value.toString();
    }

    private static QFilter copyQFilter(QFilter originalFilter, String newProperty, String newValue) {
        QFilter qFilter = originalFilter.__copy(false);
        qFilter.__setProperty(newProperty);
        qFilter.__setValue((Object)newValue);
        return qFilter;
    }

    protected NameVersionEntry[] getAllContainName(String baseEntityName, CompareTypeEnum compareTypeEnum, String value) {
        return NameVersionService.getInstance().getAllContainName(baseEntityName, compareTypeEnum, value);
    }

    private CompareTypeEnum getCompareTypeEnum(String cp, String value) {
        if (cp.equals("ftlike")) {
            return CompareTypeEnum.LIKE;
        }
        if (cp.equals("=")) {
            return CompareTypeEnum.EQUAL;
        }
        if (cp.equalsIgnoreCase("in")) {
            return CompareTypeEnum.IN;
        }
        if (cp.equals("like")) {
            if (value.startsWith("%") && value.endsWith("%")) {
                return CompareTypeEnum.LIKE;
            }
            if (value.startsWith("%")) {
                return CompareTypeEnum.RIGHTLIKE;
            }
            if (value.endsWith("%")) {
                return CompareTypeEnum.LEFTLIKE;
            }
            return CompareTypeEnum.LIKE;
        }
        if (cp.equals("lIKE")) {
            return CompareTypeEnum.LEFTLIKE;
        }
        if (cp.equals("LIKE")) {
            return CompareTypeEnum.LIKE;
        }
        if (cp.equals("not like")) {
            return CompareTypeEnum.NOTLIKE;
        }
        if (cp.equalsIgnoreCase("not in")) {
            return CompareTypeEnum.NOTIN;
        }
        if (cp.equals("!=")) {
            return CompareTypeEnum.NOTEQUAL;
        }
        if (cp.equals("<>")) {
            return CompareTypeEnum.NOTEQUAL;
        }
        if (cp.equals(">=")) {
            return CompareTypeEnum.GREATEROREQUAL;
        }
        if (cp.equals(">")) {
            return CompareTypeEnum.GREATER;
        }
        if (cp.equals("<=")) {
            return CompareTypeEnum.LESSOREQUAL;
        }
        if (cp.equals("<")) {
            return CompareTypeEnum.LESS;
        }
        throw new RuntimeException("invalid cp:" + cp);
    }

    private CompareTypeEnum getNotCompareTypeEnum(String cp) {
        if (cp.equalsIgnoreCase("not like")) {
            return CompareTypeEnum.LIKE;
        }
        if (cp.equalsIgnoreCase("not in")) {
            return CompareTypeEnum.IN;
        }
        if (cp.equalsIgnoreCase("!=")) {
            return CompareTypeEnum.EQUAL;
        }
        if (cp.equalsIgnoreCase("<>")) {
            return CompareTypeEnum.EQUAL;
        }
        if (cp.equalsIgnoreCase(">=")) {
            return CompareTypeEnum.LESS;
        }
        if (cp.equalsIgnoreCase(">")) {
            return CompareTypeEnum.LESSOREQUAL;
        }
        if (cp.equalsIgnoreCase("<=")) {
            return CompareTypeEnum.GREATER;
        }
        if (cp.equalsIgnoreCase("<")) {
            return CompareTypeEnum.GREATEROREQUAL;
        }
        throw new RuntimeException("invalid cp" + cp);
    }

    @Deprecated
    protected List<Object> loadMasterId(String entityName, String idProp, QFilter[] filters) {
        ArrayList<Object> idList = new ArrayList<Object>();
        String maxRowStr = System.getProperty("bos.billlist.maxRowCount", "100000");
        int maxrowcount = Integer.parseInt(maxRowStr);
        try (DataSet ds = ORM.create().queryDataSet("NameVersionBDFilter." + entityName, entityName, idProp, filters, null, maxrowcount, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return idList;
    }

    private boolean isNotCP(String cp) {
        return cp.equalsIgnoreCase("not like") || cp.equalsIgnoreCase("not in") || cp.equalsIgnoreCase("!=") || cp.equalsIgnoreCase("<>") || cp.equalsIgnoreCase(">=") || cp.equalsIgnoreCase(">") || cp.equalsIgnoreCase("<=") || cp.equalsIgnoreCase("<");
    }

    private IDataEntityType getItemClassBaseDataType(ItemClassProp itemClassProp, String baseDataName, IDataEntityType billEntityType) {
        String typePropName = itemClassProp.getTypePropName();
        ItemClassTypeProp itemClassTypeProp = (ItemClassTypeProp)billEntityType.getProperties().get((Object)typePropName);
        if (itemClassTypeProp != null && itemClassTypeProp.getItemTypes() != null) {
            return (IDataEntityType)itemClassTypeProp.getItemTypes().get(baseDataName);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IDataEntityType getBaseDataTypeWithName(IDataEntityType billEntityType, String fieldName, String nameProp) {
        IDataEntityProperty property = (IDataEntityProperty)billEntityType.getProperties().get((Object)fieldName);
        if (property == null) return null;
        IDataEntityType basedataEntityType = null;
        if (property instanceof BasedataProp) {
            if (property instanceof ItemClassProp) {
                if (!(this.originalFilter.getValue() instanceof MultiBaseDataFilterValue)) return null;
                String baseDataName = ((MultiBaseDataFilterValue)this.originalFilter.getValue()).getBaseDataName();
                basedataEntityType = this.getItemClassBaseDataType((ItemClassProp)property, baseDataName, billEntityType);
            } else {
                BasedataProp basedataProp = (BasedataProp)property;
                basedataEntityType = basedataProp.getComplexType();
            }
        } else {
            if (!(property instanceof MulBasedataProp)) return null;
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            basedataEntityType = mulBasedataProp.getComplexType();
        }
        if (!(basedataEntityType instanceof BasedataEntityType)) return null;
        if (!((BasedataEntityType)basedataEntityType).isEnableNameVersion()) {
            return null;
        }
        String nameProperty = ((BasedataEntityType)basedataEntityType).getNameProperty();
        if (!nameProp.equals(nameProperty)) return null;
        return basedataEntityType;
    }

    public QFilter getConvertQFilter() {
        if (!this.isChangeFilter) {
            return this.originalFilter;
        }
        Object[] newValue = this.matchIdList.toArray(new Object[0]);
        if (this.isNotCP(this.originalFilter.getCP())) {
            QFilter qFilter = new QFilter(this.matchProperty, "not in", (Object)newValue);
            this.originalFilter.and(qFilter);
            return this.originalFilter;
        }
        QFilter qFilter = new QFilter(this.matchProperty, "in", (Object)newValue);
        this.originalFilter.addFirstNest(qFilter, "OR");
        return this.originalFilter;
    }
}

