/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.nameversion;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IUpdateView;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.nameversion.NameVersion;
import kd.bos.entity.nameversion.NameVersionConfig;
import kd.bos.entity.nameversion.NameVersionConfigItem;
import kd.bos.entity.nameversion.NameVersionEntityType;
import kd.bos.entity.nameversion.NameVersionEntry;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.time.DateUtils;

public class NameVersionService {
    private static final String SQL_SELECTNAME = " select FENTRYID, FLOCALEID, %s as FName from %s";
    private static final String SQL_SELECTNAME_GL = " select FENTRYID, %s as FName from %s";
    private static final String SQL_SELECTENTYRID = " select distinct FID  from %s where FStartDate is not null and FEndDate is not null";
    protected static final NameVersionConfig nameVersionConfig;
    private static final String ENABLENAMEVERSION = "basedata.enablenameversion";
    private static final Log logger;
    private static NameVersionService inst;

    private static List<IDataEntityType> getEntityTypes() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(NameVersionConfig.class));
        dts.add(OrmUtils.getDataEntityType(NameVersionConfigItem.class));
        return dts;
    }

    public static NameVersionService getInstance() {
        return inst;
    }

    private boolean isEnableNameVersion() {
        String property = System.getProperty(ENABLENAMEVERSION);
        if (StringUtils.isBlank((CharSequence)property)) {
            return true;
        }
        return property.equalsIgnoreCase("true");
    }

    public DynamicObject getNameVersionData(DynamicObject baseData, DynamicObject row) {
        Date date;
        String dateField;
        if (!this.isEnableNameVersion()) {
            return baseData;
        }
        if (!(baseData.getDataEntityType() instanceof BasedataEntityType)) {
            return baseData;
        }
        BasedataEntityType basedataEntityType = (BasedataEntityType)baseData.getDataEntityType();
        if (!this.enableNameVersionControl((IDataEntityType)basedataEntityType)) {
            return baseData;
        }
        String nameProp = basedataEntityType.getNameProperty();
        if (StringUtils.isEmpty((CharSequence)nameProp)) {
            return baseData;
        }
        DynamicObject parentRow = this.getMainData(row);
        if (parentRow != null && parentRow.getDataEntityType() instanceof MainEntityType && (dateField = this.getDateField((MainEntityType)parentRow.getDataEntityType())) != null && parentRow.containsProperty(dateField) && (date = parentRow.getDate(dateField)) != null) {
            return this.getNameVersionData(baseData, baseData.getDataEntityType().getName(), date, nameProp);
        }
        return baseData;
    }

    public DynamicObject getNameVersionData(DynamicObject baseData, Date date) {
        if (!this.isEnableNameVersion()) {
            return baseData;
        }
        if (!(baseData.getDataEntityType() instanceof BasedataEntityType)) {
            return baseData;
        }
        return this.getNameVersionData(baseData, (BasedataEntityType)baseData.getDataEntityType(), date);
    }

    public void refreshValueOnDateChanged(IDataEntityType billType, DynamicObject dataEntity, IDataModel model) {
        MainEntityType mainEntityType;
        if (billType instanceof MainEntityType && StringUtils.isBlank((CharSequence)(mainEntityType = (MainEntityType)billType).getVersionControl())) {
            return;
        }
        model.beginInit();
        for (IDataEntityProperty property : billType.getProperties()) {
            this.refreshValue(property, dataEntity, model, -1, -1);
        }
        model.endInit();
    }

    private void refreshValue(IDataEntityProperty property, DynamicObject dataEntity, IDataModel model, int rowIndex, int parentRowIndex) {
        if (dataEntity == null) {
            return;
        }
        if (property instanceof FlexProp) {
            this.foreRefreshValue(property, dataEntity, model, rowIndex, parentRowIndex);
        } else if (property instanceof BasedataProp) {
            DynamicObject baseData;
            Object o = dataEntity.get(property);
            if (o instanceof DynamicObject && this.enableNameVersionControl((baseData = (DynamicObject)o).getDataEntityType())) {
                this.foreRefreshValue(property, dataEntity, model, rowIndex, parentRowIndex);
            }
        } else if (property instanceof MulBasedataProp) {
            if (this.enableNameVersionControl(((MulBasedataProp)property).getComplexType().getName())) {
                this.foreRefreshValue(property, dataEntity, model, rowIndex, parentRowIndex);
            }
        } else if (property instanceof EntryProp) {
            int currentRowIndex;
            if (property instanceof SubEntryProp && (currentRowIndex = model.getEntryCurrentRowIndex(property.getParent().getName())) != rowIndex) {
                return;
            }
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(property);
            if (entrys != null) {
                int row = model.getEntryPageInfo(property.getName()).getStartRowIndex();
                for (DynamicObject entry : entrys) {
                    for (IDataEntityProperty entryProperty : ((EntryProp)property).getItemType().getProperties()) {
                        this.refreshValue(entryProperty, entry, model, row, rowIndex);
                    }
                    ++row;
                }
            }
        }
    }

    private void foreRefreshValue(IDataEntityProperty property, DynamicObject dataEntity, IDataModel model, int rowIndex, int parentRowIndex) {
        Object data = dataEntity.get(property);
        if (data == null) {
            return;
        }
        IUpdateView view = (IUpdateView)model.getService(IUpdateView.class);
        if (view != null) {
            view.updateView(property, dataEntity, rowIndex, parentRowIndex);
        } else {
            logger.warn("\u65e0\u6cd5\u83b7\u53d6IUpdateView\u63a5\u53e3\uff0c\u5237\u65b0\u5185\u5bb9\u524d\u7aef\u63a5\u6536\u4e0d\u5230\u3002");
        }
    }

    public DynamicObject getNameVersionData(DynamicObject baseData, BasedataEntityType basedataEntityType, Date date) {
        if (!this.isEnableNameVersion()) {
            return baseData;
        }
        String nameProp = basedataEntityType.getNameProperty();
        if (StringUtils.isEmpty((CharSequence)nameProp)) {
            return baseData;
        }
        if (date == null) {
            return baseData;
        }
        return this.getNameVersionData(baseData, basedataEntityType.getName(), date, nameProp);
    }

    private DynamicObject getNameVersionData(DynamicObject baseData, String entityName, Date date, String nameProp) {
        NameVersionEntry nameVersionEntry;
        DynamicObject newData = null;
        if (baseData.containsProperty(nameProp) && (nameVersionEntry = this.getNameByDate(entityName, this.getPkValue(baseData), date)) != null) {
            newData = this.quickClone(baseData);
            newData.set(nameProp, (Object)nameVersionEntry.getName().getLocaleValue());
        }
        DataEntityPropertyCollection properties = baseData.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            NameVersionEntry nameVersionEntry2;
            BasedataEntityType subBaseDataType;
            String subNameProp;
            DynamicObject subData;
            if (!(property instanceof BasedataProp) || (subData = (DynamicObject)property.getValueFast((Object)baseData)) == null || !(subData.getDynamicObjectType() instanceof BasedataEntityType) || !StringUtils.isNotBlank((CharSequence)(subNameProp = (subBaseDataType = (BasedataEntityType)subData.getDataEntityType()).getNameProperty())) || !subData.containsProperty(subNameProp) || (nameVersionEntry2 = this.getNameByDate(subData.getDataEntityType().getName(), this.getPkValue(subData), date)) == null) continue;
            DynamicObject newSubData = this.quickClone(subData);
            newSubData.set(subNameProp, (Object)nameVersionEntry2.getName().getLocaleValue());
            if (newData == null) {
                newData = this.quickClone(baseData);
            }
            property.setValue((Object)newData, (Object)newSubData);
        }
        return newData == null ? baseData : newData;
    }

    private Object getPkValue(DynamicObject baseData) {
        Object pk = baseData.getPkValue();
        if (pk == null && baseData.containsProperty("id")) {
            return baseData.get("id");
        }
        return pk;
    }

    private DynamicObject quickClone(DynamicObject oldData) {
        DynamicObject newData = new DynamicObject(oldData.getDynamicObjectType());
        newData.setDataStorage(oldData.getDataStorage().memberClone());
        DynamicCollectionProperty localeProperty = oldData.getDynamicObjectType().getLocaleProperty();
        if (localeProperty != null) {
            LocaleDynamicObjectCollection col = (LocaleDynamicObjectCollection)localeProperty.getValueFast((Object)oldData);
            LocaleDynamicObjectCollection newLocaleCollection = null;
            if (col.getDynamicObjectType() != null) {
                newLocaleCollection = new LocaleDynamicObjectCollection(col.getDynamicObjectType(), null);
            } else if (localeProperty instanceof DynamicLocaleProperty) {
                newLocaleCollection = new LocaleDynamicObjectCollection(localeProperty.getDynamicCollectionItemPropertyType(), null);
            }
            if (newLocaleCollection != null) {
                for (DynamicObject dynamicObject : col) {
                    DynamicObject object = (DynamicObject)dynamicObject.getDynamicObjectType().createInstance();
                    object.setDataStorage(dynamicObject.getDataStorage().memberClone());
                    newLocaleCollection.add((Object)object);
                }
                localeProperty.setValue((Object)newData, (Object)newLocaleCollection);
            }
        }
        return newData;
    }

    public NameVersionEntry[] getAllContainName(String baseEntityName, CompareTypeEnum compareTypeEnum, String value) {
        if (!this.enableNameVersionControl(baseEntityName)) {
            return null;
        }
        return this.getNameVersionEntries(baseEntityName, nameVersionEntry -> this.isFilter((NameVersionEntry)nameVersionEntry, compareTypeEnum, value));
    }

    public void convertBDFilter(BasedataEntityType entityType, QFilter[] filters, Date date) {
        String nameProperty;
        if (date != null && StringUtils.isNotBlank((CharSequence)(nameProperty = entityType.getNameProperty()))) {
            for (QFilter filter : filters) {
                if (!filter.getProperty().equalsIgnoreCase(nameProperty)) continue;
                if (filter.getCP().equalsIgnoreCase("=")) {
                    NameVersionEntry[] nameVersionData = this.getContainNameByDate(entityType.getName(), date, CompareTypeEnum.EQUAL, filter.getValue().toString());
                    if (nameVersionData == null || nameVersionData.length <= 0) continue;
                    filter.__setProperty("id");
                    filter.__setValue((Object)nameVersionData[0].getId());
                    continue;
                }
                if (!filter.getCP().equals("in")) continue;
                Object value = filter.getValue();
                Object[] inValue = value instanceof Object[] ? (Object[])value : (value instanceof List ? ((List)value).toArray() : new Object[]{value});
                for (Object o : inValue) {
                    NameVersionEntry[] nameVersionData = this.getContainNameByDate(entityType.getName(), date, CompareTypeEnum.EQUAL, o.toString());
                    if (nameVersionData == null || nameVersionData.length <= 0) continue;
                    filter.or("id", "=", (Object)nameVersionData[0].getId());
                }
            }
        }
    }

    public NameVersionEntry[] getContainNameByDate(String baseEntityName, Date date, CompareTypeEnum compareTypeEnum, String value) {
        if (!this.enableNameVersionControl(baseEntityName)) {
            return null;
        }
        if (date == null) {
            return null;
        }
        return this.getNameVersionEntries(baseEntityName, nameVersionEntry -> {
            if (this.compareDate(nameVersionEntry.getStartDate(), date) <= 0 && (nameVersionEntry.getEndDate() == null || this.compareDate(nameVersionEntry.getEndDate(), date) >= 0)) {
                return this.isFilter((NameVersionEntry)nameVersionEntry, compareTypeEnum, value);
            }
            return false;
        });
    }

    private NameVersionEntry[] getNameVersionEntries(String baseEntityName, Function<NameVersionEntry, Boolean> filterFunc) {
        Tuple<Boolean, Object[]> result = this.initAllCache(baseEntityName);
        if (result != null && result.item2 != null) {
            Object[] cachePks = (Object[])result.item2;
            IDataEntityType type = this.getDataEntityType(baseEntityName);
            if (type == null) {
                return null;
            }
            Map<Object, Object> mapCacheData = this.loadVersionDataWithFilterCachePks(type, cachePks);
            ArrayList<NameVersionEntry> list = new ArrayList<NameVersionEntry>();
            for (Map.Entry<Object, Object> keyValue : mapCacheData.entrySet()) {
                NameVersion nameVersion = (NameVersion)keyValue.getValue();
                for (NameVersionEntry nameVersionEntry : nameVersion.getEntryList()) {
                    if (!"1".equals(nameVersionEntry.getEnable()) || !filterFunc.apply(nameVersionEntry).booleanValue()) continue;
                    list.add(nameVersionEntry);
                }
            }
            return list.toArray(new NameVersionEntry[0]);
        }
        return null;
    }

    private Map<Object, Object> loadVersionDataWithFilterCachePks(IDataEntityType type, Object[] cachePks) {
        if (cachePks == null || cachePks.length == 0) {
            return new HashMap<Object, Object>();
        }
        DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(type);
        Map mapCacheData = dataEntityCacheManager.get(cachePks);
        if (cachePks.length != mapCacheData.size()) {
            try (EntityTraceSpan span = EntityTracer.create((String)"nameversionservice", (String)"loadVersionDataWithFilterCachePks");){
                Object[] data;
                if (span.isRealtime()) {
                    span.addLocaleTag("cachePks", (Object)cachePks);
                    span.addLocaleTag("cacheData_old", mapCacheData.keySet());
                    span.addLocaleTag("type", (Object)type);
                }
                String entryTableName = this.getEntryProperty(type).getItemType().getAlias();
                ArrayList<Object> notFoundIds = new ArrayList<Object>();
                if (mapCacheData.size() == 0) {
                    Collections.addAll(notFoundIds, cachePks);
                } else {
                    for (Object pk : cachePks) {
                        if (mapCacheData.get(pk) != null) continue;
                        notFoundIds.add(pk);
                    }
                }
                for (Object it : data = this.loadFromDB(type, notFoundIds, entryTableName + "_L")) {
                    mapCacheData.put(type.getPrimaryKey().getValueFast(it), it);
                }
                dataEntityCacheManager.put(data);
                if (mapCacheData.size() != cachePks.length) {
                    dataEntityCacheManager.removeByFilterDt();
                    span.addLocaleTag("cachePks_changed", (Object)true);
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("NameVersionService.removeByFilterDt, name is %s, alias is %s", type.getName(), type.getAlias()));
                    }
                }
            }
        }
        return mapCacheData;
    }

    private String getLocalValue(LocaleString s) {
        if (s == null) {
            return "";
        }
        String localeValue = s.getLocaleValue();
        if (localeValue == null) {
            return "";
        }
        return localeValue;
    }

    private boolean isFilter(NameVersionEntry entry, CompareTypeEnum compareTypeEnum, String nameValue) {
        switch (compareTypeEnum) {
            case LIKE: {
                if (nameValue.startsWith("%")) {
                    nameValue = nameValue.substring(1);
                }
                if (nameValue.endsWith("%")) {
                    nameValue = nameValue.substring(0, nameValue.length() - 1);
                }
                return this.getLocalValue(entry.getName()).toLowerCase().contains(nameValue.toLowerCase());
            }
            case EQUAL: {
                return this.getLocalValue(entry.getName()).equalsIgnoreCase(nameValue);
            }
            case NOTEQUAL: {
                return !this.getLocalValue(entry.getName()).equalsIgnoreCase(nameValue);
            }
            case NOTLIKE: {
                return !this.getLocalValue(entry.getName()).toLowerCase().contains(nameValue.toLowerCase());
            }
            case LEFTLIKE: {
                if (nameValue.endsWith("%")) {
                    nameValue = nameValue.substring(0, nameValue.length() - 1);
                }
                return this.getLocalValue(entry.getName()).toLowerCase().startsWith(nameValue.toLowerCase());
            }
            case RIGHTLIKE: {
                if (nameValue.startsWith("%")) {
                    nameValue = nameValue.substring(1);
                }
                return this.getLocalValue(entry.getName()).toLowerCase().endsWith(nameValue.toLowerCase());
            }
            case IN: {
                String[] split;
                if (nameValue.startsWith("[")) {
                    nameValue = nameValue.substring(1);
                }
                if (nameValue.endsWith("]")) {
                    nameValue = nameValue.substring(0, nameValue.length() - 1);
                }
                for (String s : split = nameValue.split(",")) {
                    boolean ret = this.getLocalValue(entry.getName()).toLowerCase().contains(s.toLowerCase());
                    if (!ret) continue;
                    return ret;
                }
                break;
            }
        }
        return false;
    }

    public NameVersionEntry getNameByDate(String baseEntityName, Object pk, Date date) {
        if (!this.enableNameVersionControl(baseEntityName)) {
            return null;
        }
        if (date == null) {
            return null;
        }
        NameVersion nameVersion = this.getNameVersionFromCache(baseEntityName, pk);
        if (nameVersion != null && nameVersion.getEntryList() != null && !nameVersion.getEntryList().isEmpty()) {
            for (NameVersionEntry nameVersionEntry : nameVersion.getEntryList()) {
                if (!"1".equals(nameVersionEntry.getEnable()) || this.compareDate(nameVersionEntry.getStartDate(), date) > 0 || nameVersionEntry.getEndDate() != null && this.compareDate(nameVersionEntry.getEndDate(), date) < 0) continue;
                return nameVersionEntry;
            }
        }
        return null;
    }

    private int compareDate(Date date1, Date date2) {
        return DateUtils.truncatedCompareTo((Date)date1, (Date)date2, (int)5);
    }

    public boolean enableNameVersionControl(String entityName) {
        boolean ret;
        if (!this.isEnableNameVersion()) {
            return false;
        }
        boolean bl = ret = nameVersionConfig != null && nameVersionConfig.getItems(entityName) != null;
        if (!ret) {
            try {
                MainEntityType dataEntityType = this.getBaseDataEntityTypeFast(entityName);
                if (dataEntityType instanceof BasedataEntityType && ((BasedataEntityType)dataEntityType).isEnableNameVersion()) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return ret;
    }

    private boolean enableNameVersionControl(IDataEntityType dataEntityType) {
        boolean ret;
        if (!this.isEnableNameVersion()) {
            return false;
        }
        boolean bl = ret = nameVersionConfig != null && nameVersionConfig.getItems(dataEntityType.getName()) != null;
        if (!ret && dataEntityType instanceof BasedataEntityType && ((BasedataEntityType)dataEntityType).isEnableNameVersion()) {
            return true;
        }
        return ret;
    }

    private DynamicObject getMainData(DynamicObject row) {
        while (row != null) {
            if (row.getDataEntityType() instanceof MainEntityType) {
                return row;
            }
            if (!(row.getParent() instanceof DynamicObject)) break;
            row = (DynamicObject)row.getParent();
        }
        return null;
    }

    private String getDateField(MainEntityType entityType) {
        return entityType.getVersionControl();
    }

    private MainEntityType getBaseDataEntityTypeFast(String entityName) {
        return (MainEntityType)((Object)ThreadCache.get((Object)("nv.bdt." + entityName), () -> EntityMetadataCache.getDataEntityType(entityName)));
    }

    protected IDataEntityType getDataEntityType(String entityName) {
        BasedataEntityType basedataEntityType;
        NameVersionConfigItem item = nameVersionConfig.getItems(entityName);
        if (item != null) {
            return OrmUtils.getDataEntityType((Class)TypesContainer.getOrRegister((String)item.getClassName()));
        }
        MainEntityType dataEntityType = this.getBaseDataEntityTypeFast(entityName);
        if (dataEntityType instanceof BasedataEntityType && (basedataEntityType = (BasedataEntityType)dataEntityType).isEnableNameVersion()) {
            return NameVersionEntityType.getDataEntityType((IDataEntityType)dataEntityType, "NameVersion", NameVersion.class, o -> {
                o.setDBRouteKey(basedataEntityType.getDBRouteKey()).setAlias(basedataEntityType.getAlias());
                EntryProp name$version = (EntryProp)basedataEntityType.getProperties().get((Object)"name$version");
                if (name$version == null) {
                    return false;
                }
                ICollectionProperty entryList = this.getEntryProperty((IDataEntityType)o.getType());
                DataEntityType entryType = new NameVersionEntityType(NameVersionEntry.class).setAlias(name$version.getItemType().getAlias()).getType();
                o.setItemType(entryList, entryType);
                return true;
            });
        }
        return null;
    }

    protected ICollectionProperty getEntryProperty(IDataEntityType type) {
        return (ICollectionProperty)type.getProperties().get((Object)"EntryList");
    }

    private Tuple<Boolean, Object[]> initAllCache(String entityName) {
        IDataEntityType type = this.getDataEntityType(entityName);
        if (type != null) {
            Boolean isLoadFormCache = Boolean.TRUE;
            DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(type);
            QFilter[] filters = new QFilter[]{new QFilter("nh$id", "is not null", (Object)"")};
            Object[] cachePks = dataEntityCacheManager.getCachePks(filters);
            if (cachePks == null) {
                isLoadFormCache = Boolean.FALSE;
                String entryTableName = this.getEntryProperty(type).getItemType().getAlias();
                List<Object> idList = this.getAllId(DBRoute.of((String)type.getDBRouteKey()), entryTableName);
                Object[] data = this.loadFromDB(type, idList, entryTableName + "_L");
                dataEntityCacheManager.put(data);
                cachePks = idList.toArray();
                dataEntityCacheManager.putCachePks(filters, cachePks);
            }
            return new Tuple((Object)isLoadFormCache, (Object)cachePks);
        }
        return null;
    }

    private NameVersion getNameVersionFromCache(String entityName, Object pk) {
        try {
            Set<Object> pks = this.initAllCacheAndCachePks(entityName);
            if (pks != null) {
                if (!pks.contains(pk)) {
                    return null;
                }
                IDataEntityType type = this.getDataEntityType(entityName);
                Map<Object, Object> cacheMapData = this.loadVersionDataWithFilterCachePks(type, new Object[]{pk});
                Object o = cacheMapData.get(pk);
                if (o != null) {
                    return (NameVersion)o;
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u540d\u79f0\u7248\u672c\u5316\u521d\u59cb\u5316\u7f13\u5b58\u9519\u8bef\u3002", (Throwable)ex);
        }
        return null;
    }

    private Set<Object> initAllCacheAndCachePks(String entityName) {
        Set<Object> pkSets = null;
        Tuple<Boolean, Object[]> result = this.initAllCache(entityName);
        if (result != null && result.item2 != null) {
            Boolean isLoadFormCache = (Boolean)result.item1;
            if (isLoadFormCache.booleanValue()) {
                Object idCache = NameVersionService.getLocalCache().get(entityName);
                if (idCache == null) {
                    pkSets = new HashSet<Object>(Arrays.asList((Object[])result.item2));
                    NameVersionService.getLocalCache().put(entityName, pkSets);
                } else {
                    pkSets = (Set)idCache;
                }
            } else {
                pkSets = new HashSet<Object>(Arrays.asList((Object[])result.item2));
                NameVersionService.getLocalCache().put(entityName, pkSets);
            }
        }
        return pkSets;
    }

    private Object[] loadFromDB(IDataEntityType type, List<Object> notFindFromCachePkArray, String entryLTableName) {
        IDataManager dataManager = this.getDataManager(type);
        Object[] nameVersions = dataManager.read(notFindFromCachePkArray);
        ArrayList<Long> entryIds = new ArrayList<Long>();
        for (Object o : nameVersions) {
            NameVersion nameVersion = (NameVersion)o;
            for (NameVersionEntry nameVersionEntry : nameVersion.getEntryList()) {
                entryIds.add(nameVersionEntry.getEntryId());
            }
        }
        ICollectionProperty entryProp = this.getEntryProperty(type);
        String nameField = ((IDataEntityProperty)entryProp.getItemType().getProperties().get((Object)"Name")).getAlias();
        Map<Object, LocaleString> nameMap = this.getNameFromEntryLocaleTable(DBRoute.of((String)type.getDBRouteKey()), entryIds.toArray(), nameField, entryLTableName, entryProp.getItemType().getAlias());
        for (Object o : nameVersions) {
            NameVersion nameVersion = (NameVersion)o;
            for (NameVersionEntry nameVersionEntry : nameVersion.getEntryList()) {
                LocaleString name = nameMap.get(nameVersionEntry.getEntryId());
                if (name == null) continue;
                nameVersionEntry.setName(name);
            }
        }
        return nameVersions;
    }

    protected List<Object> getAllId(DBRoute dbRoute, String entryTable) {
        ArrayList list = new ArrayList();
        return (List)DB.query((DBRoute)dbRoute, (String)String.format(SQL_SELECTENTYRID, entryTable), rs -> {
            while (rs.next()) {
                Long entryId = rs.getLong("FID");
                list.add(entryId);
            }
            return list;
        });
    }

    protected Map<Object, LocaleString> getNameFromEntryLocaleTable(DBRoute route, Object[] entryIds, String nameField, String entryLTableName, String entryTable) {
        if (entryIds.length > 0) {
            String sql = String.format(SQL_SELECTNAME, nameField, entryLTableName);
            SqlBuilder builder = new SqlBuilder().append(sql, new Object[0]).appendIn("WHERE FENTRYID ", entryIds);
            HashMap<Object, LocaleString> nameMap = new HashMap<Object, LocaleString>();
            DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                while (rs.next()) {
                    Long entryId = rs.getLong("FENTRYID");
                    LocaleString name = (LocaleString)nameMap.get(entryId);
                    if (name == null) {
                        name = new LocaleString();
                        nameMap.put(entryId, name);
                    }
                    name.setItem(rs.getString("FLOCALEID"), (Object)rs.getString("FNAME"));
                }
                return nameMap;
            });
            String sqlGL = String.format(SQL_SELECTNAME_GL, nameField, entryTable);
            builder = new SqlBuilder().append(sqlGL, new Object[0]).appendIn("WHERE FENTRYID ", entryIds);
            DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
                while (rs.next()) {
                    Long entryId = rs.getLong("FENTRYID");
                    LocaleString name = (LocaleString)nameMap.get(entryId);
                    if (name == null) {
                        name = new LocaleString();
                        nameMap.put(entryId, name);
                    }
                    if (name.getItem("zn_CN") != null) continue;
                    name.setItem("zn_CN", (Object)rs.getString("FNAME"));
                }
                return nameMap;
            });
            return nameMap;
        }
        return new HashMap<Object, LocaleString>();
    }

    protected IDataManager getDataManager(IDataEntityType type) {
        return DataManagerUtils.getDataManager((IDataEntityType)type);
    }

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxItemSize(10);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), "NameVersionService", info);
    }

    static {
        logger = LogFactory.getLog(NameVersionService.class);
        List<IDataEntityType> dts = NameVersionService.getEntityTypes();
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        ArrayList<String> ets = new ArrayList<String>(20);
        ets.add("");
        ets.add("_FI");
        ets.add("_HR");
        ets.add("_BD");
        ets.add("_SCM");
        ets.add("_DRP");
        ets.add("_SVC");
        nameVersionConfig = new NameVersionConfig();
        for (String et : ets) {
            URL url = NameVersionService.class.getResource("/NameVersionConfig" + et + ".xml");
            if (url == null) continue;
            NameVersionConfig c = (NameVersionConfig)ser.deserialize(url, null);
            nameVersionConfig.addItems(c.items);
        }
        inst = new NameVersionService();
    }
}

