/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.FieldPos;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractOperationResult
implements IOperationResult,
Serializable {
    private static final String SPAN_TYPE_OPERATIONRESULT = "operationresult";
    private static final long serialVersionUID = 3588514605573685468L;
    boolean success = true;
    boolean needSign;
    private String clearText;
    boolean needWfAssignPersons;
    boolean cancelWriteLog;
    private String message;
    private boolean showMessage = true;
    private int billCount = 0;
    private List<Object> successPkIds = new ArrayList<Object>();
    private Map<Object, String> billNos = new HashMap<Object, String>();
    protected List<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
    private int messageType = 0;
    private List<FieldPos> promptField = new ArrayList<FieldPos>();

    @Override
    @SimplePropertyAttribute
    @KSMethod
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATIONRESULT, (String)"setMessage", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("message", (Object)message);
            }
        }
    }

    @Override
    @SimplePropertyAttribute(name="ShowMessage")
    @KSMethod
    public boolean isShowMessage() {
        return this.showMessage;
    }

    @Override
    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    @Override
    @SimplePropertyAttribute
    @KSMethod
    public List<Object> getSuccessPkIds() {
        return this.successPkIds;
    }

    @Override
    public void setSuccessPkIds(List<Object> successPkIds) {
        this.successPkIds = successPkIds;
    }

    public void addSuccessPkId(Object pkId) {
        this.successPkIds.add(pkId);
    }

    @KSMethod
    @SimplePropertyAttribute
    public Map<Object, String> getBillNos() {
        return this.billNos;
    }

    public void setBillNos(Map<Object, String> billNos) {
        this.billNos = billNos;
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=OperateErrorInfo.class)
    public List<OperateErrorInfo> getAllErrorInfo() {
        return this.errorInfos;
    }

    public void setAllErrorInfo(List<OperateErrorInfo> errorInfoes) {
        this.errorInfos = errorInfoes;
    }

    @Override
    public void addErrorInfo(OperateErrorInfo operateInfo) {
        this.errorInfos.add(operateInfo);
        this.successPkIds.remove(operateInfo.getPkValue());
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATIONRESULT, (String)"addErrorInfo", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("operateInfo", (Object)operateInfo);
            }
        }
    }

    public void removeSuccessPkIds(List<Object> pkIds) {
        if (this.successPkIds == null || this.successPkIds.isEmpty() || pkIds == null || pkIds.isEmpty()) {
            return;
        }
        this.successPkIds.removeAll(pkIds);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATIONRESULT, (String)"removePkIds", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("pkids", pkIds);
            }
        }
    }

    @Override
    @SimplePropertyAttribute(name="success")
    @KSMethod
    public boolean isSuccess() {
        if (!this.success) {
            return false;
        }
        for (OperateErrorInfo errorInfo : this.errorInfos) {
            if (errorInfo.getLevel() == ErrorLevel.Info) continue;
            return false;
        }
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @SimplePropertyAttribute
    public int getBillCount() {
        return this.billCount;
    }

    public void setBillCount(int billCount) {
        this.billCount = billCount;
    }

    @SimplePropertyAttribute(name="needSign")
    @KSMethod
    public boolean isNeedSign() {
        return this.needSign;
    }

    public void setNeedSign(boolean needSign) {
        this.needSign = needSign;
    }

    @SimplePropertyAttribute(name="clearText")
    @KSMethod
    public String getClearText() {
        return this.clearText;
    }

    public void setClearText(String clearText) {
        this.clearText = clearText;
    }

    @SimplePropertyAttribute(name="needWfAssignPersons")
    @KSMethod
    public boolean isNeedWfAssignPersons() {
        return this.needWfAssignPersons;
    }

    public void setNeedWfAssignPersons(boolean needWfAssignPersons) {
        this.needWfAssignPersons = needWfAssignPersons;
    }

    @SimplePropertyAttribute(name="CancelWriteLog")
    @KSMethod
    public boolean isCancelWriteLog() {
        return this.cancelWriteLog;
    }

    public void setCancelWriteLog(boolean cancelWriteLog) {
        this.cancelWriteLog = cancelWriteLog;
    }

    @SimplePropertyAttribute
    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=FieldPos.class)
    public List<FieldPos> getPromptField() {
        return this.promptField;
    }

    public void setPromptField(List<FieldPos> promptField) {
        this.promptField = promptField;
    }

    public void addPromptField(FieldPos fieldPos) {
        if (this.promptField.size() < 500) {
            this.promptField.add(fieldPos);
        }
    }

    public void addPromptField(List<FieldPos> fieldPos) {
        if (fieldPos == null || fieldPos.size() == 0) {
            return;
        }
        if (this.promptField.size() + fieldPos.size() <= 500) {
            this.promptField.addAll(fieldPos);
        } else {
            int count = 500 - this.promptField.size();
            this.promptField.addAll(fieldPos.subList(0, count));
        }
    }
}

