/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.OperateLog_Nothing;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class OperateLog_Monitor
extends OperateLog_Nothing {
    private static final Log log = LogFactory.getLog(OperateLog_Monitor.class);
    private Map<String, MothedInfo> mothedInfos = new LinkedHashMap<String, MothedInfo>(8);
    private List<MothedInfo> liveMothedInfos = new ArrayList<MothedInfo>(4);
    private Date beginTime = new Date();

    OperateLog_Monitor() {
    }

    public static OperateLog getInstance() {
        return new OperateLog_Monitor();
    }

    @Override
    public boolean isWriteLog() {
        return true;
    }

    @Override
    public void info(String msg) {
        log.info("\r\n" + msg);
    }

    @Override
    public void debug(String msg) {
        log.debug("\r\n" + msg);
    }

    @Override
    public void important(String msg) {
        log.info("\r\n" + msg);
    }

    @Override
    public void error(String msg) {
        log.error("\r\n" + msg);
    }

    @Override
    public void error(Throwable exp) {
        log.error(exp);
    }

    @Override
    public void Info(DynamicObject billObj) {
        if (billObj == null) {
            log.info("\r\n billInfo:null");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n billInfo:");
        sb.append("id=").append(String.valueOf(billObj.getPkValue())).append(',');
        BillEntityType mainType = null;
        if (billObj.getDataEntityType() instanceof BillEntityType) {
            mainType = (BillEntityType)billObj.getDataEntityType();
        }
        if (mainType != null) {
            if (mainType.getProperties().containsKey((Object)mainType.getBillNo())) {
                sb.append("billno=").append(billObj.getString(mainType.getBillNo())).append(',');
            }
            if (mainType.getProperties().containsKey((Object)mainType.getBillStatus())) {
                sb.append("status=").append(billObj.getString(mainType.getBillStatus())).append(',');
            }
            sb.append("table=").append(mainType.getAlias()).append(",");
        }
        DataEntityState state = billObj.getDataEntityState();
        sb.append("fromDB=").append(state.getFromDatabase()).append(',');
        sb.append("dirtyprop=");
        List dirtyProps = state.GetDirtyProperties();
        for (IDataEntityProperty prop : dirtyProps) {
            sb.append(prop.getName()).append(',');
        }
        PkSnapshotSet pksnapshots = state.getPkSnapshotSet();
        if (pksnapshots != null && !pksnapshots.Snapshots.isEmpty()) {
            for (PkSnapshot pksnapshot : pksnapshots.Snapshots) {
                if (pksnapshot == null || pksnapshot.Oids == null || mainType == null || !StringUtils.equalsIgnoreCase((CharSequence)pksnapshot.TableName, (CharSequence)mainType.getAlias())) continue;
                sb.append("Oids=").append(StringUtils.join((Object[])pksnapshot.Oids, (String)",")).append(',');
                break;
            }
        }
        log.info(sb.toString());
    }

    @Override
    public void beginMothed(String mothedName, String msg) {
        MothedInfo mothedInfo;
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            log.info("\r\n" + msg);
        }
        MothedInfo lastMothed = null;
        if (!this.liveMothedInfos.isEmpty()) {
            lastMothed = this.liveMothedInfos.get(this.liveMothedInfos.size() - 1);
        }
        if ((mothedInfo = this.mothedInfos.get(mothedName)) == null) {
            mothedInfo = new MothedInfo(mothedName, lastMothed == null ? 0 : lastMothed.getLevel() + 1);
            this.mothedInfos.put(mothedName, mothedInfo);
        } else {
            mothedInfo.setBeginTime(new Date());
        }
        this.liveMothedInfos.add(mothedInfo);
    }

    @Override
    public void endMothed(String mothedName, String msg) {
        MothedInfo mothedInfo;
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            log.info("\r\n" + msg);
        }
        if ((mothedInfo = this.mothedInfos.get(mothedName)) == null) {
            mothedInfo = new MothedInfo(mothedName, 0);
            this.mothedInfos.put(mothedName, mothedInfo);
            mothedInfo.endMothed();
            return;
        }
        mothedInfo.endMothed();
        int count = this.liveMothedInfos.size();
        for (int index = count - 1; index >= 0; --index) {
            MothedInfo lastMothed = this.liveMothedInfos.remove(index);
            lastMothed.endMothed();
            if (StringUtils.equals((CharSequence)mothedName, (CharSequence)lastMothed.getMothedName())) break;
        }
    }

    @Override
    public void removeMothed(String mothedName) {
        MothedInfo mothedInfo = this.mothedInfos.remove(mothedName);
        if (mothedInfo != null) {
            mothedInfo.endMothed();
        }
        int count = this.liveMothedInfos.size();
        for (int index = count - 1; index >= 0; --index) {
            MothedInfo lastMothed = this.liveMothedInfos.remove(index);
            lastMothed.endMothed();
            if (StringUtils.equals((CharSequence)mothedName, (CharSequence)lastMothed.getMothedName())) break;
        }
    }

    @Override
    public void finish(String entityNumber, String opKey, String opClassName, OperationResult opResult) {
        int count = this.liveMothedInfos.size();
        for (int index = count - 1; index >= 0; --index) {
            MothedInfo lastMothed = this.liveMothedInfos.remove(index);
            lastMothed.endMothed();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n");
        sb.append(entityNumber).append('.');
        sb.append(opKey).append('.').append(opClassName).append(".result: ");
        if (opResult == null) {
            sb.append("operationResult = null, ");
        } else {
            sb.append("isSuccess = ").append(opResult.isSuccess()).append(", ");
            sb.append("billCount = ").append(opResult.getBillCount()).append(", ");
            sb.append("successIds = ");
            if (opResult.getSuccessPkIds().isEmpty()) {
                sb.append("null, ");
            } else if (opResult.getSuccessPkIds().size() == 1) {
                sb.append(opResult.getSuccessPkIds().get(0)).append(", ");
            } else if (opResult.getSuccessPkIds().size() <= 3) {
                sb.append(StringUtils.join((Object[])opResult.getSuccessPkIds().toArray(), (String)",")).append(", ");
            } else {
                for (int i = 0; i < opResult.getSuccessPkIds().size() && i < 3; ++i) {
                    sb.append(String.valueOf(opResult.getSuccessPkIds().get(i)));
                    if (i < 2) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append("... ");
                }
                sb.append("total ").append(opResult.getSuccessPkIds().size()).append(" bills, ");
            }
            sb.append("\r\n");
            sb.append("Msg:").append(opResult.getMessage()).append("\r\n");
            List<IOperateInfo> errInfos = opResult.getAllErrorOrValidateInfo();
            if (errInfos.isEmpty()) {
                sb.append("ErrorInfo = null");
            } else if (errInfos.size() == 1) {
                sb.append("ErrorInfo_0 = ").append(errInfos.get(0).getMessage());
            } else {
                sb.append("ErrorInfos = ").append(errInfos.size()).append(" rows: ").append("\r\n");
                for (int i = 0; i < 10 && i < errInfos.size(); ++i) {
                    sb.append("ErrorInfo_").append(i + 1).append(": ").append(errInfos.get(i).getMessage()).append("\r\n");
                }
            }
        }
        Date endTime = new Date();
        Long time = endTime.getTime() - this.beginTime.getTime();
        sb.append("\r\n").append("execute mothed ").append(time).append("ms: \r\n");
        for (Map.Entry<String, MothedInfo> mothed : this.mothedInfos.entrySet()) {
            if (mothed.getValue() == null) continue;
            sb.append(mothed.getValue().toString()).append("\r\n");
        }
        log.info(sb.toString());
    }

    @Override
    public void finish(String title) {
        int count = this.liveMothedInfos.size();
        for (int index = count - 1; index >= 0; --index) {
            MothedInfo lastMothed = this.liveMothedInfos.remove(index);
            lastMothed.endMothed();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append(title).append(": ");
        Date endTime = new Date();
        Long time = endTime.getTime() - this.beginTime.getTime();
        sb.append("cost ").append(time).append("ms: \r\n");
        for (Map.Entry<String, MothedInfo> mothed : this.mothedInfos.entrySet()) {
            if (mothed.getValue() == null) continue;
            sb.append(mothed.getValue().toString()).append("\r\n");
        }
        log.info(sb.toString());
    }

    static class MothedInfo {
        private String mothedName;
        private int level = 0;
        private long runTime = 0L;
        private Date beginTime;

        public MothedInfo(String mothedName, int level) {
            this.mothedName = mothedName;
            this.level = level;
            this.beginTime = new Date();
        }

        public String getMothedName() {
            return this.mothedName;
        }

        public int getLevel() {
            return this.level;
        }

        public long getRunTime() {
            return this.runTime;
        }

        public Date getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(Date beginTime) {
            this.beginTime = beginTime;
        }

        public void endMothed() {
            if (this.beginTime == null) {
                return;
            }
            Date endTime = new Date();
            Long time = endTime.getTime() - this.beginTime.getTime();
            this.beginTime = null;
            this.runTime = this.getRunTime() + time;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('L').append(this.level).append(' ');
            for (int i = 0; i < this.getLevel(); ++i) {
                sb.append("    ");
            }
            sb.append(this.getMothedName());
            sb.append(' ').append(this.getRunTime()).append("ms,");
            return sb.toString();
        }
    }
}

