/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.entity.operate.OperationType;
import kd.bos.lang.Lang;

public class OperationTypes {
    private List<OperationType> opTypes = new ArrayList<OperationType>();
    private Date createTime = new Date();
    private static final long CACHE_OVERTIME = 600000L;
    private List<String> loadedLangs = new ArrayList<String>(3);

    @CollectionPropertyAttribute(collectionItemPropertyType=OperationType.class)
    public List<OperationType> getOpTypes() {
        return this.opTypes;
    }

    public void setOpTypes(List<OperationType> opTypes) {
        this.opTypes = opTypes;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isCacheOverTime() {
        Date currTime = new Date();
        if (this.createTime == null) {
            this.createTime = new Date();
        }
        return Long.compare(currTime.getTime() - this.createTime.getTime(), 600000L) > 0;
    }

    public boolean isLoaded(Lang lang) {
        if (lang == null) {
            return true;
        }
        return this.loadedLangs.contains(lang.toString());
    }

    public void setLoaded(Lang lang) {
        if (lang != null && !this.loadedLangs.contains(lang.toString())) {
            this.loadedLangs.add(lang.toString());
        }
    }
}

