/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.bizrule;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.lang.Lang;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OpBizRuleTypes {
    private List<OpBizRuleType> ruleTypes = new ArrayList<OpBizRuleType>();
    private Date cacheTime = new Date();
    private static final long CACHE_OVERTIME = 28800000L;
    private List<String> loadedLangs = new ArrayList<String>(3);
    private AtomicBoolean extendExpired = new AtomicBoolean(false);

    public OpBizRuleTypes() {
    }

    public OpBizRuleTypes(List<OpBizRuleType> ruleTypes, Date cacheTime) {
        this.ruleTypes = ruleTypes;
        this.cacheTime = cacheTime;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=OpBizRuleType.class)
    public List<OpBizRuleType> getRuleTypes() {
        return this.ruleTypes;
    }

    public void setRuleTypes(List<OpBizRuleType> ruleTypes) {
        this.ruleTypes = ruleTypes;
    }

    @SimplePropertyAttribute
    public Date getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(Date cacheTime) {
        this.cacheTime = cacheTime;
    }

    public boolean isCacheOverTime() {
        final Date currTime = new Date();
        if (this.cacheTime == null) {
            this.cacheTime = new Date();
        }
        boolean result = false;
        Function<Date, Boolean> comparetor = new Function<Date, Boolean>(){

            @Override
            public Boolean apply(Date cacheTime) {
                return currTime.getTime() - cacheTime.getTime() > 28800000L;
            }
        };
        if (((Boolean)comparetor.apply(this.cacheTime)).booleanValue()) {
            if (this.extendExpired.compareAndSet(false, true)) {
                this.cacheTime = new Date(this.cacheTime.getTime() + 600000L);
                result = true;
            } else {
                result = (Boolean)comparetor.apply(this.cacheTime);
            }
        }
        return result;
    }

    public List<OpBizRuleType> filterRuleTypes(String appNumber, String entityNumber, String opType) {
        if (this.ruleTypes == null) {
            return new ArrayList<OpBizRuleType>(0);
        }
        ArrayList<OpBizRuleType> list = new ArrayList<OpBizRuleType>(this.ruleTypes.size());
        for (OpBizRuleType ruleType : this.ruleTypes) {
            boolean isMyDish = true;
            switch (ruleType.getAppliedRange()) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    isMyDish = isMyDish && this.isMyDish(ruleType.getAppliedAppNumbers(), appNumber);
                    break;
                }
                case 3: {
                    isMyDish = isMyDish && this.isMyDish(ruleType.getAppliedEntityNumber(), entityNumber);
                    break;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)opType)) {
                boolean bl = isMyDish = isMyDish && this.isMyDish(ruleType.getOpBlackList(), opType);
                if (StringUtils.isNotBlank((CharSequence)ruleType.getOpBlackList())) {
                    boolean bl2 = isMyDish = isMyDish && !this.isMyDish(ruleType.getOpBlackList(), opType);
                }
            }
            if (!isMyDish) continue;
            list.add(ruleType);
        }
        return list;
    }

    private boolean isMyDish(String me, String dish) {
        String[] numbers;
        if (StringUtils.isBlank((CharSequence)me)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dish)) {
            return true;
        }
        for (String number : numbers = me.split(",")) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)number, (CharSequence)dish)) continue;
            return true;
        }
        return false;
    }

    public OpBizRuleTypes copy() {
        OpBizRuleTypes types = new OpBizRuleTypes();
        for (OpBizRuleType it : this.ruleTypes) {
            types.getRuleTypes().add(it.copy());
        }
        types.loadedLangs.addAll(this.loadedLangs);
        types.cacheTime = this.cacheTime;
        types.extendExpired.set(this.extendExpired.get());
        return types;
    }

    public boolean isLoaded(Lang lang) {
        if (lang == null) {
            return true;
        }
        return this.loadedLangs.contains(lang.toString());
    }

    public void setLoaded(Lang lang) {
        if (lang != null && !this.loadedLangs.contains(lang.toString())) {
            this.loadedLangs.add(lang.toString());
        }
    }
}

