/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.interaction;

import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.exception.KDBizException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class KDInteractionException
extends KDBizException {
    private static final long serialVersionUID = 8781166660609561674L;
    private String sponsor;
    private InteractionContext interactionContext;

    public KDInteractionException(String sponsor, InteractionContext interactionContext) {
        super(interactionContext.getSimpleMessage());
        this.sponsor = sponsor;
        this.interactionContext = interactionContext;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)"interactionexception", (String)"~init", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("sponsor", (Object)sponsor);
                span.addLocaleTag("interactioncontext", (Object)interactionContext);
            }
        }
    }

    public String getSponsor() {
        return this.sponsor;
    }

    public InteractionContext getInteractionContext() {
        return this.interactionContext;
    }
}

