/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.result;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.entity.operate.interaction.IInteractionRequest;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class OperationResult
extends AbstractOperationResult
implements IInteractionRequest,
Serializable {
    private static Log log = LogFactory.getLog(OperationResult.class);
    private static final long serialVersionUID = 2068996817197988238L;
    private ValidateResultCollection validateResultCollection = new ValidateResultCollection();
    private String sponsor;
    private InteractionContext interactionContext;
    private Date startTime;
    private Date finishedTime;
    private Map<String, String> customData = new HashMap<String, String>(3);

    @Override
    @KSMethod
    @JsonIgnore
    public List<IOperateInfo> getAllErrorOrValidateInfo() {
        ArrayList<IOperateInfo> list = new ArrayList<IOperateInfo>(this.errorInfos);
        if (this.validateResultCollection != null && !this.validateResultCollection.getValidateErrors().isEmpty()) {
            for (ValidateResult vr : this.validateResultCollection.getValidateErrors()) {
                list.addAll(vr.getAllErrorInfo());
            }
        }
        Collections.sort(list, (o1, o2) -> {
            int result = 0;
            try {
                if ((ObjectUtils.isEmpty((Object)o1) || ObjectUtils.isEmpty((Object)o1.getPkValue())) && (ObjectUtils.isEmpty((Object)o2) || ObjectUtils.isEmpty((Object)o2.getPkValue()))) {
                    return 0;
                }
                if (ObjectUtils.isEmpty((Object)o1) || ObjectUtils.isEmpty((Object)o1.getPkValue())) {
                    result = -1;
                } else if (ObjectUtils.isEmpty((Object)o2) || ObjectUtils.isEmpty((Object)o2.getPkValue())) {
                    result = 1;
                } else {
                    long o2Val;
                    long o1Val = this.getLongValue(o1.getPkValue());
                    long r = o1Val - (o2Val = this.getLongValue(o2.getPkValue()));
                    if (r > 0L) {
                        result = 1;
                    } else if (r < 0L) {
                        result = -1;
                    }
                }
            }
            catch (Exception e) {
                log.warn(String.format("OperationResult compare error:%s - %s", o1.getPkValue(), o2.getPkValue()));
            }
            return result;
        });
        return list;
    }

    private long getLongValue(Object value) {
        long result = value instanceof Integer ? (long)((Integer)value).intValue() : ((Number)value).longValue();
        return result;
    }

    @KSMethod
    @ComplexPropertyAttribute
    public ValidateResultCollection getValidateResult() {
        return this.validateResultCollection;
    }

    public void setValidateResult(ValidateResultCollection validateResultCollection) {
        this.validateResultCollection = validateResultCollection;
    }

    @Override
    @SimplePropertyAttribute(name="success")
    @KSMethod
    public boolean isSuccess() {
        return super.isSuccess() && this.validateResultCollection.isSuccess();
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute
    public String getSponsor() {
        return this.sponsor;
    }

    public void setSponsor(String sponsor) {
        this.sponsor = sponsor;
    }

    @Override
    @KSMethod
    @ComplexPropertyAttribute
    public InteractionContext getInteractionContext() {
        return this.interactionContext;
    }

    public void setInteractionContext(InteractionContext interactionContext) {
        this.interactionContext = interactionContext;
    }

    @SimplePropertyAttribute
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @SimplePropertyAttribute
    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public long getRunSecond() {
        if (this.startTime == null || this.finishedTime == null) {
            return 0L;
        }
        return (this.finishedTime.getTime() - this.startTime.getTime()) / 1000L;
    }

    public void mergeOperateResult(OperationResult opResult) {
        if (opResult == null) {
            return;
        }
        this.setBillCount(this.getBillCount() + opResult.getBillCount());
        this.setMessage(opResult.getMessage());
        this.setShowMessage(opResult.isShowMessage());
        this.getSuccessPkIds().addAll(opResult.getSuccessPkIds());
        this.getBillNos().putAll(opResult.getBillNos());
        this.getAllErrorInfo().addAll(opResult.getAllErrorInfo());
        for (ValidateResult vResult : opResult.getValidateResult().getValidateErrors()) {
            this.getValidateResult().addValidateError(vResult.getValidatorKey(), vResult);
        }
        this.setCancelWriteLog(opResult.isCancelWriteLog());
        this.setClearText(opResult.getClearText());
        this.setFinishedTime(opResult.getFinishedTime());
        this.setNeedSign(opResult.isNeedSign());
        if (opResult.getCustomData() != null) {
            if (this.getCustomData() == null) {
                this.setCustomData(new HashMap<String, String>(3));
            }
            this.getCustomData().putAll(opResult.getCustomData());
        }
        if (this.getSponsor() == null) {
            this.setSponsor(opResult.getSponsor());
        }
    }

    public void mergeSubOpResult(OperationResult subOpResult) {
        if (subOpResult == null) {
            return;
        }
        if (subOpResult.getMessage() != null) {
            this.setMessage(subOpResult.getMessage());
        }
        this.setShowMessage(subOpResult.isShowMessage());
        HashSet<Object> opIds = new HashSet<Object>(this.getSuccessPkIds());
        HashSet<Object> subOpIds = new HashSet<Object>(subOpResult.getSuccessPkIds());
        opIds.retainAll(subOpIds);
        ArrayList<Object> successPkIds = new ArrayList<Object>(opIds);
        this.setSuccessPkIds(successPkIds);
        this.getAllErrorInfo().addAll(subOpResult.getAllErrorInfo());
        for (ValidateResult vResult : subOpResult.getValidateResult().getValidateErrors()) {
            this.getValidateResult().addValidateError(vResult.getValidatorKey(), vResult);
        }
        this.setCancelWriteLog(subOpResult.isCancelWriteLog());
        this.setClearText(subOpResult.getClearText());
        this.setFinishedTime(subOpResult.getFinishedTime());
        this.setNeedSign(subOpResult.isNeedSign());
        if (this.getSponsor() == null) {
            this.setSponsor(subOpResult.getSponsor());
        }
    }

    @SimplePropertyAttribute
    public Map<String, String> getCustomData() {
        return this.customData;
    }

    public void setCustomData(Map<String, String> customData) {
        this.customData = customData;
    }

    public String toString() {
        return SerializationUtils.toJsonString((Object)this);
    }
}

