/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.Event;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Plugin
implements Serializable {
    private static final long serialVersionUID = 7949514025361196078L;
    private String className;
    private boolean enabled = true;
    private String description;
    private int rowKey;
    private int type = 0;
    private String fpk;
    private boolean isInherit;
    private String sourceNumber;
    private List<Event> events = new ArrayList<Event>();
    public static final int PluginType_JavaClass = 0;
    public static final int PluginType_JavaScript = 1;
    public static final int PluginType_JavaKingScript = 4;
    public static final int PluginType_TestJavaClass = 2;
    public static final int PluginType_TestJavaScript = 3;
    private static final List<String> kScriptSupportList = new ArrayList<String>(10);
    private static final String MC_KINGSCRIPT_RUN_PARAM = "kingscript.service.enable";
    private static final String MC_KINGSCRIPT_REGISTER_PARAM = "kingscript.plugin.enable";
    private String scriptNumber;
    private boolean dynamicPlugin;

    public static boolean enableRunKingScript() {
        return Plugin.getPropertyOrReturnTrue(() -> System.getProperty(MC_KINGSCRIPT_RUN_PARAM));
    }

    public static boolean enableRegisterKingScript() {
        return Plugin.enableRegisterKingScript(null);
    }

    public static boolean enableRegisterKingScript(String modelType) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)modelType) && !kScriptSupportList.contains(modelType)) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        return Plugin.getPropertyOrReturnTrue(() -> SystemPropertyUtils.getProptyByTenant((String)MC_KINGSCRIPT_REGISTER_PARAM, (String)tenantId));
    }

    @Deprecated
    public static boolean enableKingScript() {
        return Plugin.enableKingScript("");
    }

    @Deprecated
    public static boolean enableKingScript(String modelType) {
        if ("EngineInitial".equals(modelType) || "ScriptInitial".equals(modelType)) {
            return Plugin.getPropertyOrReturnTrue(() -> System.getProperty(MC_KINGSCRIPT_RUN_PARAM));
        }
        if (StringUtils.isBlank((CharSequence)modelType) || !kScriptSupportList.contains(modelType)) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        return Plugin.getPropertyOrReturnTrue(() -> SystemPropertyUtils.getProptyByTenant((String)MC_KINGSCRIPT_REGISTER_PARAM, (String)tenantId));
    }

    private static boolean getPropertyOrReturnTrue(Supplier<String> supplier) {
        String value = supplier.get();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    @SimplePropertyAttribute(name="Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="false")
    public boolean isDynamicPlugin() {
        return this.dynamicPlugin;
    }

    public void setDynamicPlugin(boolean dynamicPlugin) {
        this.dynamicPlugin = dynamicPlugin;
    }

    @SimplePropertyAttribute(name="Enabled")
    @DefaultValueAttribute(value="true")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @SimplePropertyAttribute(name="RowKey")
    public int getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(int rowKey) {
        this.rowKey = rowKey;
    }

    @SimplePropertyAttribute
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Event.class)
    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Plugin) {
            Plugin plugin = (Plugin)obj;
            return plugin.className.equalsIgnoreCase(this.getClassName());
        }
        return false;
    }

    @SimplePropertyAttribute(name="ScriptNumber")
    public String getScriptNumber() {
        return this.scriptNumber;
    }

    public void setScriptNumber(String scriptNumber) {
        this.scriptNumber = scriptNumber;
    }

    @SimplePropertyAttribute
    public String getFpk() {
        return this.fpk;
    }

    public void setFpk(String fpk) {
        this.fpk = fpk;
    }

    @SimplePropertyAttribute
    public boolean isInherit() {
        return this.isInherit;
    }

    public void setInherit(boolean inherit) {
        this.isInherit = inherit;
    }

    @SimplePropertyAttribute
    public String getSourceNumber() {
        return this.sourceNumber;
    }

    public void setSourceNumber(String sourceNumber) {
        this.sourceNumber = sourceNumber;
    }

    static {
        kScriptSupportList.add("EngineInitial");
        kScriptSupportList.add("ScriptInitial");
        kScriptSupportList.add("DynamicFormModel");
        kScriptSupportList.add("CardModel");
        kScriptSupportList.add("BillFormModel");
        kScriptSupportList.add("MobileBillFormModel");
        kScriptSupportList.add("MobileFormModel");
        kScriptSupportList.add("BaseFormModel");
        kScriptSupportList.add("KMModel");
        kScriptSupportList.add("WidgetFormModel");
        kScriptSupportList.add("MobileListModel");
        kScriptSupportList.add("BizExtPlugin");
        kScriptSupportList.add("ConvertRuleModel");
        kScriptSupportList.add("WriteBackRuleModel");
        kScriptSupportList.add("PrintModel");
        kScriptSupportList.add("ReportFormModel");
        kScriptSupportList.add("WORKFLOW_PLUGIN_MODEL");
    }
}

