/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin.args;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SensitiveArgs
extends EventObject {
    private Map<String, SensitiveRule> sensitivefieldMap = new HashMap<String, SensitiveRule>(16);
    private DesensitiveFun desensitiveFun = (field, value) -> {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        int len = value.length();
        if (len < 9) {
            return "****";
        }
        return value.replaceAll("(.{" + (len < 12 ? 3 : 6) + "})(.*)(.{4})", "$1****$3");
    };

    public SensitiveArgs(Object source) {
        super(source);
    }

    public boolean contain(String field) {
        return this.sensitivefieldMap.containsKey(field);
    }

    public void addField(String field) {
        this.sensitivefieldMap.put(field, null);
    }

    public void addField(String field, String regex, String replacement) {
        SensitiveRule rule = new SensitiveRule(regex, replacement);
        this.sensitivefieldMap.put(field, rule);
    }

    public void addField(String field, SensitiveRule rule) {
        this.sensitivefieldMap.put(field, rule);
    }

    public void addField(List<String> fields) {
        fields.stream().forEach(key -> this.sensitivefieldMap.put((String)key, (SensitiveRule)null));
    }

    public void addField(Map<String, SensitiveRule> fieldMap) {
        this.sensitivefieldMap.putAll(fieldMap);
    }

    public void clearField() {
        this.sensitivefieldMap.clear();
    }

    public SensitiveRule getRule(String field) {
        return this.sensitivefieldMap.get(field);
    }

    public DesensitiveFun getDesensitiveFun() {
        return this.desensitiveFun;
    }

    public void setDesensitiveFun(DesensitiveFun desensitiveFun) {
        this.desensitiveFun = desensitiveFun;
    }

    @FunctionalInterface
    public static interface DesensitiveFun {
        public String handle(String var1, String var2);
    }

    public static class SensitiveRule {
        public String regex;
        public String replacement;

        public SensitiveRule(String regex, String replacement) {
            this.regex = regex;
            this.replacement = replacement;
        }
    }
}

