/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin.manager;

import java.util.Arrays;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ParamCondition;
import kd.bos.entity.plugin.manager.EventAction;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.EventMethodTypes;

public class EventMethodMatcher {
    private EventMethod eventMethod;
    private EventAction action;
    private ParamCondition paramCondition;

    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public void setEventMethod(EventMethod eventMethod) {
        this.eventMethod = eventMethod;
    }

    public EventAction getAction() {
        return this.action;
    }

    public void setAction(EventAction action) {
        this.action = action;
    }

    public ParamCondition getParamCondition() {
        return this.paramCondition;
    }

    public void setParamCondition(ParamCondition paramCondition) {
        this.paramCondition = paramCondition;
    }

    public static EventMethodMatcher createMatcherByEventId(String eventId) {
        EventMethodMatcher eventMethodMatcher = new EventMethodMatcher();
        EventMethod eventMethod = EventMethodTypes.getEventMethod(eventId);
        eventMethodMatcher.setEventMethod(eventMethod);
        return eventMethodMatcher;
    }

    public boolean match(EventMethod eventMethod) {
        boolean matchMethodAndAction;
        boolean bl = matchMethodAndAction = EventAction.OVERRIDE == this.action && this.matchMethodNameParam(eventMethod);
        if (matchMethodAndAction && Objects.nonNull(eventMethod.getConditionEvent()) && Objects.nonNull(this.paramCondition) && StringUtils.isNotBlank((CharSequence)this.paramCondition.getExpression())) {
            return eventMethod.getConditionEvent().check(this.paramCondition);
        }
        return matchMethodAndAction;
    }

    public boolean matchMethodNameParam(EventMethod eventMethod) {
        if (eventMethod == null || this.eventMethod == null) {
            return false;
        }
        return Objects.equals(this.eventMethod.getMethodName(), eventMethod.getMethodName()) && Arrays.equals(this.eventMethod.getParams(), eventMethod.getParams());
    }
}

