/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.plugin.manager.EventAction;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.EventMethodMatcher;
import kd.bos.entity.plugin.manager.IPluginManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class PluginManager
implements IPluginManager {
    private static Log logger = LogFactory.getLog(PluginManager.class);
    private static boolean pluginOverrideEnable = Boolean.parseBoolean(System.getProperty("plugin.override.enable", "true"));
    private static final String PLUGIN_OVERRIDE_ENABLE = "plugin.override.enable";
    private Map<String, List<EventMethodMatcher>> eventMethodMatcherMap = new HashMap<String, List<EventMethodMatcher>>();
    private Set<String> monitorEventMethodNames = new LinkedHashSet<String>();
    private boolean existEventAction = false;

    public static boolean enablePluginOverride() {
        return pluginOverrideEnable;
    }

    @Override
    public void init(List<Plugin> plugins) {
        for (Plugin pluginEntity : plugins) {
            pluginEntity.getEvents().forEach(event -> {
                if (Objects.nonNull(event.getAction())) {
                    this.existEventAction = true;
                }
                EventMethodMatcher matcher = EventMethodMatcher.createMatcherByEventId(event.getId());
                matcher.setAction(EventAction.valueOf(event.getAction()));
                matcher.setParamCondition(event.getParamCondition());
                this.monitorEventMethodNames.add(matcher.getEventMethod().getMethodName());
                List<EventMethodMatcher> matchers = this.eventMethodMatcherMap.get(pluginEntity.getClassName());
                if (Objects.isNull(matchers)) {
                    matchers = new ArrayList<EventMethodMatcher>();
                }
                matchers.add(matcher);
                this.eventMethodMatcherMap.putIfAbsent(pluginEntity.getClassName(), matchers);
            });
        }
    }

    @Override
    public boolean isNotOverride(EventMethod eventMethod, Class<?> pluginClass) {
        if (!PluginManager.enablePluginOverride()) {
            return true;
        }
        try {
            if (!this.existEventAction) {
                return true;
            }
            if (!this.monitorEventMethodNames.contains(eventMethod.getMethodName())) {
                return true;
            }
            List<EventMethodMatcher> eventMethodMatchers = this.eventMethodMatcherMap.get(pluginClass.getName());
            if (Objects.nonNull(eventMethodMatchers) && !eventMethodMatchers.isEmpty()) {
                for (EventMethodMatcher eventMethodMatcher : eventMethodMatchers) {
                    if (!eventMethodMatcher.match(eventMethod)) continue;
                    return false;
                }
            }
        }
        catch (Throwable e) {
            logger.error("\u89e3\u6790\u63d2\u4ef6\u8986\u76d6\u5f02\u5e38", e);
        }
        return true;
    }

    static {
        ConfigurationUtil.observeChange((String)PLUGIN_OVERRIDE_ENABLE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                pluginOverrideEnable = Boolean.parseBoolean(System.getProperty(PluginManager.PLUGIN_OVERRIDE_ENABLE));
            }
        });
    }
}

