/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.entity.datamodel.AmountPrecision;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class AmountProp
extends DecimalProp {
    private static final long serialVersionUID = -6100141695665982182L;
    public static final String PrecisionPropName = "amtprecision";

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        return new AmountColumnDesc(col.getKey(), this, col.getFieldProp());
    }

    @Override
    protected String getPrecisionPropName() {
        return PrecisionPropName;
    }

    @Override
    public Map<String, Object> createEntityTreeNode(EntityTreeNode entityTreeNode) {
        Map<String, Object> col = super.createEntityTreeNode(entityTreeNode);
        col.put("DataType", "amount");
        return col;
    }

    @Override
    @SdkInternal
    protected boolean checkPrecision(BigDecimal v) {
        if (Boolean.getBoolean("checkamountprecision")) {
            return super.checkPrecision(v);
        }
        return true;
    }

    @Override
    public NumberPrecision create(FormatObject formatObject) {
        return new AmountPrecision(formatObject);
    }

    @Override
    public Integer getDefaultPrecision() {
        return (Integer)FmtInfoUtils.getMainCurrencyFmt().get("ap");
    }
}

