/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BillStatusProp
extends ComboProp {
    private static final long serialVersionUID = 480736271637402724L;
    private List<StatusItemPro> statusItems = new ArrayList<StatusItemPro>();

    @CollectionPropertyAttribute(collectionItemPropertyType=StatusItemPro.class)
    @KSMethod
    public List<StatusItemPro> getStatusItems() {
        return this.statusItems;
    }

    public void setStatusItems(List<StatusItemPro> statusItems) {
        this.statusItems = statusItems;
    }

    @KSMethod
    public StatusItemPro getStatusItem(String statusKey) {
        for (StatusItemPro item : this.getStatusItems()) {
            if (!item.statuskey.equals(statusKey)) continue;
            return item;
        }
        return null;
    }

    @Override
    @KSMethod
    public boolean isEmptyItems() {
        return this.getStatusItems().isEmpty();
    }

    @Override
    @KSMethod
    public boolean isExistItem(String name) {
        for (StatusItemPro item : this.getStatusItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)item.getStatusKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    @KSMethod
    public String getItemByName(String statusKey) {
        StatusItemPro item = this.getStatusItem(statusKey);
        if (item == null || item.getStatusName() == null) {
            return "";
        }
        return item.getStatusName().toString();
    }

    @Override
    public long getEstimatedLen() {
        return 1L;
    }

    public static class StatusItemPro
    implements Serializable {
        private static final long serialVersionUID = -7359278498650569495L;
        private String statuskey;
        private LocaleString statusname;
        private String operatorer = "";
        private String operatordate = "";
        boolean clearoperatorfield;

        @KSMethod
        @SimplePropertyAttribute(isPrimaryKey=true)
        public String getStatusKey() {
            return this.statuskey;
        }

        public void setStatusKey(String statusKey) {
            this.statuskey = statusKey;
        }

        @KSMethod
        @SimplePropertyAttribute
        public LocaleString getStatusName() {
            return this.statusname;
        }

        public void setStatusName(LocaleString statusname) {
            this.statusname = statusname;
        }

        @KSMethod
        @SimplePropertyAttribute
        @DefaultValueAttribute(value="")
        public String getOperationerKey() {
            return this.operatorer;
        }

        public void setOperationerKey(String operatorer) {
            this.operatorer = operatorer;
        }

        @KSMethod
        @SimplePropertyAttribute
        @DefaultValueAttribute(value="")
        public String getOperationDateKey() {
            return this.operatordate;
        }

        public void setOperationDateKey(String operatordate) {
            this.operatordate = operatordate;
        }

        @KSMethod
        @SimplePropertyAttribute
        public boolean getClearOperationKey() {
            return this.clearoperatorfield;
        }

        public void setClearOperationKey(boolean clearoperatorfield) {
            this.clearoperatorfield = clearoperatorfield;
        }
    }
}

