/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

class BufferData {
    private static final int INT_TYPE = 0;
    private static final int LONG_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int ARRAY_TYPE = 3;
    private static final int ARRAY_ARRAY_TYPE = 4;
    private static final int BOOL_TYPE = 5;
    private static final int BIGDECIMAL_TYPE = 6;
    private static final int NULL_TYPE = 99;
    private static final BigInteger MAX_LONG_BIGINTEGER = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_BIGINTEGER = BigInteger.valueOf(Long.MIN_VALUE);

    BufferData() {
    }

    public byte[] toBytes(Object[] data) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(4096);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)stream);
        this.writeArray(data, codedOutputStream);
        codedOutputStream.flush();
        stream.close();
        return stream.toByteArray();
    }

    public List<Object> parseFrom(byte[] bufData) throws IOException {
        CodedInputStream codedInputStream = CodedInputStream.newInstance((byte[])bufData);
        return this.readArray(codedInputStream);
    }

    private void writeArray(Object[] data, CodedOutputStream codedOutputStream) throws IOException {
        int[] types = this.writeTypes(codedOutputStream, data, true);
        this.writeObject(codedOutputStream, types, data);
    }

    private void writeObject(CodedOutputStream codedOutputStream, int[] types, Object[] data) throws IOException {
        int i = 0;
        block9: for (Object d : data) {
            int type = types[i++];
            switch (type) {
                case 0: {
                    codedOutputStream.writeInt32NoTag(((Integer)d).intValue());
                    continue block9;
                }
                case 1: {
                    codedOutputStream.writeInt64NoTag(((Long)d).longValue());
                    continue block9;
                }
                case 2: {
                    codedOutputStream.writeStringNoTag((String)d);
                    continue block9;
                }
                case 3: {
                    Object[] subData = (Object[])d;
                    this.writeArray(subData, codedOutputStream);
                    continue block9;
                }
                case 4: {
                    Object[] subData = (Object[])d;
                    this.writeCollection(codedOutputStream, subData);
                    continue block9;
                }
                case 5: {
                    codedOutputStream.writeBoolNoTag(((Boolean)d).booleanValue());
                    continue block9;
                }
                case 6: {
                    this.writeBigDecimal(codedOutputStream, (BigDecimal)d);
                }
            }
        }
    }

    private void writeCollection(CodedOutputStream codedOutputStream, Object[] data) throws IOException {
        int[] types = this.writeTypes(codedOutputStream, (Object[])data[0], true);
        codedOutputStream.writeInt32NoTag(data.length);
        for (int i = 0; i < data.length; ++i) {
            Object[] row = (Object[])data[i];
            this.writeObject(codedOutputStream, types, row);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] writeTypes(CodedOutputStream codedOutputStream, Object[] data, boolean canNull) throws IOException {
        codedOutputStream.writeInt32NoTag(data.length);
        int[] types = new int[data.length];
        int i = 0;
        int type = 0;
        for (Object d : data) {
            if (d != null) {
                if (d instanceof String) {
                    type = 2;
                } else if (d instanceof Integer) {
                    type = 0;
                } else if (d instanceof Long) {
                    type = 1;
                } else if (d.getClass().isArray()) {
                    Object[] subD = (Object[])d;
                    type = subD.length > 0 && subD[0].getClass().isArray() ? 4 : 3;
                } else if (d instanceof Boolean) {
                    type = 5;
                } else {
                    if (!(d instanceof BigDecimal)) throw new RuntimeException("unkown data type " + d.getClass());
                    type = 6;
                }
            } else {
                if (!canNull) {
                    throw new RemoteException("value can't be null");
                }
                type = 99;
            }
            types[i++] = type;
            codedOutputStream.writeInt32NoTag(type);
        }
        return types;
    }

    private int[] readTypes(CodedInputStream codedInputStream) throws IOException {
        int length = codedInputStream.readInt32();
        int[] dataType = new int[length];
        for (int i = 0; i < length; ++i) {
            dataType[i] = codedInputStream.readInt32();
        }
        return dataType;
    }

    private void readObject(CodedInputStream codedInputStream, int[] dataType, List<Object> list) throws IOException {
        int index = 0;
        for (int type : dataType) {
            switch (type) {
                case 0: {
                    list.add(codedInputStream.readInt32());
                    break;
                }
                case 1: {
                    list.add(codedInputStream.readInt64());
                    break;
                }
                case 2: {
                    list.add(codedInputStream.readString());
                    break;
                }
                case 3: {
                    list.add(this.readArray(codedInputStream));
                    break;
                }
                case 4: {
                    list.add(this.readCollection(codedInputStream));
                    break;
                }
                case 5: {
                    list.add(codedInputStream.readBool());
                    break;
                }
                case 6: {
                    list.add(this.readBigDecimal(codedInputStream));
                    break;
                }
                case 99: {
                    list.add(null);
                }
            }
            ++index;
        }
    }

    private Object readCollection(CodedInputStream codedInputStream) throws IOException {
        int[] dataTypes = this.readTypes(codedInputStream);
        int length = codedInputStream.readInt32();
        ArrayList<ArrayList<Object>> data = new ArrayList<ArrayList<Object>>(length);
        for (int i = 0; i < length; ++i) {
            ArrayList<Object> rows = new ArrayList<Object>(dataTypes.length);
            this.readObject(codedInputStream, dataTypes, rows);
            data.add(rows);
        }
        return data;
    }

    private List<Object> readArray(CodedInputStream codedInputStream) throws IOException {
        int[] dataType = this.readTypes(codedInputStream);
        ArrayList<Object> data = new ArrayList<Object>(16);
        this.readObject(codedInputStream, dataType, data);
        return data;
    }

    private BigDecimal readBigDecimal(CodedInputStream codedInputStream) throws IOException {
        BigInteger bigInteger;
        int scale = codedInputStream.readInt32();
        boolean isLong = codedInputStream.readBool();
        if (isLong) {
            long l = codedInputStream.readInt64();
            bigInteger = BigInteger.valueOf(l);
        } else {
            bigInteger = new BigInteger(codedInputStream.readByteArray());
        }
        return new BigDecimal(bigInteger, scale);
    }

    private void writeBigDecimal(CodedOutputStream codedOutputStream, BigDecimal value) throws IOException {
        BigInteger bigInteger = value.unscaledValue();
        int scale = value.scale();
        codedOutputStream.writeInt32NoTag(scale);
        if (bigInteger.compareTo(MIN_LONG_BIGINTEGER) >= 0 && bigInteger.compareTo(MAX_LONG_BIGINTEGER) <= 0) {
            codedOutputStream.writeBoolNoTag(true);
            codedOutputStream.writeInt64NoTag(bigInteger.longValue());
        } else {
            codedOutputStream.writeBoolNoTag(false);
            codedOutputStream.writeByteArrayNoTag(bigInteger.toByteArray());
        }
    }
}

