/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DateColumnDesc;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DateProp
extends DateTimeProp {
    private static final long serialVersionUID = 1593941437706854539L;

    public DateProp() {
        this.setRegionType(FormatTypes.Date.getValue());
    }

    @Override
    public int getDbType() {
        return 91;
    }

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        return new DateColumnDesc(col.getKey(), this, col.getFieldProp());
    }

    @Override
    public String getClientType() {
        return "date";
    }

    @Override
    public DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public String getFilterControlType() {
        return "date";
    }

    @Override
    public Date parse(Object dataEntity, String date) throws ParseException {
        Date value = super.parse(dataEntity, date);
        if (Boolean.getBoolean("mvc.dst.offset.enable")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(this.getTimeZone(this.getRelateOrgId((DynamicObject)dataEntity)).getTimeZone());
            calendar.setTime(value);
            calendar.setLenient(false);
            calendar.set(11, 12);
            return calendar.getTime();
        }
        return value;
    }
}

