/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.FieldDefValueType;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FieldRuleArgs;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TransType;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.map.HashedMap;

@KSObject
@SdkPublic
public class DateTimeProp
extends FieldProp {
    private static final long serialVersionUID = 6731772779326487883L;
    private Date minDate;
    private Date maxDate;
    private boolean useRegion = true;
    protected int regionType = 2;
    private int timeZoneTransType = 0;
    private String relateOrg;
    private String displayFormatString;
    private String mask;
    private boolean startDateTimeRange;
    private String relateDateTimeRange;
    private static final Log log = LogFactory.getLog(DateTimeProp.class);

    public DateTimeProp() {
        this.compareGroupID = "5,0,2,4";
        this.defaultCompareTypeId = "67";
        this.defaultMultiCompareTypeId = "1";
        this.filterControlType = "datetime";
    }

    @KSMethod
    @SimplePropertyAttribute
    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date min) {
        this.minDate = min;
    }

    @KSMethod
    @SimplePropertyAttribute
    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date max) {
        this.maxDate = max;
    }

    @KSMethod
    @SimplePropertyAttribute(name="UseRegion")
    @DefaultValueAttribute(value="true")
    public boolean isUseRegion() {
        return this.useRegion;
    }

    public void setUseRegion(boolean useRegion) {
        this.useRegion = useRegion;
    }

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="0")
    public int getTimeZoneTransType() {
        return this.timeZoneTransType;
    }

    public void setTimeZoneTransType(int timeZoneTransType) {
        this.timeZoneTransType = timeZoneTransType;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getRelateOrg() {
        return this.relateOrg;
    }

    public void setRelateOrg(String relateOrg) {
        this.relateOrg = relateOrg;
    }

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="2")
    public int getRegionType() {
        return this.regionType;
    }

    public void setRegionType(int regionType) {
        this.regionType = regionType;
    }

    public Class<?> getPropertyType() {
        return Date.class;
    }

    @Override
    public int getDbType() {
        return 93;
    }

    @SimplePropertyAttribute
    public String getDisplayFormatString() {
        return this.displayFormatString;
    }

    public void setDisplayFormatString(String displayFormatString) {
        this.displayFormatString = displayFormatString;
    }

    @SimplePropertyAttribute
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    @Override
    @KSMethod
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        try {
            if (value instanceof Date) {
                super.setFieldValue(model, dataEntity, value);
            } else if (StringUtils.isBlank((Object)value)) {
                super.setFieldValue(model, dataEntity, null);
            } else {
                super.setFieldValue(model, dataEntity, this.parse(dataEntity, value.toString()));
            }
        }
        catch (ParseException e) {
            String displayName = this.getDisplayName() == null ? this.getName() : this.getDisplayName().getLocaleValue();
            KDBizException exp = new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\u3002", (String)"DateTimeProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]), displayName, value)), new Object[0]);
            try (EntityTraceSpan span = EntityTracer.create((String)"DateTimeProp", (String)"setFieldValue");){
                span.addLocaleTag("prop", (Object)this);
                span.addLocaleTag("value", value);
                span.throwException((Throwable)exp);
            }
            throw exp;
        }
    }

    public String format(Object dataEntity, Date date) {
        return this.getTimeZone(this.getRelateOrgId((DynamicObject)dataEntity)).format(date, this.getDateFormat());
    }

    public String customFormat(Object dataEntity, Date date, SimpleDateFormat dateFormat) {
        return this.getTimeZone(this.getRelateOrgId((DynamicObject)dataEntity)).format(date, (DateFormat)dateFormat);
    }

    public Date parse(Object dataEntity, String date) throws ParseException {
        DateFormat dateFormat = this.getDateFormat(date);
        dateFormat.setLenient(false);
        return this.getTimeZone(this.getRelateOrgId((DynamicObject)dataEntity)).parse(date, dateFormat);
    }

    @SdkInternal
    protected Long getRelateOrgId(DynamicObject dataEntity) {
        Long orgId = 0L;
        if (dataEntity != null) {
            String orgKey = this.relateOrg;
            IDataEntityType entityType = dataEntity.getDataEntityType();
            if (entityType instanceof MainEntityType) {
                DynamicObject org;
                if (StringUtils.isBlank((CharSequence)this.relateOrg)) {
                    orgKey = ((MainEntityType)entityType).getMainOrg();
                }
                if (StringUtils.isNotBlank((CharSequence)orgKey) && (org = dataEntity.getDynamicObject(orgKey)) != null) {
                    orgId = (Long)org.getPkValue();
                }
            } else if (entityType instanceof EntryType) {
                if (StringUtils.isNotBlank((CharSequence)this.relateOrg)) {
                    DynamicProperty orgProp = ((EntryType)entityType).getProperty(this.relateOrg);
                    if (orgProp != null) {
                        DynamicObject org = dataEntity.getDynamicObject((IDataEntityProperty)orgProp);
                        if (org != null) {
                            orgId = (Long)org.getPkValue();
                        }
                    } else {
                        orgId = this.getRelateOrgId((DynamicObject)dataEntity.getParent());
                    }
                } else {
                    orgId = this.getRelateOrgId((DynamicObject)dataEntity.getParent());
                }
            }
        }
        return orgId;
    }

    private boolean isContainRelateOrg(DynamicObject dataEntity) {
        try (EntityTraceSpan span = EntityTracer.create((String)"kd.bos.entity.property.DateTimeProp", (String)"isContainRelateOrg");){
            if (dataEntity != null) {
                IDataEntityType entityType = dataEntity.getDataEntityType();
                if (span.isRealtime()) {
                    span.addLocaleTag("relateOrg", (Object)this.relateOrg);
                    span.addLocaleTag("entityType", (Object)entityType);
                }
                if (entityType instanceof MainEntityType) {
                    String orgKey = this.relateOrg;
                    if (StringUtils.isBlank((CharSequence)orgKey)) {
                        orgKey = ((MainEntityType)entityType).getMainOrg();
                    }
                    if (span.isRealtime()) {
                        span.addLocaleTag("orgKey", (Object)orgKey);
                    }
                    if (StringUtils.isNotBlank((CharSequence)orgKey)) {
                        DynamicProperty property = ((MainEntityType)entityType).getProperty(orgKey);
                        boolean bl = property != null;
                        return bl;
                    }
                } else if (entityType instanceof EntryType) {
                    if (StringUtils.isNotBlank((CharSequence)this.relateOrg)) {
                        DynamicProperty orgProp = ((EntryType)entityType).getProperty(this.relateOrg);
                        if (orgProp != null) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = this.isContainRelateOrg((DynamicObject)dataEntity.getParent());
                        return bl;
                    }
                    boolean bl = this.isContainRelateOrg((DynamicObject)dataEntity.getParent());
                    return bl;
                }
            }
        }
        return false;
    }

    public InteTimeZone getTimeZone(Long orgId) {
        InteTimeZone timeZone;
        switch (TransType.get((int)this.getTimeZoneTransType())) {
            case USERTIMEZONE: {
                timeZone = InteTimeZone.getUserTimeZone((long)Long.parseLong(RequestContext.getOrCreate().getUserId()));
                break;
            }
            case ORGTIMEZONE: {
                timeZone = InteTimeZone.getOrgTimeZone((Long)orgId);
                break;
            }
            default: {
                timeZone = InteTimeZone.getSysTimeZone();
            }
        }
        return timeZone;
    }

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        return new DateTimeColumnDesc(col.getKey(), this, col.getFieldProp());
    }

    @Override
    @KSMethod
    public String getClientType() {
        return "datetime";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public DateFormat getDateFormat(String date) {
        String[] timeValue = date.split(":");
        if (timeValue.length > 3 && timeValue[timeValue.length - 1].length() > 0) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        }
        return this.getDateFormat();
    }

    @Override
    public Map<String, Object> createEntityTreeNode(EntityTreeNode parentEntityTreeNode) {
        Map<String, Object> col = super.createEntityTreeNode(parentEntityTreeNode);
        col.put("Type", "DateListColumnAp");
        col.put("CommonFilterApType", "CommonDateFilterColumnAp");
        col.put("MobCommonFilterApType", "MobCommonDateFilterColumnAp");
        col.put("IsMulti", false);
        col.put("Custom", true);
        return col;
    }

    @Override
    public Object getBasePropDisplayValue(Object baseObj) {
        Object value = super.getBasePropDisplayValue(baseObj);
        if (!(value instanceof Date)) {
            return value;
        }
        Long userID = Long.parseLong(RequestContext.get().getUserId());
        FormatObject fo = FormatFactory.getFormat(userID);
        Long orgId = 0L;
        try {
            if (this.isContainRelateOrg((DynamicObject)baseObj)) {
                orgId = this.getRelateOrgId((DynamicObject)baseObj);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        if (fo == null) {
            return this.getTimeZone(orgId).format((Date)value, this.getDateFormat());
        }
        InteTimeZone zone = this.getTimeZone(orgId);
        fo.getTimeFormat().setTimeArea(zone.getTimeArea());
        fo.getDateFormat().setTimeArea(zone.getTimeArea());
        IFormat format = this.getRegionType() == FormatTypes.Time.getValue() ? FormatFactory.get(FormatTypes.Time) : FormatFactory.get(FormatTypes.Date);
        return format.getFormat(fo).format(value);
    }

    @SimplePropertyAttribute(name="StartDateTimeRange")
    @DefaultValueAttribute(value="false")
    public boolean isStartDateTimeRange() {
        return this.startDateTimeRange;
    }

    public void setStartDateTimeRange(boolean startDateTimeRange) {
        this.startDateTimeRange = startDateTimeRange;
    }

    @SimplePropertyAttribute(name="RelateDateTimeRange")
    public String getRelateDateTimeRange() {
        return this.relateDateTimeRange;
    }

    public void setRelateDateTimeRange(String relateDateTimeRange) {
        this.relateDateTimeRange = relateDateTimeRange;
    }

    public long getEstimatedLen() {
        return 4L;
    }

    @Override
    public List<AbstractRule> getFieldRules(FieldRuleArgs args) {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>(1);
        rules.addAll(super.getFieldRules(args));
        Object billStatus = args.getObject();
        if (!(billStatus instanceof String)) {
            return rules;
        }
        IDataEntityProperty triggerProperty = args.getTriggerProperty();
        FieldDefValue defValue = this.getDefValue2();
        if (defValue == null || defValue.getDefValueType() != FieldDefValueType.Reference || StringUtils.isBlank((CharSequence)defValue.getFuncName()) || !"ADDNEW".equals(billStatus)) {
            return rules;
        }
        String funcName = defValue.getFuncName();
        String orgField = defValue.getFuncParameter();
        if (triggerProperty instanceof OrgProp && triggerProperty.getName().equals(orgField)) {
            BR dateRule = new BR();
            dateRule.setSource(args.getSource());
            dateRule.setDescription(ResManager.loadKDString((String)"\u65e5\u671f\u6309\u7ec4\u7ec7\u65f6\u533a\u8f6c\u6362", (String)"DateTimeProp_1", (String)"bos-entity-metadata", (Object[])new Object[0]));
            dateRule.setRET(253);
            dateRule.setEnabled(true);
            dateRule.setDescription(ResManager.loadKDString((String)"\u65e5\u671f\u6309\u7ec4\u7ec7\u65f6\u533a\u8f6c\u6362\u4e1a\u52a1\u89c4\u5219", (String)"DateTimeProp_2", (String)"bos-entity-metadata", (Object[])new Object[0]));
            dateRule.setPreCondition("true");
            ArrayList<Map<String, Object>> dateRuleActions = new ArrayList<Map<String, Object>>(10);
            LinkedHashMap<String, Object> dateTimeAction = new LinkedHashMap<String, Object>(16);
            dateTimeAction.put("ret", "253");
            HashedMap expression = new HashedMap(3);
            expression.put("DateField", this.getName());
            expression.put("orgField", orgField);
            expression.put("Expression", funcName);
            dateTimeAction.put("expression", expression);
            dateTimeAction.put("dependencyFields", new ArrayList(1));
            dateTimeAction.put("actionId", Uuid16.create().toString());
            dateTimeAction.put("class", "kd.bos.entity.rule.FillDateTimeAction");
            dateTimeAction.put("description", ResManager.loadKDString((String)"\u65e5\u671f\u6309\u7ec4\u7ec7\u65f6\u533a\u8f6c\u6362", (String)"DateTimeProp_1", (String)"bos-entity-metadata", (Object[])new Object[0]));
            dateRuleActions.add(dateTimeAction);
            dateRule.setTrueActions(dateRuleActions);
            rules.add(dateRule);
        }
        return rules;
    }
}

