/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.SummaryToField;
import kd.bos.entity.datamodel.DecimalPrecision;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.property.BasedataTypeEnum;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IGetScale;
import kd.bos.entity.property.INumberPrecision;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IScopeCheck;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.entity.validate.ScopeValidator;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DecimalProp
extends FieldProp
implements IScopeCheck,
INumberPrecision {
    private static Log log = LogFactory.getLog(DecimalProp.class);
    private static final long serialVersionUID = -2487329623607956786L;
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private boolean useRegion = true;
    private int precision = 23;
    private int scale = 10;
    private String dataScope;
    private BigDecimal min;
    private BigDecimal max;
    private boolean inclMin;
    private boolean inclMax;
    private String controlPropName;
    private transient IGetScale scaleHandler;
    private SummaryToField summaryToField;

    public DecimalProp() {
        this._defaultValue = BigDecimal.ZERO;
        this.compareGroupID = "0,4";
        this.defaultCompareTypeId = "67";
        this.defaultMultiCompareTypeId = "17";
        this.filterControlType = "number";
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getControlPropName() {
        return this.controlPropName;
    }

    public void setControlPropName(String controlPropName) {
        this.controlPropName = controlPropName;
    }

    protected String getPrecisionPropName() {
        return "";
    }

    @KSMethod
    public boolean isUseRegion() {
        return this.useRegion;
    }

    public void setUseRegion(boolean useRegion) {
        this.useRegion = useRegion;
    }

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="23")
    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="10")
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @SdkInternal
    protected IGetScale getScaleHandler(IDataModel model) {
        if (this.scaleHandler == null) {
            this.scaleHandler = this.createScaleHander(model);
        }
        return this.scaleHandler;
    }

    @SdkInternal
    protected IGetScale createScaleHander(IDataModel model) {
        return IGetScale.create(model, this, this.getControlPropName(), this.getPrecisionPropName(), this.getScale());
    }

    @SimplePropertyAttribute
    public String getDataScope() {
        return this.dataScope;
    }

    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    @KSMethod
    @SimplePropertyAttribute
    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    @KSMethod
    @SimplePropertyAttribute
    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    @KSMethod
    @SimplePropertyAttribute(name="InclMin")
    public boolean isInclMin() {
        return this.inclMin;
    }

    public void setInclMin(boolean inclMin) {
        this.inclMin = inclMin;
    }

    @KSMethod
    @SimplePropertyAttribute(name="InclMax")
    public boolean isInclMax() {
        return this.inclMax;
    }

    public void setInclMax(boolean inclMax) {
        this.inclMax = inclMax;
    }

    @ComplexPropertyAttribute
    public SummaryToField getSummaryToField() {
        return this.summaryToField;
    }

    public void setSummaryToField(SummaryToField summaryToField) {
        this.summaryToField = summaryToField;
    }

    @Override
    public int getDbType() {
        return 3;
    }

    public Class<?> getPropertyType() {
        return BigDecimal.class;
    }

    @Override
    public AbstractColumnDesc getListColumnDesc(ListField col) {
        AbstractColumnDesc desc = super.getListColumnDesc(col);
        if (desc instanceof NumberColumnDesc) {
            ((NumberColumnDesc)desc).setZeroShow(col.isZeroShow());
        }
        return desc;
    }

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        DecimalColumnDesc decimalColumnDesc = new DecimalColumnDesc(col.getKey(), this, col.getFieldProp());
        return decimalColumnDesc;
    }

    @Override
    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        if (checkImportable && !this.isImportable()) {
            LocaleString dispName = this.getDisplayName();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"DecimalProp_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), StringUtils.isNotBlank((Object)dispName) ? dispName.toString() : this.getName()));
        }
        LocaleString displayName = this.getDisplayName();
        if (value != null) {
            try {
                new BigDecimal(value.toString());
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5\u201c%1$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%2$s", (String)"DecimalProp_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), displayName != null ? displayName.toString() : this.getName(), value));
            }
        }
        if (value instanceof String && ((String)value).endsWith("%")) {
            value = DecimalProp.percentToDoubleString((String)value);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDataScope()) && !this.checkScope(value)) {
            throw new KDBizException(this.getDataScopeMessage(value));
        }
        BigDecimal srcValue = value == null ? BigDecimal.ZERO : new BigDecimal(value.toString());
        this.setFieldValue(model, dataEntity, value);
        Object afterValue = this.getValueFast(dataEntity);
        BigDecimal realValue = afterValue == null ? BigDecimal.ZERO : new BigDecimal(afterValue.toString());
        int scale = this.getScaleHandler(model).getScale(model, dataEntity);
        int precision = this.getPrecision() - this.getScale() + scale;
        if (srcValue.compareTo(realValue) != 0 || realValue.precision() - realValue.scale() > precision - scale) {
            String err = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8981\u6c42\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%3$s\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%4$s\u4f4d\u3002", (String)"DecimalProp_6", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), displayName != null ? displayName.toString() : this.getName(), srcValue.toString(), String.valueOf(precision - scale), String.valueOf(scale));
            throw new KDBizException(err);
        }
    }

    @SdkInternal
    public static String percentToDoubleString(String value) {
        boolean isNegNumber = value.startsWith("-");
        StringBuilder sb = new StringBuilder(value);
        if (isNegNumber) {
            sb.deleteCharAt(0);
        }
        sb.setLength(sb.length() - 1);
        int dot = sb.lastIndexOf(".");
        int newDot = 1;
        if (dot >= 0) {
            newDot = dot - 2;
            sb.deleteCharAt(dot);
        } else {
            newDot = sb.length() - 2;
        }
        if (newDot <= 0) {
            newDot = -newDot;
            sb.insert(0, StringUtils.repeat((char)'0', (int)(newDot + 1)));
        }
        sb.insert(Math.max(1, newDot), '.');
        if (isNegNumber) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    @Override
    @KSMethod
    public void setFieldValue(IDataModel model, Object dataEntity, Object Value) {
        BigDecimal d;
        if (Value instanceof BigDecimal) {
            d = (BigDecimal)Value;
        } else if (Value instanceof Integer || Value instanceof BigInteger) {
            d = new BigDecimal(Value.toString());
        } else if (Value instanceof Long) {
            d = new BigDecimal(Value.toString());
        } else if (Value instanceof Double || Value instanceof Float) {
            d = new BigDecimal(Value.toString());
        } else if (Value instanceof String) {
            try {
                d = new BigDecimal(((String)Value).trim());
            }
            catch (NumberFormatException e) {
                log.debug(e.toString());
                d = BigDecimal.ZERO;
            }
        } else if (Value == null) {
            if (this.isEnableNull()) {
                super.setFieldValue(model, dataEntity, Value);
                return;
            }
            d = BigDecimal.ZERO;
        } else {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u6570\u636e\u7c7b\u578b\uff1a%s", (String)"DecimalProp_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), Value.getClass()));
        }
        d = this.ensurePrecision(model, dataEntity, d);
        super.setFieldValue(model, dataEntity, d);
    }

    public boolean isValueEquals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        BigDecimal b1 = this.toBigDecimal(v1);
        if (b1 == null) {
            return false;
        }
        BigDecimal b2 = this.toBigDecimal(v2);
        if (b2 == null) {
            return false;
        }
        return b1.compareTo(b2) == 0;
    }

    private BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        try {
            return new BigDecimal(val.toString());
        }
        catch (NumberFormatException e) {
            log.debug(e.toString());
            return null;
        }
    }

    @Override
    public Map<String, Object> createEntityTreeNode(EntityTreeNode entityTreeNode) {
        Map<String, Object> col = super.createEntityTreeNode(entityTreeNode);
        col.put("DataType", "decimal");
        col.put("Type", "DecimalListColumnAp");
        col.put("ZeroShow", this.isZeroShow());
        col.put("ControlPropName", this.getControlPropName());
        col.put("IsBaseData", false);
        col.put("BaseDateType", (Object)BasedataTypeEnum.None);
        return col;
    }

    @Override
    public String getClientType() {
        return "number";
    }

    public int getRoundingMode() {
        return 4;
    }

    @SdkInternal
    protected BigDecimal ensurePrecision(IDataModel model, Object dataEntity, BigDecimal v) {
        this.checkPrecision(v);
        int scale = this.getEnsureScale(model, dataEntity);
        if (v.scale() != scale) {
            v = v.setScale(scale, this.getRoundingMode());
        }
        return v;
    }

    @SdkInternal
    protected boolean checkPrecision(BigDecimal v) {
        if (v.precision() - v.scale() > this.getPrecision() - this.getScale() && !v.equals(BigDecimal.valueOf(0L))) {
            LocaleString displayName = this.getDisplayName();
            String err = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8981\u6c42\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%3$s\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%4$s\u4f4d\u3002", (String)"DecimalProp_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), displayName != null ? displayName.toString() : this.getName(), v.toString(), String.valueOf(this.getPrecision() - this.getScale()), String.valueOf(this.getScale()));
            throw new KDBizException(err);
        }
        return true;
    }

    @SdkInternal
    protected int getEnsureScale(IDataModel model, Object dataEntity) {
        return this.getScaleHandler(model).getScale(model, dataEntity);
    }

    @Override
    public IValueComparator getValueComparator() {
        final boolean enableNull = this.isEnableNull();
        return new IValueComparator(){

            @Override
            public boolean compareValue(Object o) {
                if (o == null) {
                    return true;
                }
                boolean isZero = o instanceof BigDecimal ? BigDecimal.ZERO.compareTo((BigDecimal)o) == 0 : (o instanceof Long ? (Long)o == 0L : (o instanceof Integer ? (Integer)o == 0 : o.equals(0)));
                if (enableNull && isZero) {
                    return false;
                }
                return isZero;
            }
        };
    }

    @Override
    public List<AbstractValidator> getValidators() {
        List<AbstractValidator> validators = super.getValidators();
        if (this.getMin() != null || this.getMax() != null) {
            ScopeValidator scopeValidator = new ScopeValidator((DynamicProperty)this, this.getName(), "");
            validators.add(scopeValidator);
        }
        return validators;
    }

    @Override
    public boolean checkScope(Object fldValue) {
        BigDecimal realValue = BigDecimal.ZERO;
        if (fldValue != null) {
            realValue = new BigDecimal(String.valueOf(fldValue));
        } else if (fldValue == null) {
            return true;
        }
        if (this.getMin() != null && (this.isInclMin() ? realValue.compareTo(this.getMin()) < 0 : realValue.compareTo(this.getMin()) <= 0)) {
            return false;
        }
        return this.getMax() == null || !(this.isInclMax() ? realValue.compareTo(this.getMax()) > 0 : realValue.compareTo(this.getMax()) >= 0);
    }

    @Override
    public String getDataScopeMessage(Object fldValue) {
        if (fldValue instanceof BigDecimal) {
            fldValue = ((BigDecimal)fldValue).toPlainString();
        }
        return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c%2$s\u8d85\u51fa\u9650\u5b9a\u8303\u56f4%3$s\u3002", (String)"DecimalProp_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getDisplayName() == null ? this.getName() : this.getDisplayName().toString(), fldValue, this.getDataScope());
    }

    @Override
    public String getDataScopeMessage(Object fldValue, boolean withFieldTitle) {
        if (withFieldTitle) {
            return this.getDataScopeMessage(fldValue);
        }
        if (fldValue instanceof BigDecimal) {
            fldValue = ((BigDecimal)fldValue).toPlainString();
        }
        return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u503c%2$s\u8d85\u51fa\u9650\u5b9a\u8303\u56f4%3$s\u3002", (String)"DecimalProp_9", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getDisplayName() == null ? this.getName() : this.getDisplayName().toString(), fldValue, this.getDataScope());
    }

    public long getEstimatedLen() {
        return 8L;
    }

    @Override
    public NumberPrecision create(FormatObject formatObject) {
        return new DecimalPrecision(formatObject);
    }

    @Override
    public Integer getDefaultPrecision() {
        return this.precision;
    }
}

