/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.ExchangeRateColumnDesc;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IGetScale;
import kd.bos.utils.ExRateConfigUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ExchangeRateProp
extends DecimalProp {
    private static final long serialVersionUID = -6206362215033682243L;
    private static final String DEFAULT_PRECISION = "defaultprecision";
    private String originalCurrencyFieldKey;
    private String targetCurrencyFieldKey;

    @SimplePropertyAttribute
    public String getOriginalCurrencyFieldKey() {
        return this.originalCurrencyFieldKey;
    }

    public void setOriginalCurrencyFieldKey(String originalCurrencyFieldKey) {
        this.originalCurrencyFieldKey = originalCurrencyFieldKey;
    }

    @SimplePropertyAttribute
    public String getTargetCurrencyFieldKey() {
        return this.targetCurrencyFieldKey;
    }

    public void setTargetCurrencyFieldKey(String targetCurrencyFieldKey) {
        this.targetCurrencyFieldKey = targetCurrencyFieldKey;
    }

    @Override
    public boolean isCopyable() {
        return false;
    }

    @Override
    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        super.applyDefaultValue(model, dataEntity, rowIndex);
        this.autoRegisterExchangeRatePlugin(model);
    }

    private void autoRegisterExchangeRatePlugin(IDataModel model) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.field.ExchangeRateEdit");
            Class<?> iForwViewClass = Class.forName("kd.bos.form.IFormView");
            Method method = clazz.getDeclaredMethod("autoRegisterExchangeRatePlugin", IDataModel.class, iForwViewClass);
            method.invoke(null, model, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        return new ExchangeRateColumnDesc(col.getKey(), this, col.getFieldProp());
    }

    @Override
    public IGetScale createScaleHander(IDataModel model) {
        return IExRateGetScale.create(model, this, this.getControlPropName(), this.getPrecisionPropName(), this.getScale());
    }

    @Override
    public int getEnsureScale(IDataModel model, Object dataEntity) {
        return super.getEnsureScale(model, dataEntity);
    }

    public static class GetExRateDefScale
    implements IGetScale {
        int defScale;
        CurrencyProp originalCurrencyProp;
        CurrencyProp targetCurrencyProp;
        ExchangeRateProp prop;

        public GetExRateDefScale(int defScale, ExchangeRateProp prop, String oriKey, String tarKey) {
            this.defScale = defScale;
            this.prop = prop;
            this.originalCurrencyProp = (CurrencyProp)GetExRateDefScale.getProp(oriKey, prop.getParent());
            this.targetCurrencyProp = (CurrencyProp)GetExRateDefScale.getProp(tarKey, prop.getParent());
        }

        @Override
        public int getScale(IDataModel model, Object dataEntity) {
            DynamicObject targetCurrencyDy;
            Long targetCurrencyId;
            boolean isEnablePrecisionControl = ExRateConfigUtil.isEnableExRatePrecisionControl();
            if (!isEnablePrecisionControl) {
                return this.defScale;
            }
            if (this.originalCurrencyProp == null || this.targetCurrencyProp == null) {
                int defaultPrecision = ExRateConfigUtil.getExchangeRateDefaultPrecision();
                if (defaultPrecision > 0) {
                    return defaultPrecision;
                }
                return this.defScale;
            }
            DynamicObject originalCurrencyDy = (DynamicObject)this.getValue((IDataEntityProperty)this.originalCurrencyProp, (DynamicObject)dataEntity);
            Long originalCurrencyId = originalCurrencyDy != null ? (Long)originalCurrencyDy.getPkValue() : null;
            int currencyPairScale = ExRateConfigUtil.getExchangeRatePrecision(originalCurrencyId, targetCurrencyId = (targetCurrencyDy = (DynamicObject)this.getValue((IDataEntityProperty)this.targetCurrencyProp, (DynamicObject)dataEntity)) != null ? (Long)targetCurrencyDy.getPkValue() : null);
            if (currencyPairScale > 0) {
                BigDecimal value = (BigDecimal)model.getValue(this.prop.getName());
                if (value != null) {
                    int valScale = value.stripTrailingZeros().scale();
                    return Math.max(currencyPairScale, valScale);
                }
                return currencyPairScale;
            }
            return this.defScale;
        }

        private static IDataEntityProperty getProp(String propKey, IDataEntityType parentType) {
            IDataEntityProperty prop = null;
            prop = (IDataEntityProperty)parentType.getProperties().get((Object)propKey);
            if (prop == null && (parentType = parentType.getParent()) != null) {
                prop = (IDataEntityProperty)parentType.getProperties().get((Object)propKey);
            }
            if (prop == null && parentType != null && (parentType = parentType.getParent()) != null) {
                prop = (IDataEntityProperty)parentType.getProperties().get((Object)propKey);
            }
            return prop;
        }

        private Object getValue(IDataEntityProperty property, DynamicObject rowData) {
            boolean isParentControl;
            boolean isEqualControl = property.getParent().getName().equals(rowData.getDynamicObjectType().getName());
            if (isEqualControl) {
                return property.getValueFast((Object)rowData);
            }
            boolean bl = isParentControl = rowData.getParent() != null ? property.getParent().getName().equals(((DynamicObject)rowData.getParent()).getDynamicObjectType().getName()) : false;
            if (isParentControl) {
                return property.getValueFast(rowData.getParent());
            }
            return null;
        }
    }

    static interface IExRateGetScale
    extends IGetScale {
        @Override
        public int getScale(IDataModel var1, Object var2);

        public static IGetScale create(IDataModel model, DecimalProp prop, String ctrlFldKey, String precisionPropName, int defScale) {
            ExchangeRateProp prop1 = (ExchangeRateProp)prop;
            return new GetExRateDefScale(defScale, prop1, prop1.getOriginalCurrencyFieldKey(), prop1.getTargetCurrencyFieldKey());
        }
    }
}

