/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterBuilderParameter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.ModelTypeFilterValueSetter;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ListColumnDescBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.IBaseDataService;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public interface IBasedataField
extends IFieldHandle {
    default public String getName() {
        return null;
    }

    public String getOrgProp();

    default public String getBaseEntityId() {
        return null;
    }

    default public String getDisplayProp() {
        return "name";
    }

    default public String getNumberProp() {
        return "number";
    }

    default public IDataEntityProperty getDispProp() {
        return null;
    }

    default public String getBaseEntityId(IDataModel model) {
        return this.getBaseEntityId();
    }

    default public IDataEntityType getComplexType() {
        return null;
    }

    @Override
    default public AbstractColumnDesc getListColumnDesc(ListField col) {
        ListColumnDescBuilder listColumnDescBuilder = new ListColumnDescBuilder(this);
        return listColumnDescBuilder.createColumnDesc(col);
    }

    default public FilterCondition getFilterCondition(IDataModel model) {
        return EntityMetadataCache.getBaseDataFieldFilterMeta(model.getDataEntityType().getName(), this.getName());
    }

    @KSMethod
    default public FilterBuilder buildCoreFilter(IDataModel model) {
        String baseEntityId = this.getBaseEntityId(model);
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            return null;
        }
        MainEntityType dataType = EntityMetadataCache.getDataEntityType(baseEntityId);
        FilterCondition filterCondition = this.getFilterCondition(model);
        FilterBuilder filterBuilder = null;
        if (filterCondition != null) {
            filterBuilder = IBasedataField.getFilterBuilder(model, dataType, filterCondition);
            filterBuilder.buildFilter();
        }
        return filterBuilder;
    }

    @KSMethod
    default public List<QFilter> buildCoreFilterByString(IDataModel model) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String baseEntityId = this.getBaseEntityId(model);
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            return qFilters;
        }
        MainEntityType dataType = EntityMetadataCache.getDataEntityType(baseEntityId);
        FilterCondition filterCondition = this.getFilterCondition(model);
        if (filterCondition != null) {
            FilterBuilder filterBuilder = IBasedataField.getFilterBuilder(model, dataType, filterCondition);
            filterBuilder.buildFilter();
            if (filterBuilder.getQFilter() != null) {
                qFilters.add(filterBuilder.getQFilter());
            }
        }
        try (EntityTraceSpan span = EntityTracer.create((String)"kd.bos.entity.property.IBasedataField", (String)"buildBaseDataPropertyQFiltersWithoutControlOrgFilter");){
            if (span.isRealtime()) {
                span.addLocaleTag("coreFilters", (Object)((Object)qFilters).toString());
                span.addLocaleTag("coreFilters", (Object)((Object)qFilters).toString());
            }
        }
        return qFilters;
    }

    @NotNull
    public static FilterBuilder getFilterBuilder(IDataModel model, MainEntityType dataType, FilterCondition filterCondition) {
        FilterBuilderParameter filterBuilderParameter = new FilterBuilderParameter(dataType, filterCondition).setFilterValueSetter(new ModelTypeFilterValueSetter(model)).setNeedParseBaseDataIds(true);
        return new FilterBuilder(filterBuilderParameter);
    }

    default public boolean isShowUsed() {
        return true;
    }

    default public QFilter getBaseDataControlOrgQFilter(IDataModel model, String entityId) {
        return this.getBaseDataControlOrgQFilter(model, entityId, null);
    }

    default public QFilter getBaseDataControlOrgQFilter(IDataModel model, String entityId, QFilter customFilter) {
        DynamicObject mainOrgObj;
        MainEntityType billEntityType = model.getDataEntityType();
        String controlOrgProp = this.getOrgProp();
        String mainOrgProp = billEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)controlOrgProp)) {
            controlOrgProp = mainOrgProp;
        }
        if (StringUtils.isNotBlank((CharSequence)controlOrgProp) && (mainOrgObj = (DynamicObject)model.getValue(controlOrgProp)) != null && mainOrgObj.getPkValue() != null) {
            long orgID = (Long)mainOrgObj.getPkValue();
            IBaseDataService baseDataService = (IBaseDataService)model.getService(IBaseDataService.class);
            return baseDataService.getLookUpListFilter(entityId, orgID, customFilter);
        }
        return null;
    }

    default public String getClientType(String refPropKey) {
        FieldProp refProp;
        if (this instanceof IDataEntityProperty && (refProp = EntityTypeUtil.getFieldProp(refPropKey, (EntityType)((IDataEntityProperty)this).getParent(), false)) != null) {
            return refProp.getClientType();
        }
        return "text";
    }

    default public List<QFilter> getF7InnerFilters(String formId, String entityId) {
        return new ArrayList<QFilter>(0);
    }

    default public List<QFilter> getF7InnerFilters(String appId, String formId, String entityId, boolean isList) {
        QFilter approvedQFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        this.getComplexType();
        QFilter baseDataFilter = null;
        FilterCondition filterCondition = EntityMetadataCache.getBaseDataFieldFilterMeta(entityId, this.getName());
        MainEntityType dt = EntityMetadataCache.getDataEntityType(this.getComplexType().getName());
        if (isList && filterCondition != null && filterCondition.isForList()) {
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter != null) {
                baseDataFilter = filterBuilder.getQFilter();
            }
        }
        if (baseDataFilter != null) {
            qFilters.add(baseDataFilter);
        }
        if ((approvedQFilter = PermissionFilterUtil.getApprovedFilter(dt)) != null) {
            qFilters.add(approvedQFilter);
        }
        qFilters.addAll(this.getF7InnerFilters(formId, entityId));
        QFilter specialDataPermQFilter = PermissionFilterUtil.getSpecialDataPermissionFilter(appId, this.getBaseEntityId(), "view");
        if (specialDataPermQFilter != null) {
            qFilters.add(specialDataPermQFilter);
        }
        return qFilters;
    }

    @Deprecated
    default public void fixComplexType() {
        DynamicComplexProperty property;
        BillEntityType refEntityType = null;
        if (this instanceof DynamicProperty) {
            IDataEntityType parent1;
            MainEntityType mainEntityType = null;
            IDataEntityType parent = ((DynamicProperty)this).getParent();
            if (parent instanceof MainEntityType) {
                mainEntityType = (MainEntityType)parent;
            } else if (parent instanceof EntryType && !(parent instanceof SubEntryType)) {
                IDataEntityType parent12 = parent.getParent();
                if (parent12 instanceof MainEntityType) {
                    mainEntityType = (MainEntityType)parent12;
                }
            } else if (parent instanceof SubEntryType && (parent1 = parent.getParent().getParent()) instanceof MainEntityType) {
                mainEntityType = (MainEntityType)parent1;
            }
            if (mainEntityType != null) {
                refEntityType = RefEntityTypeCache.getRefEntityType(mainEntityType.getName(), true);
            }
        }
        if (refEntityType != null && this instanceof DynamicComplexProperty) {
            property = (DynamicComplexProperty)refEntityType.findProperty(this.getName());
            if (property != null) {
                ((DynamicComplexProperty)this).setComplexType(property.getComplexType());
            }
        } else if (refEntityType != null && this instanceof DynamicCollectionProperty && (property = (DynamicCollectionProperty)refEntityType.findProperty(this.getName())) != null) {
            ((DynamicCollectionProperty)this).setItemType(property.getItemType());
        }
    }
}

