/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ListColumnDescBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.IBaseDataService;

public interface IRefBillField
extends IFieldHandle {
    default public String getName() {
        return null;
    }

    public String getOrgProp();

    default public String getBillEntityId() {
        return null;
    }

    default public String getDisplayProp() {
        return "billno";
    }

    default public String getNumberProp() {
        return "billno";
    }

    default public IDataEntityProperty getDispProp() {
        return null;
    }

    default public String getBillEntityId(IDataModel model) {
        return this.getBillEntityId();
    }

    default public IDataEntityType getComplexType() {
        return null;
    }

    @Override
    default public AbstractColumnDesc getListColumnDesc(ListField col) {
        ListColumnDescBuilder listColumnDescBuilder = new ListColumnDescBuilder(this);
        return listColumnDescBuilder.createColumnDesc(col);
    }

    default public FilterCondition getFilterCondition(IDataModel model) {
        return EntityMetadataCache.getBaseDataFieldFilterMeta(model.getDataEntityType().getName(), this.getName());
    }

    @KSMethod
    default public FilterBuilder buildCoreFilter(IDataModel model) {
        String baseEntityId = this.getBillEntityId(model);
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            return null;
        }
        MainEntityType dataType = EntityMetadataCache.getDataEntityType(baseEntityId);
        FilterCondition filterCondition = this.getFilterCondition(model);
        FilterBuilder filterBuilder = null;
        if (filterCondition != null) {
            filterBuilder = new FilterBuilder(dataType, filterCondition, model);
            filterBuilder.buildFilter();
        }
        return filterBuilder;
    }

    @KSMethod
    default public List<QFilter> buildCoreFilterByString(IDataModel model) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String baseEntityId = this.getBillEntityId(model);
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            return qFilters;
        }
        MainEntityType dataType = EntityMetadataCache.getDataEntityType(baseEntityId);
        FilterCondition filterCondition = this.getFilterCondition(model);
        if (filterCondition != null) {
            FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, model);
            filterBuilder.buildFilter();
            qFilters.add(filterBuilder.getQFilter());
        }
        return qFilters;
    }

    default public boolean isShowOnlyAudited() {
        return true;
    }

    default public QFilter getBaseDataControlOrgQFilter(IDataModel model, String entityId) {
        DynamicObject mainOrgObj;
        MainEntityType billEntityType = model.getDataEntityType();
        String controlOrgProp = this.getOrgProp();
        String mainOrgProp = billEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)controlOrgProp)) {
            controlOrgProp = mainOrgProp;
        }
        if (StringUtils.isNotBlank((CharSequence)controlOrgProp) && (mainOrgObj = (DynamicObject)model.getValue(controlOrgProp)) != null && mainOrgObj.getPkValue() != null) {
            long orgID = (Long)mainOrgObj.getPkValue();
            IBaseDataService baseDataService = (IBaseDataService)model.getService(IBaseDataService.class);
            return baseDataService.getBaseDataFilter(entityId, orgID);
        }
        return null;
    }

    default public String getClientType(String refPropKey) {
        FieldProp refProp;
        if (this instanceof IDataEntityProperty && (refProp = EntityTypeUtil.getFieldProp(refPropKey, (EntityType)((IDataEntityProperty)this).getParent(), false)) != null) {
            return refProp.getClientType();
        }
        return "text";
    }

    default public String getBillStatus() {
        return "billstatus";
    }
}

