/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.OrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MainOrgProp
extends OrgProp {
    private static final long serialVersionUID = -8849204091501748765L;
    public static final String PARAMKEY_HASRIGHT = "hasright";
    private static final String ADD_NEW_PERMITEMID = "47156aff000000ac";
    private static final String IS_CHANGING_MAIN_ORG = "isChangingMainOrg";
    private static final String NEW_ORG_VALUE = "newOrgValue";
    private static Log log = LogFactory.getLog(MainOrgProp.class);

    public MainOrgProp() {
        this.setMustInput(true);
        this.setAlias("forgid");
        this.setName("org");
    }

    @Override
    public String getFilterControlType() {
        return "org";
    }

    @Override
    @SimplePropertyAttribute(name="MustInput")
    @DefaultValueAttribute(value="true")
    @KSMethod
    public boolean isMustInput() {
        return true;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="forgid")
    @KSMethod
    public String getAlias() {
        return super.getAlias();
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="org")
    @KSMethod
    public String getName() {
        return super.getName();
    }

    private boolean isBindingAddNewPerm(String entityId) {
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        return permissionService.isBindingAddNewPerm(entityId);
    }

    @Override
    @KSMethod
    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        MainEntityType mainEntityType;
        String mainOrg;
        Object value = model.getContextVariable(this.getName());
        long orgId = 0L;
        if (value != null) {
            orgId = Long.parseLong(value.toString());
            if (model.getContextVariable(IS_CHANGING_MAIN_ORG) != null) {
                orgId = Long.parseLong((String)model.getContextVariable(NEW_ORG_VALUE));
            }
            if (this.canBeMainOrg(orgId, model)) {
                this.setFieldValue(model, dataEntity, orgId);
            }
            return;
        }
        if (model.getContextVariable(IS_CHANGING_MAIN_ORG) != null) {
            orgId = Long.parseLong((String)model.getContextVariable(NEW_ORG_VALUE));
            if (this.canBeMainOrg(orgId, model)) {
                model.setValue((String)model.getContextVariable("mainOrgProName"), orgId);
            }
            return;
        }
        boolean hasCtrlstrategy = this.getdefaultctrl(dataEntity.getDataEntityType().getName());
        DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
        if (dynamicObjectType instanceof MainEntityType && "createorg".equals(mainOrg = (mainEntityType = (MainEntityType)dynamicObjectType).getMainOrg()) && hasCtrlstrategy) {
            return;
        }
        Long defOrgId = this.calcDefaultValue(model);
        if (defOrgId != null && Long.compare(0L, defOrgId) != 0) {
            this.setFieldValue(model, dataEntity, defOrgId);
        }
    }

    private boolean getdefaultctrl(String entity) {
        String sql = "select fid from  t_bd_defaultctrlstrategy where fbasedataid = '" + entity + "'";
        String id = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String id = null;
                while (rs.next()) {
                    id = rs.getString("fid");
                    if (StringUtils.isEmpty((CharSequence)id)) continue;
                    return id;
                }
                return id;
            }
        });
        return !StringUtils.isBlank((CharSequence)id);
    }

    public Long calcDefaultValue(IDataModel model) {
        long currentOrgId = RequestContext.get().getOrgId();
        String selectOrgIdStr = (String)model.getContextVariable("SELECT_ORG_ID");
        long selectOrgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)selectOrgIdStr)) {
            selectOrgId = Long.parseLong(selectOrgIdStr);
            if (this.canBeMainOrg(selectOrgId, model)) {
                return selectOrgId;
            }
        } else if (currentOrgId != selectOrgId && this.canBeMainOrg(currentOrgId, model)) {
            return currentOrgId;
        }
        return null;
    }

    private boolean canBeMainOrg(long orgId, IDataModel model) {
        boolean hasRight;
        String entityId = model.getDataEntityType().getName();
        String orgFunc = this.getOrgFunc();
        boolean checkPermBoolResult = false;
        boolean isBindingPerm = this.isBindingAddNewPerm(entityId);
        Object param_HasRight = model.getContextVariable(PARAMKEY_HASRIGHT);
        boolean bl = hasRight = param_HasRight != null && Boolean.parseBoolean(param_HasRight.toString());
        if (hasRight) {
            isBindingPerm = false;
        }
        if (isBindingPerm) {
            int checkPermIntResult;
            long userId = Long.parseLong(RequestContext.get().getUserId());
            String appNumber = (String)model.getContextVariable("APPID");
            StringBuilder builder = new StringBuilder();
            builder.append("appId:===========getContextVariable:").append(appNumber);
            IDefValueProvider defValueProvider = (IDefValueProvider)model.getService(IDefValueProvider.class);
            String appId = null;
            if (StringUtils.isBlank((CharSequence)appNumber)) {
                if (defValueProvider == null) {
                    appNumber = model.getDataEntityType().getBizAppNumber();
                    appId = AppMetadataCache.getAppInfo(appNumber).getId();
                    builder.append("appId:===========appNumber is null and defValueProvider is null,appId: ").append(appId);
                } else {
                    appId = defValueProvider.getAppId(model);
                    builder.append("appId:===========appNumber is null and defValueProvider is not null, appId: ").append(appId).append(" className: ").append(defValueProvider.getClass().getName());
                }
            } else {
                appId = AppMetadataCache.getAppInfo(appNumber).getId();
                builder.append("appId:===========appNumber is not null appId: ").append(appId);
            }
            if (StringUtils.isBlank((CharSequence)appId)) {
                appNumber = model.getDataEntityType().getBizAppNumber();
                appId = AppMetadataCache.getAppInfo(appNumber).getId();
                builder.append("appId:===========getBizAppNumber is select  ").append(appId);
            }
            checkPermBoolResult = (checkPermIntResult = ((ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class)).checkPermission(Long.valueOf(userId), Long.valueOf(orgId), appId, entityId, ADD_NEW_PERMITEMID)) != 0;
            log.info(builder.toString());
        }
        if (orgId == 0L) {
            return false;
        }
        if (isBindingPerm && !checkPermBoolResult) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orgFunc)) {
            return true;
        }
        DynamicObject org = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getBizOrg(Long.valueOf(orgId), orgFunc);
        return org != null;
    }

    public boolean canBeMainOrg(long orgId, boolean isBindingPerm, Set<Long> authOrgIds) {
        return this.canBeMainOrg(orgId, this.getOrgFunc(), isBindingPerm, authOrgIds);
    }

    private boolean canBeMainOrg(long orgId, String orgFunc, boolean isBindingPerm, Set<Long> authOrgIds) {
        if (orgId == 0L) {
            return false;
        }
        if (isBindingPerm && !authOrgIds.contains(orgId)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orgFunc)) {
            return true;
        }
        DynamicObject org = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getBizOrg(Long.valueOf(orgId), orgFunc);
        return org != null;
    }

    @Override
    @KSMethod
    public List<QFilter> buildCoreFilterByString(IDataModel model) {
        List<QFilter> filters = super.buildCoreFilterByString(model);
        String entityId = model.getDataEntityType().getName();
        if (this.isBindingAddNewPerm(entityId)) {
            StringBuilder builder = new StringBuilder();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            String appNumber = (String)model.getContextVariable("APPID");
            builder.append("appId:===========getContextVariable: ").append(appNumber);
            IDefValueProvider defValueProvider = (IDefValueProvider)model.getService(IDefValueProvider.class);
            String appId = null;
            if (StringUtils.isBlank((CharSequence)appNumber)) {
                if (defValueProvider == null) {
                    appNumber = model.getDataEntityType().getBizAppNumber();
                    appId = AppMetadataCache.getAppInfo(appNumber).getId();
                    builder.append("appId:===========appNumber is null and defValueProvider is null,appId: ").append(appId);
                } else {
                    appId = defValueProvider.getAppId(model);
                    builder.append("appId:===========appNumber is null and defValueProvider is not null, appId: ").append(appId).append(" className: ").append(defValueProvider.getClass().getName());
                }
            } else {
                appId = AppMetadataCache.getAppInfo(appNumber).getId();
                builder.append("appId:===========appNumber is not null appId: ").append(appId);
            }
            if (StringUtils.isBlank((CharSequence)appId)) {
                appNumber = model.getDataEntityType().getBizAppNumber();
                appId = AppMetadataCache.getAppInfo(appNumber).getId();
                builder.append("appId:===========getBizAppNumber is select  ").append(appId);
            }
            QFilter orgFilter = null;
            HasPermOrgResult hasPermOrgResult = ((ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class)).getAllPermOrgs(userId, appId, entityId, ADD_NEW_PERMITEMID);
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                if (!hasPermOrgResult.getHasPermOrgs().isEmpty()) {
                    HashSet idSet = new HashSet();
                    idSet.addAll(hasPermOrgResult.getHasPermOrgs());
                    orgFilter = new QFilter("id", "in", idSet);
                } else {
                    orgFilter = new QFilter("id", "=", (Object)-1);
                }
                filters.add(orgFilter);
            }
            log.info(builder.toString());
        }
        return filters;
    }

    public QFilter getPermissionFilter(String entityId, String appId, String permissionItem) {
        return PermissionFilterUtil.getMainOrgFilter(this, entityId, appId, null, "", -1, permissionItem);
    }
}

