/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MaterielProp
extends BasedataProp {
    private static final long serialVersionUID = -2662508438008936354L;

    @Override
    public List<FilterField> createFilterFields(MainEntityType mainType) {
        List<FilterField> filterFields = super.createFilterFields(mainType);
        filterFields.removeIf(p -> {
            BasedataEntityType bdType = (BasedataEntityType)this.getComplexType();
            String id = p.getFieldName();
            return bdType.getMasteridType() == 2 && StringUtils.isNotBlank((CharSequence)bdType.getMasteridPropName()) && bdType.getProperties().containsKey((Object)bdType.getMasteridPropName()) && (id.equals(this.getName() + "." + bdType.getNumberProperty()) || id.equals(this.getName() + "." + bdType.getNameProperty()) || id.equals(this.getName() + "." + bdType.getPrimaryKey().getName()));
        });
        return filterFields;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(EntityTreeNode parentEntityTreeNode, boolean isAllNode) {
        List<Map<String, Object>> refBasedataTreeNodes = super.createEntityTreeNodes(parentEntityTreeNode, isAllNode);
        BasedataEntityType bdType = (BasedataEntityType)this.getComplexType();
        String preKey = StringUtils.isNotBlank((CharSequence)parentEntityTreeNode.getTreeNodeKey()) ? parentEntityTreeNode.getTreeNodeKey() + "." : "";
        refBasedataTreeNodes.removeIf(p -> {
            Object id = p.get("Id");
            return id != null && bdType.getMasteridType() == 2 && StringUtils.isNotBlank((CharSequence)bdType.getMasteridPropName()) && bdType.getProperties().containsKey((Object)bdType.getMasteridPropName()) && (id.toString().equals(preKey + this.getName() + "." + bdType.getNumberProperty()) || id.toString().equals(preKey + this.getName() + "." + bdType.getNameProperty()) || id.toString().equals(preKey + this.getName() + "." + bdType.getPrimaryKey().getName()));
        });
        return refBasedataTreeNodes;
    }

    @Override
    public FilterField createFilterField(MainEntityType mainType, String refPropKey) {
        IDataEntityProperty refProp1 = null;
        IDataEntityProperty refProp2 = null;
        String refEntityId = this.getBaseEntityId();
        ArrayList<IDataEntityProperty> refProps = new ArrayList<IDataEntityProperty>();
        String[] keys = refPropKey.split("\\.");
        if (keys.length > 1) {
            BasedataEntityType bdType1 = (BasedataEntityType)this.getComplexType();
            refProp1 = bdType1.findProperty(keys[1]);
            refEntityId = bdType1.getName();
            refProps.add(refProp1);
            if (refProp1 instanceof IBasedataField && keys.length > 2) {
                for (int i = 2; i < keys.length; ++i) {
                    BasedataEntityType bdType2 = null;
                    refProp2 = null;
                    if (refProp1 instanceof BasedataProp) {
                        bdType2 = (BasedataEntityType)((IBasedataField)refProp1).getComplexType();
                        refProp2 = bdType2.findProperty(keys[i]);
                        refEntityId = bdType2.getName();
                    } else if (refProp1 instanceof MulBasedataProp) {
                        DynamicObjectType dynamicCollectionItemPropertyType = ((MulBasedataProp)refProp1).getDynamicCollectionItemPropertyType();
                        bdType2 = (BasedataEntityType)((BasedataProp)dynamicCollectionItemPropertyType.getProperty(keys[i])).getComplexType();
                        refProp2 = "id".equals(keys[i + 1]) ? bdType2.findProperty(bdType2.getName() + "." + keys[i + 1]) : bdType2.findProperty(keys[i + 1]);
                        refEntityId = bdType2.getName();
                    }
                    if (refProp2 == null) continue;
                    refProps.add(refProp2);
                    refProp1 = refProp2;
                }
                if (refProps.size() >= 2) {
                    refProp2 = (IDataEntityProperty)refProps.get(refProps.size() - 1);
                    refProp1 = (IDataEntityProperty)refProps.get(refProps.size() - 2);
                }
            }
        }
        FilterField filterField = new FilterField(mainType, (IDataEntityProperty)this, refProp1, refProp2, refEntityId);
        if (refProps.size() > 2) {
            String fullFieldName = this.buildMultiLevelFullFieldName((IDataEntityProperty)this, refProps);
            filterField.setFieldName(this.bulidMultiLevelFieldName((IDataEntityProperty)this, refProps));
            filterField.setFullFieldName(fullFieldName);
            LocaleString caption = new LocaleString(this.getMultiLevelFullFieldCaption((IDataEntityProperty)this, refProps));
            filterField.setCaption(caption);
        }
        return filterField;
    }

    public String bulidMultiLevelFieldName(IDataEntityProperty srcFieldProp, List<IDataEntityProperty> refProps) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(srcFieldProp.getName());
        for (IDataEntityProperty refProp : refProps) {
            if (((DynamicProperty)refProp).getDisplayName() != null) {
                keys.add(((DynamicProperty)refProp).getName());
                continue;
            }
            keys.add(refProp.getName());
        }
        return StringUtils.join((Object[])keys.toArray(), (String)".");
    }

    @Override
    @KSMethod
    public String getDisplayValue(Object basedataObj) {
        if (basedataObj == null) {
            return null;
        }
        BasedataEntityType type = (BasedataEntityType)this.getComplexType();
        if (type.getMasteridType() != 2) {
            return super.getDisplayValue(basedataObj);
        }
        MasterBasedataProp masteridProp = (MasterBasedataProp)type.findProperty(type.getMasteridPropName());
        if (masteridProp == null) {
            return super.getDisplayValue(basedataObj);
        }
        DynamicObject masterObj = (DynamicObject)masteridProp.getValue(basedataObj);
        return masteridProp.getDisplayValue(masterObj);
    }

    private String buildMultiLevelFullFieldName(IDataEntityProperty srcFieldProp, List<IDataEntityProperty> refProps) {
        ArrayList<String> propNames = new ArrayList<String>();
        String srcPropFullName = FilterField.buildPropORMFullNameByName(srcFieldProp instanceof MulBasedataProp && refProps.get(0) != null && !"fbasedataid".equals(refProps.get(0).getName()) ? srcFieldProp.getName() + ".fbasedataid" : srcFieldProp.getName(), srcFieldProp.getParent());
        propNames.add(srcPropFullName);
        for (IDataEntityProperty refProp : refProps) {
            if (refProp == null) continue;
            String refPropFullName = FilterField.buildPropORMFullNameByName(refProp instanceof MulBasedataProp ? refProp.getName() + ".fbasedataid" : refProp.getName(), refProp.getParent());
            propNames.add(refPropFullName);
        }
        return StringUtils.join((Object[])propNames.toArray(), (String)".");
    }

    private String getMultiLevelFullFieldCaption(IDataEntityProperty srcFieldProp, List<IDataEntityProperty> refProps) {
        ArrayList<String> propCaptions = new ArrayList<String>();
        EntityType entityType = (EntityType)srcFieldProp.getParent();
        if (entityType instanceof EntryType) {
            if (entityType.getDisplayName() != null) {
                propCaptions.add(entityType.getDisplayName().toString());
            } else {
                propCaptions.add(entityType.getName());
            }
        }
        if (((DynamicProperty)srcFieldProp).getDisplayName() != null) {
            propCaptions.add(((DynamicProperty)srcFieldProp).getDisplayName().toString());
        } else {
            propCaptions.add(srcFieldProp.getName());
        }
        for (IDataEntityProperty refProp : refProps) {
            if (((DynamicProperty)refProp).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)refProp).getDisplayName().toString());
                continue;
            }
            propCaptions.add(refProp.getName());
        }
        return StringUtils.join((Object[])propCaptions.toArray(), (String)".");
    }
}

