/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ComboPropShowStyle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;
import org.apache.logging.log4j.util.Strings;

@KSObject
@SdkPublic
public class MulComboProp
extends ComboProp {
    private static final long serialVersionUID = -7314462680658131362L;

    @Override
    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        super.setFieldValueForWebApi(model, dataEntity, this.fixValue(value), checkImportable);
    }

    private Object fixValue(Object value) {
        Object newValue = value;
        if (value != null) {
            List splitValues = Arrays.asList(value.toString().split("\\,")).stream().filter(t -> !StringUtils.isBlank((CharSequence)t)).collect(Collectors.toList());
            newValue = "," + Strings.join(splitValues, (char)',') + ",";
        }
        return newValue;
    }

    @Override
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        super.setFieldValue(model, dataEntity, this.fixValue(value));
    }

    public MulComboProp() {
        this.compareGroupID = "12,2";
        this.defaultCompareTypeId = "1201";
        this.defaultMultiCompareTypeId = "1201";
    }

    @Override
    public String getItemByName(String name) {
        String[] items = name.split(",");
        ArrayList<String> itemNameList = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            String itemName;
            if (StringUtils.isEmpty((CharSequence)items[i]) || !StringUtils.isNotEmpty((CharSequence)(itemName = super.getItemByName(items[i])))) continue;
            itemNameList.add(itemName);
        }
        return StringUtils.join((Object[])itemNameList.toArray(), (String)" ");
    }

    @Override
    @KSMethod
    public Object getItemByNameAndShowStyle(String name, int showStyleId) {
        String[] items = name.split(",");
        String[] itemName = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            ValueMapItem valueMapItem = this.getValueMapItemByName(items[i]);
            if (valueMapItem == null) continue;
            itemName[i] = showStyleId == ComboPropShowStyle.Img.getValue() ? valueMapItem.getImageKey() : valueMapItem.getName().toString();
        }
        return itemName;
    }

    @Override
    public Map<String, Object> createEntityTreeNode(EntityTreeNode parentEntityTreeNode) {
        Map<String, Object> col = super.createEntityTreeNode(parentEntityTreeNode);
        col.put("Type", "MulComboListColumnAp");
        return col;
    }

    @Override
    public String getClientType() {
        String clientType = "mulcombo";
        if (StringUtils.equals((CharSequence)"flat", (CharSequence)this.getOptionDisplayMode())) {
            clientType = "checkboxgroup";
        }
        return clientType;
    }

    @Override
    public IValueComparator getValueComparator() {
        return o -> {
            if (StringUtils.isBlank((Object)o)) {
                return true;
            }
            return ",,".equals(o.toString());
        };
    }
}

