/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.filter.ColumnParam;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CoreLicenseServiceUtils;
import kd.bos.entity.property.FieldPropSeq;
import kd.bos.entity.property.FieldRuleArgs;
import kd.bos.entity.property.IFieldSeq;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.org.OrgRelationItem;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class OrgProp
extends BasedataProp
implements IFieldSeq {
    private static final String ORGRELATIONITEM_TYPE_ORGUNIT2ADMIN = "orgunit2admin";
    private static final String BOS_BILLPARAMETER_BOSCARRYADMINORG = "boscarryadminorg";
    private String orgFunc;
    private int f7Style;
    private List<OrgRelationItem> orgRelation = new ArrayList<OrgRelationItem>();
    private OrgViewSchemeProp orgViewScheme;
    private static final long serialVersionUID = 6885797733495127588L;
    private QFilter bizOrgFilter = null;

    public OrgProp() {
        this.compareGroupID = "2,3,7";
        this.filterControlType = "org";
        this.defaultCompareTypeId = "110";
        this.defaultMultiCompareTypeId = "111";
    }

    @Override
    @KSMethod
    public String getBaseEntityId() {
        return "bos_org";
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute
    public String getOrgFunc() {
        return this.orgFunc;
    }

    @Override
    public void setOrgFunc(String orgFunc) {
        this.orgFunc = orgFunc;
    }

    @KSMethod
    @SimplePropertyAttribute
    public int getF7Style() {
        return this.f7Style;
    }

    public void setF7Style(int f7Style) {
        this.f7Style = f7Style;
    }

    @KSMethod
    @CollectionPropertyAttribute(collectionItemPropertyType=OrgRelationItem.class)
    public List<OrgRelationItem> getOrgRelation() {
        return this.orgRelation;
    }

    public void setOrgRelation(List<OrgRelationItem> orgRelation) {
        this.orgRelation = orgRelation;
    }

    @ComplexPropertyAttribute
    public OrgViewSchemeProp getOrgViewScheme() {
        return this.orgViewScheme;
    }

    public void setOrgViewScheme(OrgViewSchemeProp orgViewScheme) {
        this.orgViewScheme = orgViewScheme;
    }

    public QFilter getBizOrgFilter() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        if (this.bizOrgFilter == null && this.getOrgFunc() != null) {
            this.bizOrgFilter = orgService.getBizOrgFilter(this.getOrgFunc());
        }
        return this.bizOrgFilter;
    }

    @Override
    @KSMethod
    public List<QFilter> buildCoreFilterByString(IDataModel model) {
        List filters = super.buildCoreFilterByString(model);
        filters.add(this.getBizOrgFilter());
        return filters;
    }

    @Override
    public List<String> getPkPropCompareTypeIds() {
        return Stream.of(CompareTypeEnum.ORGEQUAL.getId(), CompareTypeEnum.ORGNOTEQUAL.getId(), CompareTypeEnum.ORGIN.getId(), CompareTypeEnum.ORGNOTIN.getId(), CompareTypeEnum.ISNULL.getId(), CompareTypeEnum.ISNOTNULL.getId()).collect(Collectors.toList());
    }

    @Override
    public List<String> getSearchCompareTypeIds() {
        return Stream.of(CompareTypeEnum.ORGEQUAL.getId(), CompareTypeEnum.ORGNOTEQUAL.getId(), CompareTypeEnum.ORGIN.getId(), CompareTypeEnum.ORGNOTIN.getId()).collect(Collectors.toList());
    }

    @Override
    public void afterCreateFilterColumn(Map<String, Object> column, ColumnParam param) {
        if (param.getFilterField() != null) {
            super.afterCreateFilterColumn(column, param);
        }
    }

    @Override
    public List<FilterField> createFilterFields(MainEntityType mainType) {
        List<FilterField> fields = super.createFilterFields(mainType);
        for (FilterField filterField : fields) {
            this.resetOrgPropCompareId(filterField);
        }
        return fields;
    }

    private void resetOrgPropCompareId(FilterField field) {
        if (field.getRefProp1() instanceof OrgProp || field.getRefProp2() == null && field.getSrcFieldProp() instanceof OrgProp) {
            List<CompareType> compareTypes = FilterMetadata.get().getCompareTypes("7");
            List<CompareType> compareTypes1 = FilterMetadata.get().getCompareTypes("2,3");
            if (compareTypes.size() > 4) {
                compareTypes.addAll(4, compareTypes1);
            } else {
                compareTypes.addAll(compareTypes1);
            }
            if (!(field.getFieldProp() instanceof TextProp)) {
                for (CompareType compareType : compareTypes) {
                    if (!"58".equals(compareType.getId()) && !"59".equals(compareType.getId()) && !"60".equals(compareType.getId()) && !"211".equals(compareType.getId())) continue;
                    compareType.setVisible(false);
                }
            }
            field.setCompareTypes(compareTypes);
            field.setDefaultCompareTypeId(this.defaultCompareTypeId);
            field.setDefaultMultiCompareTypeId(this.defaultMultiCompareTypeId);
        }
    }

    @Override
    public FilterField createFilterField(MainEntityType mainType, String refPropKey) {
        FilterField field = super.createFilterField(mainType, refPropKey);
        this.resetOrgPropCompareId(field);
        return field;
    }

    @Override
    @KSMethod
    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        OrgProp mainProp;
        String mainOrgFunc;
        String currentOrgFunc;
        String mainOrgKey;
        super.applyDefaultValue(model, dataEntity, rowIndex);
        Object defOrgValue = null;
        List<OrgRelationItem> lstRelation = this.getOrgRelation();
        if (lstRelation != null && lstRelation.size() > 0) {
            if (!this.isCarryOrgDefValue(lstRelation.get(0), model.getDataEntityType().getName())) {
                return;
            }
            IDefValueProvider defValueProvider = (IDefValueProvider)model.getService(IDefValueProvider.class);
            if (defValueProvider != null) {
                ChangeData change = new ChangeData(rowIndex, dataEntity, null, null);
                defOrgValue = defValueProvider.getOrgDefValue(model, this, change);
            }
        }
        if (defOrgValue == null && StringUtils.isNotBlank((CharSequence)(mainOrgKey = model.getDataEntityType().getMainOrg())) && StringUtils.isNotBlank((CharSequence)(currentOrgFunc = this.getOrgFunc())) && StringUtils.isNotBlank((CharSequence)(mainOrgFunc = (mainProp = (OrgProp)model.getDataEntityType().getProperty(mainOrgKey)).getOrgFunc())) && StringUtils.isNotBlank((CharSequence)currentOrgFunc) && mainOrgFunc.equals(currentOrgFunc) && !currentOrgFunc.equalsIgnoreCase("01")) {
            defOrgValue = model.getValue(mainOrgKey);
        }
        if ((defOrgValue = this.getDefaultValueByOrgView(defOrgValue)) == null || "0".equals(defOrgValue.toString())) {
            if (CoreLicenseServiceUtils.isXKSingleMode() && this.isMustInput()) {
                if (CoreLicenseServiceUtils.isXKStandardSingleMode() && model.getDataEntityType() instanceof BasedataEntityType && !this.isMustInput()) {
                    return;
                }
                IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
                this.setFieldValue(model, dataEntity, orgService.getRootOrgId());
            }
        } else {
            this.setFieldValue(model, dataEntity, defOrgValue);
        }
    }

    private Object getDefaultValueByOrgView(Object defOrgValue) {
        Long orgId;
        if (defOrgValue == null) {
            return null;
        }
        String viewNumber = null;
        OrgViewSchemeProp orgViewScheme = this.getOrgViewScheme();
        if (orgViewScheme != null) {
            viewNumber = orgViewScheme.getNumber();
        }
        if (StringUtils.isBlank(viewNumber)) {
            viewNumber = this.getOrgFunc();
        }
        if (StringUtils.isBlank((CharSequence)viewNumber)) {
            return defOrgValue;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        if (defOrgValue instanceof Long) {
            orgId = (Long)defOrgValue;
        } else if (defOrgValue instanceof DynamicObject) {
            orgId = (Long)((DynamicObject)defOrgValue).getPkValue();
        } else if (defOrgValue instanceof Integer) {
            orgId = Long.valueOf(defOrgValue.toString());
        } else {
            return defOrgValue;
        }
        orgIds.add(orgId);
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List defOrgIds = orgService.filterOrgDuty(orgIds, viewNumber);
        if (defOrgIds == null || defOrgIds.isEmpty()) {
            defOrgValue = null;
        }
        return defOrgValue;
    }

    public Map<String, Object> getShowFormCustomParams() {
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        customParamMap.put("entityId", this.getBaseEntityId());
        customParamMap.put("orgFuncId", this.orgFunc);
        if (this.orgViewScheme != null) {
            customParamMap.put("orgViewSchemeNumber", this.orgViewScheme.getNumber());
        }
        return customParamMap;
    }

    @Override
    @KSMethod
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        if (value == null || value instanceof String && ((String)value).isEmpty() || "0".equals(value.toString())) {
            this.setValueFast(dataEntity, null);
            return;
        }
        super.setFieldValue(model, dataEntity, value);
    }

    @Override
    public int getFieldSeq() {
        return FieldPropSeq.OrgProp.getValue();
    }

    @Override
    public List<QFilter> getF7InnerFilters(String formId, String entityId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter bizOrgFilter = this.getBizOrgFilter();
        if (bizOrgFilter != null) {
            qFilters.add(bizOrgFilter);
        }
        return qFilters;
    }

    @Override
    public List<AbstractRule> getFieldRules(FieldRuleArgs args) {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>(1);
        rules.addAll(super.getFieldRules(args));
        IDataEntityProperty triggerProperty = args.getTriggerProperty();
        if (triggerProperty instanceof OrgProp) {
            if (triggerProperty.getParent() instanceof FlexEntityType) {
                return rules;
            }
            BR updateOrgDelegateRule = new BR();
            updateOrgDelegateRule.setSource(args.getSource());
            updateOrgDelegateRule.setDescription(ResManager.loadKDString((String)"\u66f4\u65b0\u6709\u59d4\u6258\u5173\u8054\u7684\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]));
            updateOrgDelegateRule.setRET(0);
            updateOrgDelegateRule.setEnabled(true);
            updateOrgDelegateRule.setDescription(ResManager.loadKDString((String)"\u7ec4\u7ec7\u66f4\u65b0\u59d4\u6258\u5173\u7cfb\u4e1a\u52a1\u89c4\u5219", (String)"OrgProp_1", (String)"bos-entity-metadata", (Object[])new Object[0]));
            updateOrgDelegateRule.setPreCondition("");
            updateOrgDelegateRule.setDepFldKeys(this.getName());
            ArrayList<Map<String, Object>> updateOrgDelegateRuleActions = new ArrayList<Map<String, Object>>(10);
            LinkedHashMap<String, Object> orgDelegateAction = new LinkedHashMap<String, Object>(16);
            orgDelegateAction.put("ret", "253");
            orgDelegateAction.put("orgField", this.getName());
            HashSet<String> fieldSet = new HashSet<String>(1);
            fieldSet.add(this.getName());
            orgDelegateAction.put("dependencyFields", fieldSet);
            orgDelegateAction.put("actionId", Uuid16.create().toString());
            orgDelegateAction.put("class", "kd.bos.entity.rule.UpdateOrgDelegateAction");
            orgDelegateAction.put("description", ResManager.loadKDString((String)"\u66f4\u65b0\u6709\u59d4\u6258\u5173\u8054\u7684\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]));
            updateOrgDelegateRuleActions.add(orgDelegateAction);
            updateOrgDelegateRule.setTrueActions(updateOrgDelegateRuleActions);
            rules.add(updateOrgDelegateRule);
        }
        return rules;
    }

    private boolean isCarryOrgDefValue(OrgRelationItem orgRelationItem, String formId) {
        IParameterReaderService parameterReader;
        DynamicObject billParamObj;
        if (orgRelationItem.getType() != null && ORGRELATIONITEM_TYPE_ORGUNIT2ADMIN.equals(orgRelationItem.getType().getNumber()) && (billParamObj = (parameterReader = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).getBillParameter(formId)) != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)BOS_BILLPARAMETER_BOSCARRYADMINORG)) {
            return billParamObj.getBoolean(BOS_BILLPARAMETER_BOSCARRYADMINORG);
        }
        return true;
    }
}

