/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IDirtyProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.id.ID;

public class SubEntryTextProp
extends TextProp
implements IDirtyProperty {
    public SubEntryTextProp() {
        this._defaultValue = null;
    }

    private SubEntryProp getSubEntryProp(DynamicObject dataEntity) {
        String subEntryKey = this.getName().substring(0, this.getName().length() - 5);
        IDataEntityProperty entryProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)subEntryKey);
        if (entryProp instanceof SubEntryProp) {
            return (SubEntryProp)entryProp;
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5b50\u5355\u636e\u4f53\u5931\u8d25.%1$s", (String)"SubEntryTextProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]), this.getName()));
    }

    public Object getDTValueFast(DynamicObject dataEntity) {
        SubEntryProp subEntryProp = this.getSubEntryProp(dataEntity);
        DynamicObjectCollection rows = (DynamicObjectCollection)subEntryProp.getValueFast(dataEntity);
        if (rows == null) {
            return null;
        }
        this.setSubEntryId(rows);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeIndex(true);
        return SerializationUtils.toJsonString((Object)DataEntitySerializer.serializerToMap((IDataEntityType)subEntryProp.getItemType(), (List)rows, (DataEntitySerializerOption)option));
    }

    private void setSubEntryId(DynamicObjectCollection rows) {
        DynamicObjectType dt = rows.getDynamicObjectType();
        if (dt.getPrimaryKey() == null) {
            return;
        }
        ISimpleProperty pkProperty = dt.getPrimaryKey();
        Object[] ids = this.newIds(pkProperty, rows.size());
        int i = 0;
        for (DynamicObject row : rows) {
            if (!this.isEmptyPK(pkProperty, row.getPkValue())) continue;
            pkProperty.setValueFast((Object)row, ids[i++]);
        }
    }

    private Object[] newIds(ISimpleProperty pkProperty, int count) {
        if (pkProperty.getPropertyType() == String.class) {
            return ID.genStringIds((int)count);
        }
        long[] ids = ID.genLongIds((int)count);
        Object[] ret = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ret[i] = ids[i];
        }
        return ret;
    }

    private boolean isEmptyPK(ISimpleProperty pkProperty, Object pk) {
        if (pk == null) {
            return true;
        }
        if (pkProperty.getPropertyType() == String.class) {
            return StringUtils.isEmpty((CharSequence)((String)pk));
        }
        return pk.equals(0L);
    }

    protected void setValuePrivate(DynamicObject dataEntity, Object newValue) {
        SubEntryProp subEntryProp = this.getSubEntryProp(dataEntity);
        DynamicObjectCollection cols = (DynamicObjectCollection)subEntryProp.getValueFast(dataEntity);
        if (newValue != null) {
            JSONObject map = JSON.parseObject((String)((String)newValue));
            if (map == null) {
                return;
            }
            List o = (List)map.get("data");
            if (o.size() != cols.size()) {
                cols.clear();
                DataEntitySerializer.deserializerFromMap((Map)map, (List)cols, (IDataEntityType)subEntryProp.getItemType(), null);
                this.setSeq(cols.getStartRowIndex(), (List<DynamicObject>)cols, subEntryProp.getItemType());
                for (DynamicObject col : cols) {
                    col.getDataEntityState().setFromDatabase(true);
                }
            }
        }
    }

    private void setSeq(int start, List<DynamicObject> cols, IDataEntityType itemType) {
        IDataEntityProperty propSeq = (IDataEntityProperty)itemType.getProperties().get((Object)"seq");
        if (propSeq != null) {
            for (int i = 0; i < cols.size(); ++i) {
                propSeq.setValueFast((Object)cols.get(i), (Object)(start + i + 1));
            }
        }
    }

    public boolean isDirty() {
        return true;
    }
}

