/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.List;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.LocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IScopeCheck;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.entity.validate.ScopeValidator;
import kd.bos.exception.KDBizException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TextProp
extends FieldProp
implements IScopeCheck {
    private static final long serialVersionUID = -7273296035372602161L;
    private int maxLenth;
    private int minLenth;
    private String dataScopeMessage;
    private String scopeMsgWithoutFieldName;
    private boolean password;
    private boolean showEye;

    public TextProp() {
        this.filterControlType = "text";
        this.compareGroupID = "0,1,2,3,4";
        this._defaultValue = "";
    }

    @Override
    public int getDbType() {
        return -9;
    }

    public Class<?> getPropertyType() {
        return String.class;
    }

    @KSMethod
    @SimplePropertyAttribute
    public int getMaxLenth() {
        return this.maxLenth;
    }

    public void setMaxLenth(int maxLenth) {
        this.maxLenth = maxLenth;
    }

    @KSMethod
    @SimplePropertyAttribute
    public int getMinLenth() {
        return this.minLenth;
    }

    public void setMinLenth(int minLenth) {
        this.minLenth = minLenth;
    }

    @Override
    public IValueComparator getValueComparator() {
        return new IValueComparator(){

            @Override
            public boolean compareValue(Object o) {
                return o == null || o != null && StringUtils.isBlank((CharSequence)o.toString());
            }
        };
    }

    @Override
    public List<AbstractValidator> getValidators() {
        List<AbstractValidator> validators = super.getValidators();
        ScopeValidator scopeValidator = new ScopeValidator((DynamicProperty)this, this.getName(), "");
        if (this.minLenth == 0) {
            scopeValidator.setCheckPoint(253);
        }
        validators.add(scopeValidator);
        return validators;
    }

    @Override
    public boolean checkScope(Object fldValue) {
        int valueLength = 0;
        if (fldValue instanceof String) {
            valueLength = ((String)fldValue).trim().length();
        }
        return valueLength >= this.getMinLenth() && (this.getMaxLenth() <= 0 || valueLength <= this.getMaxLenth());
    }

    @Override
    public String getDataScopeMessage(Object fldValue) {
        if (this.dataScopeMessage == null) {
            this.dataScopeMessage = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[%2$s,%3$s]\u3002", (String)"TextProp_0", (String)"bos-entity-metadata", (Object[])new Object[0]), this.getDisplayName() == null ? this.getName() : this.getDisplayName().toString(), this.minLenth, this.maxLenth);
        }
        return this.dataScopeMessage;
    }

    @Override
    public String getDataScopeMessage(Object fldValue, boolean withFieldTitle) {
        if (withFieldTitle) {
            return this.getDataScopeMessage(fldValue);
        }
        if (this.scopeMsgWithoutFieldName == null) {
            this.scopeMsgWithoutFieldName = String.format(ResManager.loadKDString((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[%2$s,%3$s]\u3002", (String)"TextProp_2", (String)"bos-entity-metadata", (Object[])new Object[0]), this.getDisplayName() == null ? this.getName() : this.getDisplayName().toString(), this.minLenth, this.maxLenth);
        }
        return this.scopeMsgWithoutFieldName;
    }

    @Override
    protected ColumnDesc createColumnDesc(ListField col) {
        return new TextColumnDesc(col.getKey(), (IDataEntityProperty)this, col.getFieldProp());
    }

    @Override
    public String getClientType() {
        return "text";
    }

    @SimplePropertyAttribute(name="Password")
    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    @SimplePropertyAttribute(name="ShowEye")
    @DefaultValueAttribute(value="false")
    public boolean isShowEye() {
        return this.showEye;
    }

    public void setShowEye(boolean showEye) {
        this.showEye = showEye;
    }

    @Override
    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        if (checkImportable && !this.isImportable()) {
            LocaleString dispName = this.getDisplayName();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"TextProp_1", (String)"bos-entity-metadata", (Object[])new Object[0]), StringUtils.isNotBlank((Object)dispName) ? dispName.toString() : this.getName()));
        }
        if (!this.checkScope(value)) {
            throw new KDBizException(this.getDataScopeMessage(value));
        }
        this.setFieldValue(model, dataEntity, value);
    }

    @Override
    @KSMethod
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        this.setValueFast(dataEntity, value);
    }

    public long getEstimatedLen() {
        return (this.minLenth + this.maxLenth) / 2;
    }

    @Override
    public Object getBasePropDisplayValue(Object baseObj) {
        Object v = super.getBasePropDisplayValue(baseObj);
        if (v instanceof ILocaleValue) {
            if (this.isPassword()) {
                return new LocaleValue((Object)"******");
            }
        } else {
            if (StringUtils.isBlank((Object)v)) {
                return v;
            }
            if (this.isPassword()) {
                return "******";
            }
        }
        return v;
    }
}

