/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property.entryfilter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntrySortItemInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;

public class EntryQueryParam
implements Serializable {
    private static final long serialVersionUID = 5615545619003921593L;
    private List<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>(10);
    private List<EntrySortItemInfo> sortItems = new ArrayList<EntrySortItemInfo>(1);
    private List<SimpleFilterRow> defaultFilterRows = new ArrayList<SimpleFilterRow>(10);
    private int parentIndex = -1;

    public FilterCondition buildFilterCondition() {
        FilterCondition filterCondition = new FilterCondition();
        this.buildFilterConditionByFilterItems(filterCondition, this.filterItems);
        for (SimpleFilterRow filterRow : this.defaultFilterRows) {
            filterCondition.addFilterRow(filterRow);
        }
        return filterCondition;
    }

    private void buildFilterConditionByFilterItems(FilterCondition filterCondition, List<EntryFilterItemInfo> filterItems) {
        if (CollectionUtils.isEmpty(filterItems)) {
            return;
        }
        for (EntryFilterItemInfo item : filterItems) {
            ArrayList<FilterValue> value = new ArrayList<FilterValue>(1);
            FilterValue filterValue = null;
            if (item.getValue() instanceof List) {
                List list = (List)item.getValue();
                for (Object obj : list) {
                    filterValue = new FilterValue();
                    filterValue.setValue(obj);
                    value.add(filterValue);
                }
            } else {
                if (CompareTypeEnum.IN.getId().equals(item.getCompareType()) || CompareTypeEnum.ORGIN.getId().equals(item.getCompareType())) {
                    String valueStr;
                    String string = valueStr = item.getValue() == null ? "" : (String)item.getValue();
                    if (!StringUtils.isEmpty((Object)valueStr) && valueStr.contains(",")) {
                        String[] values;
                        for (String val : values = valueStr.split(",")) {
                            if (StringUtils.isEmpty((Object)val)) continue;
                            filterValue = new FilterValue();
                            filterValue.setValue((Object)val);
                            value.add(filterValue);
                        }
                    }
                }
                if (value.isEmpty()) {
                    filterValue = new FilterValue();
                    filterValue.setValue(item.getValue());
                    value.add(filterValue);
                }
            }
            this.addSimpleFilterRow(filterCondition, item, value);
        }
    }

    public boolean needFilterAndSort() {
        return !CollectionUtils.isEmpty(this.filterItems) || !CollectionUtils.isEmpty(this.defaultFilterRows) || !CollectionUtils.isEmpty(this.sortItems);
    }

    private void addSimpleFilterRow(FilterCondition filterCondition, EntryFilterItemInfo item, List<FilterValue> value) {
        String[] displayPropArr = item.getDisplayProps();
        SimpleFilterRow simpleFilterRow = null;
        StringBuilder propNameBuilder = null;
        if (displayPropArr != null && displayPropArr.length > 1) {
            for (int i = 0; i < displayPropArr.length; ++i) {
                propNameBuilder = new StringBuilder(item.getPropName());
                propNameBuilder.append(".").append(displayPropArr[i]);
                simpleFilterRow = i == 0 ? new SimpleFilterRow("(", item.getCompareType(), propNameBuilder.toString(), "", LogicOperate.OR.name(), value) : (i == displayPropArr.length - 1 ? new SimpleFilterRow("", item.getCompareType(), propNameBuilder.toString(), ")", LogicOperate.AND.name(), value) : new SimpleFilterRow("", item.getCompareType(), propNameBuilder.toString(), "", LogicOperate.OR.name(), value));
                filterCondition.addFilterRow(simpleFilterRow);
            }
        } else {
            if (!StringUtils.isEmpty((Object)item.getRealFieldName())) {
                propNameBuilder = new StringBuilder(item.getRealFieldName());
            } else {
                propNameBuilder = new StringBuilder(item.getPropName());
                if (displayPropArr != null && displayPropArr.length == 1) {
                    propNameBuilder.append(".").append(displayPropArr[0]);
                }
            }
            simpleFilterRow = new SimpleFilterRow("", item.getCompareType(), propNameBuilder.toString(), "", LogicOperate.AND.name(), value);
            filterCondition.addFilterRow(simpleFilterRow);
        }
    }

    public List<EntryFilterItemInfo> getFilterItems() {
        return this.filterItems;
    }

    public void setFilterItems(List<EntryFilterItemInfo> filterItems) {
        this.filterItems = filterItems;
    }

    public List<SimpleFilterRow> getDefaultFilterRows() {
        return this.defaultFilterRows;
    }

    public void setDefaultFilterRows(List<SimpleFilterRow> defaultFilterRows) {
        this.defaultFilterRows = defaultFilterRows;
    }

    public List<EntrySortItemInfo> getSortItems() {
        return this.sortItems;
    }

    public void setSortItems(List<EntrySortItemInfo> sortItems) {
        this.sortItems = sortItems;
    }

    public int getParentIndex() {
        return this.parentIndex;
    }

    public void setParentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }
}

