/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property.org;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.BasedataExchangeRequest;
import kd.bos.entity.property.org.DefaultPropExchangeOrg;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;

class BasedataPropExchangeOrg
extends DefaultPropExchangeOrg {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private RowDataModel rowDataModel;
    private OrgProp orgProp;

    BasedataPropExchangeOrg() {
    }

    public BasedataProp getBasedataProp() {
        return (BasedataProp)this.getProp();
    }

    public OrgProp getOrgProp() {
        if (this.orgProp != null) {
            return this.orgProp;
        }
        if (this.getBasedataProp() == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.getBasedataProp().getOrgProp())) {
            this.orgProp = this.getContext().getMainOrgProp();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.getBasedataProp().getOrgProp(), (CharSequence)this.getContext().getMainOrgProp().getName())) {
            this.orgProp = this.getContext().getMainOrgProp();
        } else {
            IDataEntityProperty prop = this.getContext().getModel().getProperty(this.getBasedataProp().getOrgProp());
            if (prop instanceof OrgProp) {
                this.orgProp = (OrgProp)prop;
            }
        }
        return this.orgProp;
    }

    public DynamicObject getOrgValue(DynamicObject dataEntity) {
        if (this.getOrgProp() == null) {
            return null;
        }
        if (this.rowDataModel == null) {
            this.rowDataModel = new RowDataModel(this.getProp().getParent().getName(), this.getContext().getModel().getDataEntityType());
        }
        this.rowDataModel.setRowContext(dataEntity);
        return (DynamicObject)this.rowDataModel.getValue(this.getOrgProp().getName());
    }

    @Override
    public int getExchangeSeq() {
        return 50;
    }

    @Override
    public void exchangeOrg(ExtendedDataEntity[] dataEntities) {
        if (this.getBasedataProp() == null || this.getOrgProp() == null) {
            return;
        }
        Map<BasedataEntityType, List<BasedataExchangeRequest>> reqeusts = this.groupRequests(dataEntities);
        if (reqeusts.isEmpty()) {
            return;
        }
        this.setFieldValue(reqeusts);
    }

    protected Map<BasedataEntityType, List<BasedataExchangeRequest>> groupRequests(ExtendedDataEntity[] dataEntities) {
        HashMap<BasedataEntityType, List<BasedataExchangeRequest>> groups = new HashMap<BasedataEntityType, List<BasedataExchangeRequest>>(1);
        BasedataEntityType bdType = (BasedataEntityType)this.getBasedataProp().getComplexType();
        if (bdType == null || bdType.getMasteridType() == 0) {
            return groups;
        }
        ArrayList<BasedataExchangeRequest> requests = new ArrayList<BasedataExchangeRequest>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject oldValue = (DynamicObject)this.getProp().getValueFast((Object)dataEntity.getDataEntity());
            if (oldValue == null) continue;
            BasedataExchangeRequest request = new BasedataExchangeRequest();
            request.setExtDataEntity(dataEntity);
            request.setDataEntity(dataEntity.getDataEntity());
            request.setProp((IDataEntityProperty)this.getBasedataProp());
            request.setOldFldValue(oldValue);
            requests.add(request);
        }
        if (!requests.isEmpty()) {
            groups.put(bdType, requests);
        }
        return groups;
    }

    protected void setFieldValue(Map<BasedataEntityType, List<BasedataExchangeRequest>> requests) {
        for (Map.Entry<BasedataEntityType, List<BasedataExchangeRequest>> entry : requests.entrySet()) {
            this.setFieldValue(entry.getKey(), entry.getValue());
        }
    }

    protected void setFieldValue(BasedataEntityType bdType, List<BasedataExchangeRequest> requests) {
        if (bdType == null || bdType.getMasteridType() == 0 || requests.isEmpty()) {
            return;
        }
        Map<Long, List<BasedataExchangeRequest>> dctByOrg = this.groupByOrg(requests);
        if (dctByOrg.isEmpty()) {
            return;
        }
        if (dctByOrg.size() == 1 && Long.compare(0L, dctByOrg.entrySet().iterator().next().getKey()) == 0) {
            return;
        }
        Map<Object, Object> oldIdToMasterids = this.loadMasterids(bdType, requests);
        if (oldIdToMasterids.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, List<BasedataExchangeRequest>> orgItem : dctByOrg.entrySet()) {
            Long useOrgId = orgItem.getKey();
            if (Long.compare(0L, useOrgId) == 0) continue;
            HashSet<Object> masterids = new HashSet<Object>();
            ArrayList<BasedataExchangeRequest> orgRequests = new ArrayList<BasedataExchangeRequest>(orgItem.getValue().size());
            for (BasedataExchangeRequest request : orgItem.getValue()) {
                Object oldId = request.getOldFldValue().getPkValue();
                Object masterId = oldIdToMasterids.get(oldId);
                if (masterId == null) continue;
                orgRequests.add(request);
                request.setMasterId(masterId);
                masterids.add(masterId);
            }
            if (masterids.isEmpty()) continue;
            HashMap<Object, Object> masteridToIds = new HashMap<Object, Object>();
            HashSet<Object> newIds = new HashSet<Object>(masterids.size());
            if (!this.loadIdsinUseOrg(bdType, useOrgId, masterids, masteridToIds, newIds)) continue;
            Map idToObjs = this.getContext().getModel().loadReferenceDataBatch(bdType, newIds.toArray());
            for (BasedataExchangeRequest request : orgRequests) {
                this.setNewValue(oldIdToMasterids, masteridToIds, idToObjs, request);
            }
        }
    }

    protected boolean setNewValue(Map<Object, Object> oldIdToMasterids, Map<Object, Object> masteridToIds, Map<Object, DynamicObject> idToObjs, BasedataExchangeRequest request) {
        Object oldId = request.getOldFldValue().getPkValue();
        Object masterid = oldIdToMasterids.get(oldId);
        if (masterid == null) {
            return false;
        }
        Object newId = masteridToIds.get(masterid);
        if (newId == null) {
            request.setNewFldValue(null);
            request.setValue();
            this.addErrorMessage(request);
            return false;
        }
        DynamicObject bdObj = idToObjs.get(newId);
        if (bdObj == null) {
            request.setNewFldValue(null);
            request.setValue();
            this.addErrorMessage(request);
            return false;
        }
        request.setNewFldValue(bdObj);
        request.setValue();
        return true;
    }

    protected Map<Object, Object> loadMasterids(BasedataEntityType refBDType, List<BasedataExchangeRequest> requests) {
        HashMap<Object, Object> oldIdToMasterids = new HashMap<Object, Object>(requests.size());
        IDataEntityProperty masterIdProp = refBDType.findProperty(refBDType.getMasteridPropName());
        if (masterIdProp == null || !(masterIdProp instanceof IValidatorHanlder)) {
            return oldIdToMasterids;
        }
        for (BasedataExchangeRequest request : requests) {
            DynamicObject oldFldValue = request.getOldFldValue();
            Object oldId = oldFldValue.getPkValue();
            Object masterId = masterIdProp.getValue((Object)oldFldValue);
            if (masterId instanceof DynamicObject) {
                masterId = ((DynamicObject)masterId).getPkValue();
            }
            if (((IValidatorHanlder)masterIdProp).getValueComparator().compareValue(masterId)) continue;
            oldIdToMasterids.put(oldId, masterId);
        }
        return oldIdToMasterids;
    }

    private Map<Long, List<BasedataExchangeRequest>> groupByOrg(List<BasedataExchangeRequest> requests) {
        HashMap<Long, List<BasedataExchangeRequest>> dctByUseOrg = new HashMap<Long, List<BasedataExchangeRequest>>();
        if (this.getOrgProp() == null) {
            dctByUseOrg.put(0L, new ArrayList<BasedataExchangeRequest>(requests));
            return dctByUseOrg;
        }
        String orgPropName = this.getOrgProp().getName();
        boolean isMainOrg = StringUtils.equals((CharSequence)orgPropName, (CharSequence)this.getContext().getMainOrgProp().getName());
        for (BasedataExchangeRequest request : requests) {
            Long useOrgId = this.getContext().getOrgId();
            if (!isMainOrg) {
                DynamicObject useOrg = this.getOrgValue(request.getExtDataEntity().getDataEntity());
                useOrgId = useOrg == null ? Long.valueOf(0L) : (Long)useOrg.getPkValue();
            }
            if (!dctByUseOrg.containsKey(useOrgId)) {
                dctByUseOrg.put(useOrgId, new ArrayList(requests.size()));
            }
            ((List)dctByUseOrg.get(useOrgId)).add(request);
        }
        return dctByUseOrg;
    }

    private boolean loadIdsinUseOrg(BasedataEntityType bdType, long useOrgid, Set<Object> masterids, Map<Object, Object> masteridToIds, Set<Object> newIds) {
        if (bdType == null || bdType.getMasteridType() == 0) {
            return false;
        }
        if (Long.compare(useOrgid, 0L) == 0) {
            return false;
        }
        IBaseDataService baseDataService = (IBaseDataService)this.getContext().getModel().getService(IBaseDataService.class);
        QFilter orgFilter = baseDataService.getBaseDataFilter(bdType.getName(), useOrgid);
        Set bdIdsForOrg = null;
        if (orgFilter == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)orgFilter.getProperty(), (CharSequence)"id") && StringUtils.equals((CharSequence)orgFilter.getCP(), (CharSequence)"in") && orgFilter.getValue() instanceof Set) {
            bdIdsForOrg = (Set)orgFilter.getValue();
            orgFilter = null;
        }
        ORM orm = ORM.create();
        String fields = "id," + bdType.getMasteridPropName();
        QFilter masteridFilter = new QFilter(bdType.getMasteridPropName(), "in", (Object)masterids.toArray());
        QFilter[] filters = new QFilter[]{masteridFilter, orgFilter};
        try (DataSet ds = orm.queryDataSet("BasedataPropExchangeOrg.loadIdsinUseOrg", bdType.getName(), fields, filters, "");){
            for (Row row : ds) {
                Object id = row.get("id");
                Object masterid = row.get(bdType.getMasteridPropName());
                if (bdIdsForOrg != null && !bdIdsForOrg.contains(id)) continue;
                masteridToIds.put(masterid, id);
                newIds.add(id);
            }
        }
        return true;
    }

    private void addErrorMessage(BasedataExchangeRequest request) {
        DynamicObjectType bdType = request.getOldFldValue().getDynamicObjectType();
        String bdTypeDisplayName = bdType.getDisplayName().toString();
        String bdDisplayValue = this.getBasedataProp().getDisplayValue(request.getOldFldValue());
        String orgDisplayValue = this.getOrgProp().getDisplayValue(this.getOrgValue(request.getExtDataEntity().getDataEntity()));
        String failMessage = null;
        failMessage = this.getBasedataProp() instanceof MaterielProp && ((BasedataEntityType)this.getBasedataProp().getComplexType()).getMasteridType() == 2 ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010%1$s\u3011\u6ca1\u6709\u521b\u5efa\u3010%2$s\u3011\uff0c\u6216\u8005\u3010%3$s\u3011\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u3010%4$s\u3011\u4f7f\u7528", (String)"BasedataPropExchangeOrg_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), bdDisplayValue, this.getBasedataProp().getDynamicComplexPropertyType().getDisplayName().toString(), this.getBasedataProp().getDynamicComplexPropertyType().getDisplayName().toString(), orgDisplayValue) : String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u3010%3$s\u3011\u4f7f\u7528", (String)"BasedataPropExchangeOrg_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), bdTypeDisplayName, bdDisplayValue, orgDisplayValue);
        this.getContext().addErrMessage(request.getExtDataEntity(), this.getProp(), failMessage);
    }
}

