/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property.org;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.validate.ErrorLevel;

class ExchangeOrgContext {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private IDataModel model;
    private MainOrgProp mainOrgProp;
    private long orgId;
    private OperationResult exchangeResult;

    public ExchangeOrgContext(IDataModel model, MainOrgProp mainOrgProp, long orgId) {
        this.model = model;
        this.mainOrgProp = mainOrgProp;
        this.orgId = orgId;
    }

    public IDataModel getModel() {
        return this.model;
    }

    public MainOrgProp getMainOrgProp() {
        return this.mainOrgProp;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public OperationResult getExchangeResult() {
        return this.exchangeResult;
    }

    public void setExchangeResult(OperationResult exchangeResult) {
        this.exchangeResult = exchangeResult;
    }

    public void addErrMessage(String msg) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setTitle(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362", (String)"ExchangeOrgContext_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
        errorInfo.setMessage(msg);
        this.exchangeResult.addErrorInfo(errorInfo);
        this.exchangeResult.setSuccess(false);
    }

    public void addErrMessage(ExtendedDataEntity dataEntity, IDataEntityProperty prop, String msg) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setEntityKey(prop.getParent().getName());
        errorInfo.setFieldKey(prop.getName());
        errorInfo.setDataEntityIndex(dataEntity.getDataEntityIndex());
        errorInfo.setRowIndex(dataEntity.getRowIndex());
        errorInfo.setSubRowIndex(dataEntity.getSubRowIndex());
        errorInfo.setLevel(ErrorLevel.Error);
        String title = prop.getDisplayName() != null ? prop.getDisplayName().toString() : ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362", (String)"ExchangeOrgContext_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
        errorInfo.setTitle(title);
        String errMsg = msg;
        if (prop.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)prop.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errMsg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7b2c%2$s\u884c,\u3010 %3$s\u3011\u7b2c%4$s\u884c: %5$s", (String)"ExchangeOrgContext_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entryName, dataEntity.getRowIndex() + 1, subEntryName, dataEntity.getSubRowIndex() + 1, msg);
            } else {
                errMsg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7b2c%2$s\u884c: %3$s", (String)"ExchangeOrgContext_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entryType.getDisplayName().toString(), dataEntity.getRowIndex() + 1, msg);
            }
        }
        errorInfo.setMessage(errMsg);
        this.exchangeResult.addErrorInfo(errorInfo);
        this.exchangeResult.setSuccess(false);
    }
}

