/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.qing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.qing.FlexBaseDataProp;
import kd.bos.entity.qing.FlexField;
import kd.bos.util.JSONUtils;

public class FlexFieldDetail {
    private FlexField flexField;
    private List<FlexBaseDataProp> baseFlexDatas = new ArrayList<FlexBaseDataProp>();
    private Map<FlexProperty, String> textFlexDataMaps = new HashMap<FlexProperty, String>();
    private String originalValue;
    private String flexFieldRowKey;

    public FlexFieldDetail(FlexField flexField, String originalValue) {
        this.flexField = flexField;
        this.flexFieldRowKey = flexField.getRowKey();
        this.originalValue = originalValue;
    }

    public String getFlexFieldRowKey() {
        return this.flexFieldRowKey;
    }

    public void addBaseFlexData(FlexBaseDataProp baseFlexProp) {
        this.baseFlexDatas.add(baseFlexProp);
    }

    public void addTextFlexPropData(FlexProperty flexProperty, String textData) {
        this.textFlexDataMaps.put(flexProperty, textData);
    }

    public Map<String, Object> getInnerFlexPropDatas() {
        return this.getInnerFlexPropDatas(false);
    }

    public Map<String, Object> getInnerFlexPropDatas(boolean needPkProperty) {
        HashMap<String, Object> flexPropertyDatas = new HashMap<String, Object>();
        this.baseFlexDatas.forEach(baseDataProp -> {
            List<String> allBaseDataSubPropKeys = baseDataProp.getSupportedSubPropertys(needPkProperty);
            allBaseDataSubPropKeys.forEach(baseDataSubPropKey -> {
                DynamicObject dynamicObject = baseDataProp.getDynamicObject();
                Object subPropValue = null;
                if (null != dynamicObject && (subPropValue = dynamicObject.get(baseDataSubPropKey)) instanceof ILocaleString) {
                    ILocaleString localeString = (ILocaleString)subPropValue;
                    subPropValue = localeString.getLocaleValue();
                }
                flexPropertyDatas.put(this.flexFieldRowKey + "_" + baseDataProp.getFlexProperty().getFlexField() + "_" + baseDataSubPropKey, subPropValue);
            });
        });
        this.textFlexDataMaps.forEach((flexProperty, txtValue) -> flexPropertyDatas.put(this.flexFieldRowKey + "_" + flexProperty.getFlexField(), txtValue));
        return flexPropertyDatas;
    }

    public String formateAsJson() throws IOException {
        return this.formateAsJson(false);
    }

    public String formateAsJson(boolean needPkProperty) throws IOException {
        HashMap formatedValueMap = new HashMap(32);
        for (FlexBaseDataProp baseFlexProp : this.baseFlexDatas) {
            FlexProperty fp = baseFlexProp.getFlexProperty();
            DynamicObject dynamicObject = baseFlexProp.getDynamicObject();
            List<String> supportedProps = baseFlexProp.getSupportedSubPropertys(needPkProperty);
            HashMap internalValue = new HashMap();
            supportedProps.forEach(prop -> {
                String propDisplayKeyName = baseFlexProp.getAlias((String)prop);
                if (null == dynamicObject) {
                    internalValue.put(propDisplayKeyName, "null");
                } else {
                    Object propValue = dynamicObject.get(prop);
                    Class dataType = baseFlexProp.getPropertyType((String)prop);
                    if (dataType.isAssignableFrom(ILocaleString.class)) {
                        ILocaleString localeString = (ILocaleString)propValue;
                        internalValue.put(propDisplayKeyName, localeString.getLocaleValue());
                    } else {
                        internalValue.put(propDisplayKeyName, String.valueOf(propValue));
                    }
                }
            });
            formatedValueMap.put(fp.getName().getLocaleValue(), internalValue);
        }
        this.textFlexDataMaps.forEach((flexProperty, txtValue) -> formatedValueMap.put(flexProperty.getName().getLocaleValue(), txtValue));
        if (formatedValueMap.isEmpty()) {
            return this.originalValue;
        }
        return JSONUtils.toString(formatedValueMap);
    }
}

