/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.qing;

import kd.sdk.annotation.SdkPublic;

@SdkPublic
public enum QingFieldType {
    BaseData(0),
    String(1),
    Number(2),
    Int(3),
    DateTime(4),
    Date(5),
    Boolean(6);

    private int iNum = 0;

    private QingFieldType(int iNum) {
        this.iNum = iNum;
    }

    public int toNumber() {
        return this.iNum;
    }

    public static QingFieldType valueOfSqlType(int sqlType) {
        QingFieldType fieldType = String;
        switch (sqlType) {
            case 91: {
                fieldType = Date;
                break;
            }
            case 93: {
                fieldType = DateTime;
                break;
            }
            case 3: {
                fieldType = Number;
                break;
            }
            case -5: 
            case 4: {
                fieldType = Int;
                break;
            }
            case 1: 
            case 12: {
                fieldType = String;
                break;
            }
            default: {
                fieldType = String;
            }
        }
        return fieldType;
    }

    public static QingFieldType valueOfNumber(int number) {
        QingFieldType[] types;
        for (QingFieldType type : types = QingFieldType.values()) {
            if (type.toNumber() != number) continue;
            return type;
        }
        throw new RuntimeException("not existed QingfieldType number:" + number);
    }
}

