/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.Col2ndFilterOption;
import kd.bos.entity.report.DateEnum;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportBaseDataFilterInfo;
import kd.bos.entity.report.parser.IParser;
import kd.bos.entity.report.parser.QFilterParserFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterInfo
implements Serializable {
    private static final long serialVersionUID = -1669407329080270964L;
    private List<FilterItemInfo> filterItems = new ArrayList<FilterItemInfo>();
    private List<FilterItemInfo> flexFilterItems = new ArrayList<FilterItemInfo>();
    private Map<String, List<FilterItemInfo>> filterItemMap = new HashMap<String, List<FilterItemInfo>>();
    private Map<String, QFilter> commFilters = new HashMap<String, QFilter>();
    private FastFilter fastFilter;
    private List<FilterItemInfo> tableHeadFilterItems = new ArrayList<FilterItemInfo>();
    private Map<String, Col2ndFilterOption> col2ndFilterOptions = new HashMap<String, Col2ndFilterOption>(1);
    private List<ReportBaseDataFilterInfo> bdRightQFilters;
    private List<QFilter> qFilters = new ArrayList<QFilter>();
    private Map<String, List<Object>> otherEntryFilter = new HashMap<String, List<Object>>();

    public List<QFilter> getHeadFilters() {
        ArrayList<QFilter> headFilters = new ArrayList<QFilter>();
        for (FilterItemInfo item : this.tableHeadFilterItems) {
            IParser parser = QFilterParserFactory.createQFilterProcessor(item.getCompareType());
            QFilter qfilter = parser.buildQFilterByFilterItem(item);
            headFilters.add(qfilter);
        }
        return headFilters;
    }

    public List<FilterItemInfo> getTableHeadFilterItems() {
        return this.tableHeadFilterItems;
    }

    public void setTableHeadFilterItems(List<FilterItemInfo> tableHeadFilterItems) {
        this.tableHeadFilterItems = tableHeadFilterItems;
    }

    public Col2ndFilterOption getCol2ndFilterOption(String reportListKey) {
        if (StringUtils.isBlank((CharSequence)reportListKey)) {
            return null;
        }
        return this.col2ndFilterOptions.get(reportListKey);
    }

    public void copyCol2ndFilterOption(FilterInfo src) {
        this.col2ndFilterOptions = new HashMap<String, Col2ndFilterOption>(src.col2ndFilterOptions);
    }

    public void setCol2ndFilterOption(String reportListKey, Col2ndFilterOption col2ndFilterOption) {
        if (StringUtils.isBlank((CharSequence)reportListKey)) {
            return;
        }
        if (col2ndFilterOption == null) {
            this.col2ndFilterOptions.remove(reportListKey);
        } else {
            this.col2ndFilterOptions.put(reportListKey, col2ndFilterOption);
        }
    }

    public void setFastFilter(FastFilter fastFilter) {
        this.fastFilter = fastFilter;
    }

    public FastFilter getFastFilter() {
        return this.fastFilter;
    }

    @JsonIgnore
    @KSMethod
    public void setQFilters(List<QFilter> qFilters) {
        this.qFilters.clear();
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if (qFilter == null) continue;
                this.qFilters.add(qFilter);
            }
        }
    }

    @JsonIgnore
    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public void addFilterItem(String propName, Object value) {
        this.addFilterItem(propName, value, "=");
    }

    public void addDefaultFilters(List<Map<String, List<Object>>> defaultFilterList) {
        for (Map<String, List<Object>> defaultFilter : defaultFilterList) {
            String fieldName = (String)defaultFilter.get("FieldName").get(0);
            String compare = (String)defaultFilter.get("Compare").get(0);
            List<Object> value = defaultFilter.get("Value");
            this.addFilterItem(fieldName, value.get(0), compare);
        }
    }

    public void addDateEnumFilterItem(String propName, DateEnum dateEnum) {
        this.addFilterItem(propName, dateEnum.getValue(), "=");
    }

    public void addFilterItem(String propName, Object value, String compareType) {
        FilterItemInfo filterItem = new FilterItemInfo(propName, value, compareType);
        this.filterItems.add(filterItem);
        List<FilterItemInfo> items = this.filterItemMap.get(propName);
        if (items == null) {
            items = new ArrayList<FilterItemInfo>();
            this.filterItemMap.put(propName, items);
        }
        items.add(filterItem);
    }

    public void addCommFilter(String entityId, FilterCondition filter, ITimeService timeService, IUserService userService) {
        MainEntityType entity = EntityMetadataCache.getDataEntityType(entityId);
        FilterBuilder builder = new FilterBuilder(entity, filter);
        builder.setTimeService(timeService);
        builder.setUserService(userService);
        builder.buildFilter();
        this.commFilters.put(entityId, builder.getQFilter());
    }

    public QFilter getCommFilter(String entityId) {
        return this.commFilters.get(entityId);
    }

    @Deprecated
    public Map<String, List<QFilter>> getCommFilters() {
        HashMap<String, List<QFilter>> filterMap = new HashMap<String, List<QFilter>>(32);
        for (Map.Entry<String, QFilter> entry : this.commFilters.entrySet()) {
            QFilter filter = entry.getValue();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            filters.add(filter);
            filterMap.put(entry.getKey(), filters);
        }
        return filterMap;
    }

    public Map<String, QFilter> getCommFilter() {
        return this.commFilters;
    }

    public void setCommFilter(Map<String, QFilter> commFilters) {
        this.commFilters = commFilters;
    }

    public List<FilterItemInfo> getFilterItems() {
        return this.filterItems;
    }

    public boolean containProp(String propName) {
        return this.filterItemMap.containsKey(propName);
    }

    public List<FilterItemInfo> getFlexFilterItems() {
        return this.flexFilterItems;
    }

    public void setFlexFilterItems(List<FilterItemInfo> flexFilterItems) {
        this.flexFilterItems = flexFilterItems;
    }

    public Object getValue(String propName) {
        FilterItemInfo item = this.getFilterItem(propName);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public String getString(String propertyName) {
        return this.get(propertyName, String.class);
    }

    public int getInt(String propertyName) {
        return this.get(propertyName, Integer.class);
    }

    public long getLong(String propertyName) {
        Object val = this.getValue(propertyName);
        if (val instanceof DynamicObject) {
            return (Long)((DynamicObject)val).getPkValue();
        }
        return this.get(propertyName, Long.class);
    }

    public boolean getBoolean(String propertyName) {
        return this.get(propertyName, Boolean.class);
    }

    public BigDecimal getBigDecimal(String propertyName) {
        return this.get(propertyName, BigDecimal.class);
    }

    public Date getDate(String propertyName) {
        return this.get(propertyName, Date.class);
    }

    public DynamicObject getDynamicObject(String propertyName) {
        return this.get(propertyName, DynamicObject.class);
    }

    public DynamicObjectCollection getDynamicObjectCollection(String propertyName) {
        return this.get(propertyName, DynamicObjectCollection.class);
    }

    private <T> T get(String propertyName, Class<T> cls) {
        return (T)ObjectConverter.convert((Object)this.getValue(propertyName), cls);
    }

    public List<FilterItemInfo> getFilterItems(String propName) {
        return this.filterItemMap.get(propName);
    }

    public FilterItemInfo getFilterItem(String propName) {
        List<FilterItemInfo> propFilterItems = this.filterItemMap.get(propName);
        if (propFilterItems == null || propFilterItems.isEmpty()) {
            return null;
        }
        return propFilterItems.get(0);
    }

    public FilterInfo clone() {
        FilterInfo filter = new FilterInfo();
        for (FilterItemInfo item : this.filterItems) {
            filter.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
        }
        return filter;
    }

    public String toString() {
        StringBuilder oql = new StringBuilder();
        for (FilterItemInfo item : this.filterItems) {
            if (oql.length() > 0) {
                oql.append(" AND ");
            }
            oql.append(item);
        }
        return oql.toString();
    }

    public Map<String, List<Object>> getOtherEntryFilter() {
        return this.otherEntryFilter;
    }

    public void setOtherEntryFilter(Map<String, List<Object>> otherEntryFilter) {
        this.otherEntryFilter = otherEntryFilter;
    }

    public List<ReportBaseDataFilterInfo> getBdRightQFilters() {
        return this.bdRightQFilters;
    }

    public void addBdRightQFilters(ReportBaseDataFilterInfo info) {
        if (info != null && StringUtils.isNotBlank((CharSequence)info.getFieldKey()) && !CollectionUtils.isEmpty(info.getQFilters())) {
            if (this.bdRightQFilters == null) {
                this.bdRightQFilters = new ArrayList<ReportBaseDataFilterInfo>(10);
            }
            this.bdRightQFilters.add(info);
        }
    }
}

