/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.DynamicObjectJsonValue;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.CollectionUtils;

@SdkPublic
public class FilterItemInfo
implements Serializable {
    private static final long serialVersionUID = 6132608135149960229L;
    private static final String F_BASE_DATA_ID = "fbasedataid";
    private String propName;
    private String compareType;
    private Object value;

    public FilterItemInfo() {
    }

    public FilterItemInfo(String propName, Object value, String compareType) {
        this.propName = propName;
        this.compareType = compareType;
        this.setValue1(value);
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public void setCompareType(String compareType) {
        this.compareType = compareType;
    }

    public void setValue(Object value) {
        this.setValue1(value);
    }

    private void setValue1(Object value) {
        if (value instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)value;
            DynamicObjectType type = obj.getDynamicObjectType();
            DynamicObjectJsonValue val = new DynamicObjectJsonValue();
            val.setEntityId(type.getName());
            DcJsonSerializer jser = this.getDcJsonSerializer(type);
            val.setData(new String[]{jser.serializeToString((Object)obj, null)});
            this.value = val;
        } else if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection objColl = (DynamicObjectCollection)value;
            if (objColl.isEmpty()) {
                return;
            }
            DynamicObject obj = (DynamicObject)objColl.get(0);
            DynamicObjectType type = ((DynamicObject)objColl.get(0)).getDynamicObjectType();
            IDataEntityProperty prop = (IDataEntityProperty)type.getProperties().get((Object)F_BASE_DATA_ID);
            for (DynamicObject dynamicObject : objColl) {
                if (prop == null || (obj = (DynamicObject)dynamicObject.get(F_BASE_DATA_ID)) == null) continue;
                type = obj.getDynamicObjectType();
                break;
            }
            DynamicObjectJsonValue val = new DynamicObjectJsonValue();
            val.setEntityId(type.getName());
            DcJsonSerializer jser = this.getDcJsonSerializer(type);
            ArrayList<String> data = new ArrayList<String>();
            for (int i = 0; i < objColl.size(); ++i) {
                obj = (DynamicObject)objColl.get(i);
                if (prop != null) {
                    obj = (DynamicObject)obj.get(F_BASE_DATA_ID);
                }
                if (obj == null) continue;
                data.add(jser.serializeToString((Object)obj, null));
            }
            if (CollectionUtils.isNotEmpty(data)) {
                val.setData(data.toArray(new String[data.size()]));
                val.setMult(true);
                this.value = val;
            }
        } else {
            this.value = value;
        }
    }

    private DcJsonSerializer getDcJsonSerializer(DynamicObjectType type) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        return jser;
    }

    public String getPropName() {
        return this.propName;
    }

    public String getCompareType() {
        return this.compareType;
    }

    public Object getValue() {
        if (this.value instanceof DynamicObjectJsonValue) {
            DynamicObjectJsonValue obj = (DynamicObjectJsonValue)this.value;
            MainEntityType type = EntityMetadataCache.getDataEntityType(obj.getEntityId());
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            String[] data = obj.getData();
            if (obj.isMult()) {
                DynamicObjectCollection vals = new DynamicObjectCollection((DynamicObjectType)type, null);
                for (int i = 0; i < data.length; ++i) {
                    vals.add((Object)((DynamicObject)jser.deserializeFromString(data[i], null)));
                }
                return vals;
            }
            return jser.deserializeFromString(data[0], null);
        }
        return this.value;
    }

    public String getString() {
        return this.get(String.class);
    }

    public int getInt() {
        return this.get(Integer.class);
    }

    public long getLong() {
        return this.get(Long.class);
    }

    public Object[] getDynamicObjectPKs() {
        return (Object[])this.getValue();
    }

    public boolean getBoolean() {
        return this.get(Boolean.class);
    }

    public BigDecimal getBigDecimal() {
        return this.get(BigDecimal.class);
    }

    public Date getDate() {
        return this.get(Date.class);
    }

    private <T> T get(Class<T> cls) {
        return (T)ObjectConverter.convert((Object)this.getValue(), cls);
    }

    public FilterItemInfo clone() {
        return new FilterItemInfo(this.propName, this.value, this.compareType);
    }

    public String toString() {
        return this.propName + " " + this.compareType + " " + this.value;
    }
}

