/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportBatchQueryInfo
implements Serializable,
IReportBatchQueryInfo {
    private static final long serialVersionUID = -3998107307936771163L;
    private boolean largeData = false;
    private int countPerBatch = -1;
    private int currentBatchIndex;
    private String batchByDataSetCacheId;
    private int maxRowCountCached = 100000;
    private int maxExcelRowCountPerSheet = 1000000;

    public boolean isLargeData() {
        return this.largeData;
    }

    public void setLargeData(boolean largeData) {
        this.largeData = largeData;
    }

    public int getCountPerBatch() {
        return this.countPerBatch;
    }

    @Override
    public void setCountPerBatch(int countPerBatch) {
        this.countPerBatch = countPerBatch;
    }

    @Override
    public int getCurrentBatchIndex() {
        return this.currentBatchIndex;
    }

    public void setCurrentBatchIndex(int currentBatchIndex) {
        this.currentBatchIndex = currentBatchIndex;
    }

    @Override
    public List<Row> getCurrentBatchRows() {
        int start = this.getCurrentBatchIndex() * this.getCountPerBatch();
        return this.getBatchBy().getList(start, this.getCountPerBatch());
    }

    public String getBatchByDataSetCacheId() {
        return this.batchByDataSetCacheId;
    }

    public void setBatchByDataSetCacheId(String batchByDataSetCacheId) {
        this.batchByDataSetCacheId = batchByDataSetCacheId;
    }

    @Override
    @JsonIgnore
    public CachedDataSet getBatchBy() {
        if (StringUtils.isBlank((CharSequence)this.getBatchByDataSetCacheId())) {
            return null;
        }
        return Algo.getCacheDataSet((String)this.getBatchByDataSetCacheId());
    }

    public int getMaxRowCountCached() {
        return this.maxRowCountCached;
    }

    @Override
    public void setMaxRowCountCached(int maxRowCountCached) {
        this.maxRowCountCached = maxRowCountCached;
    }

    public int getMaxExcelRowCountPerSheet() {
        return this.maxExcelRowCountPerSheet;
    }

    @Override
    public void setMaxExcelRowCountPerSheet(int maxExcelRowCountPerSheet) {
        this.maxExcelRowCountPerSheet = maxExcelRowCountPerSheet;
    }

    public int getBatchCount() {
        CachedDataSet batchBy = this.getBatchBy();
        if (batchBy == null) {
            return 0;
        }
        int totalBatchRowCount = batchBy.getRowCount();
        int countPerBatch = this.getCountPerBatch();
        int batchCount = totalBatchRowCount / countPerBatch + (totalBatchRowCount % countPerBatch == 0 ? 0 : 1);
        return batchCount;
    }
}

