/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.IColumn;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.list.column.DateColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.list.column.IntegerColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.FormulaProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.DateTimeReportColumn;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportColumn
extends AbstractReportColumn
implements IColumn {
    private static final long serialVersionUID = -5406895262655911048L;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_BIGINT = "bigint";
    public static final String TYPE_DECIMAL = "decimal";
    public static final String TYPE_AMOUNT = "amount";
    public static final String TYPE_QTY = "qty";
    public static final String TYPE_BASE_UNIT_QTY = "baseunitqty";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_PICTURE = "picture";
    public static final String TYPE_BASEDATA = "basedata";
    public static final String TYPE_ASSISTANT = "assistant";
    public static final String TYPE_FLEX = "flex";
    public static final String TYPE_USER = "user";
    public static final String TYPE_FORMULA = "formula";
    public static final String TYPE_UNIT = "unit";
    public static final String TYPE_CURRENCY = "currency";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_COMBO = "combofield";
    public static final String TYPE_PRICE = "price";
    public static final String TYPE_STEPPER = "stepper";
    private static final String NUMBER = "number";
    private static final String LONG_NUMBER = "longNumber";
    private static final String FULL_NAME = "fullName";
    private static final String SIMPLE_NAME = "simplename";
    private static final String EDITOR = "editor";
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    public static final String NO_DISPLAY_SCALE_ZERO = "noDisplayScaleZeroWithReport";
    private static final String NUM_TYPE = "nt";
    private String fieldType;
    private LocaleString width;
    private String fieldKey;
    private String dateIndex;
    private String entityId;
    private String refBasedataProp;
    private String displayProp = "name";
    private String currencyField;
    private String measureUnitField;
    private int scale = -1;
    private boolean zeroShow = false;
    private boolean noDisplayScaleZero = false;
    private ColumnStyle style;
    private String formula;
    private boolean isHide_i;
    private boolean isFreeze_i;
    private boolean isHyperlink_i = false;
    private boolean isPicture_i;
    private transient ValueHandle getValueHandle;
    private DynamicProperty fieldProperty;
    private String OTitleReport;
    private String XTitleReport;
    private int CheckBoxReportShowStyle;
    private boolean isNeedFormat_i = false;
    private transient CellFormat cellFormat;
    private boolean isDesensitized = false;
    private boolean isRefOrg_i = false;
    private String orgFuncs = "";
    private Map<String, String[]> formulaVarMap = new HashMap<String, String[]>();
    private Map<String, Format> formats = new HashMap<String, Format>();

    @SimplePropertyAttribute(name="NeedFormat")
    @DefaultValueAttribute(value="false")
    public boolean isNeedFormat() {
        return this.isNeedFormat_i;
    }

    public void setNeedFormat(boolean isNeedFormat) {
        this.isNeedFormat_i = isNeedFormat;
    }

    @DefaultValueAttribute(value="false")
    @SimplePropertyAttribute
    public boolean isRefOrg() {
        return this.isRefOrg_i;
    }

    public void setRefOrg(boolean isRefOrg) {
        this.isRefOrg_i = isRefOrg;
    }

    @SimplePropertyAttribute
    public String getOrgFuncs() {
        return this.orgFuncs;
    }

    public void setOrgFuncs(String orgFuncs) {
        this.orgFuncs = orgFuncs;
    }

    public void setFieldProperty(DynamicProperty fieldProperty) {
        this.fieldProperty = fieldProperty;
    }

    private Format getFormat(FormatTypes type, String key) {
        Format format = null;
        if (StringUtils.isBlank((CharSequence)key)) {
            key = String.valueOf(type.getValue());
        }
        if ((format = this.formats.get(key)) == null) {
            format = FormatFactory.get(type).getFormat(this.getUserFormat());
            this.formats.put(key, format);
        }
        return format;
    }

    public static ReportColumn createBaseDataColumn(String fieldKey, String entityId) {
        ReportColumn col = new ReportColumn();
        col.fieldType = TYPE_BASEDATA;
        col.fieldKey = fieldKey;
        col.entityId = entityId;
        return col;
    }

    public static ReportColumn createCurrencyColumn(String fieldKey) {
        ReportColumn col = new ReportColumn();
        col.fieldType = TYPE_BASEDATA;
        col.fieldKey = fieldKey;
        col.entityId = "bd_currency";
        return col;
    }

    public static ReportColumn createBaseDataPropColumn(String fieldKey, String refBasedataProp, String displayProp) {
        ReportColumn col = new ReportColumn();
        col.fieldKey = fieldKey;
        col.refBasedataProp = refBasedataProp;
        col.displayProp = displayProp;
        return col;
    }

    @Override
    @SimplePropertyAttribute
    public LocaleString getWidth() {
        return this.width;
    }

    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @SimplePropertyAttribute
    public String getCurrencyField() {
        return this.currencyField;
    }

    public void setCurrencyField(String currencyField) {
        this.currencyField = currencyField;
    }

    @SimplePropertyAttribute
    public String getMeasureUnitField() {
        return this.measureUnitField;
    }

    public void setMeasureUnitField(String measureUnitField) {
        this.measureUnitField = measureUnitField;
    }

    @Override
    @SimplePropertyAttribute
    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String key) {
        this.fieldKey = key;
    }

    @SimplePropertyAttribute
    public String getDateIndex() {
        return this.dateIndex;
    }

    public void setDateIndex(String dateIndex) {
        this.dateIndex = dateIndex;
    }

    @SimplePropertyAttribute
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    @SimplePropertyAttribute
    public String getRefBasedataProp() {
        return this.refBasedataProp;
    }

    public void setRefBasedataProp(String refBasedataProp) {
        this.refBasedataProp = refBasedataProp;
    }

    @SimplePropertyAttribute
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @SimplePropertyAttribute
    public boolean isZeroShow() {
        return this.zeroShow;
    }

    public void setZeroShow(boolean zeroShow) {
        this.zeroShow = zeroShow;
    }

    @SimplePropertyAttribute
    public boolean isNoDisplayScaleZero() {
        return this.noDisplayScaleZero;
    }

    public void setNoDisplayScaleZero(boolean noDisplayScaleZero) {
        this.noDisplayScaleZero = noDisplayScaleZero;
    }

    @Override
    public int getFmtInfo(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        NumberPrecision numberPrecision = numberFormatProvider.getFormatPrecision(this.getFieldKey(), rowData);
        int newScale = numberPrecision.getPrecision();
        return newScale == -1 ? 0 : newScale;
    }

    @SimplePropertyAttribute
    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @SimplePropertyAttribute
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public DynamicProperty getFieldProperty() {
        return this.fieldProperty;
    }

    @Override
    @SimplePropertyAttribute
    public boolean isHide() {
        return this.isHide_i;
    }

    public void setHide(boolean isHide) {
        this.isHide_i = isHide;
    }

    @SimplePropertyAttribute
    public boolean isFreeze() {
        return this.isFreeze_i;
    }

    public void setFreeze(boolean isFreeze) {
        this.isFreeze_i = isFreeze;
    }

    @SimplePropertyAttribute
    public boolean isHyperlink() {
        return this.isHyperlink_i;
    }

    public void setHyperlink(boolean isHyperlink) {
        this.isHyperlink_i = isHyperlink;
    }

    @Override
    @SimplePropertyAttribute
    public boolean isPicture() {
        return this.isPicture_i;
    }

    public void setPicture(boolean isPicture) {
        this.isPicture_i = isPicture;
    }

    @ComplexPropertyAttribute
    public ColumnStyle getStyle() {
        return this.style;
    }

    public void setStyle(ColumnStyle style) {
        this.style = style;
    }

    @SimplePropertyAttribute
    public String getOTitleReport() {
        return this.OTitleReport;
    }

    public void setOTitleReport(String oTitleReport) {
        this.OTitleReport = oTitleReport;
    }

    @SimplePropertyAttribute
    public String getXTitleReport() {
        return this.XTitleReport;
    }

    public void setXTitleReport(String xTitleReport) {
        this.XTitleReport = xTitleReport;
    }

    @SimplePropertyAttribute
    public int getCheckBoxReportShowStyle() {
        return this.CheckBoxReportShowStyle;
    }

    public void setCheckBoxReportShowStyle(int checkBoxReportShowStyle) {
        this.CheckBoxReportShowStyle = checkBoxReportShowStyle;
    }

    @Override
    public Map<String, Object> createColumn() {
        HashMap<String, Object> editor;
        Map<String, Object> map = super.createColumn();
        map.put("visible", !this.isHide());
        map.put("dataIndex", this.fieldKey.replace(".", "_"));
        if (StringUtils.isNotBlank((Object)this.getWidth())) {
            map.put("w", this.getWidth());
        }
        map.put("sort", false);
        map.put("filter", false);
        if (TYPE_INTEGER.equals(this.getFieldType()) || TYPE_DECIMAL.equals(this.getFieldType()) || TYPE_BIGINT.equals(this.getFieldType()) || TYPE_AMOUNT.equals(this.getFieldType()) || TYPE_QTY.equals(this.getFieldType()) || TYPE_PRICE.equals(this.getFieldType()) || TYPE_STEPPER.equals(this.getFieldType())) {
            if (this.style != null && StringUtils.isNotBlank((CharSequence)this.style.getTextAlign())) {
                map.put("text-align", this.style.getTextAlign());
            } else {
                map.put("text-align", "right");
            }
            map.put("isuf", true);
            editor = new HashMap<String, Object>();
            editor.put("type", NUMBER);
            editor.put("sc", 10);
            editor.put("sz", true);
            map.put(EDITOR, editor);
            this.setEditorByFieldType(this.getFieldType(), editor);
        } else if (this.style != null && StringUtils.isNotBlank((CharSequence)this.style.getTextAlign())) {
            map.put("text-align", this.style.getTextAlign());
        } else {
            map.put("text-align", "default");
        }
        if (TYPE_DATE.equals(this.getFieldType())) {
            map.put("isuf", true);
            editor = new HashMap();
            editor.put("type", TYPE_DATE);
            map.put(EDITOR, editor);
        }
        map.put("ln", this.isHyperlink());
        map.put("isFixed", this.isFreeze());
        if (this.isPicture() || TYPE_PICTURE.equals(this.getFieldType())) {
            editor = new HashMap();
            editor.put("type", TYPE_PICTURE);
            map.put(EDITOR, editor);
            if (this.style != null && StringUtils.isNotBlank((CharSequence)this.style.getRadius())) {
                editor.put("rd", this.style.getRadius());
            }
        } else if (TYPE_CHECKBOX.equals(this.getFieldType())) {
            editor = new HashMap();
            editor.put("type", TYPE_CHECKBOX);
            if (this.CheckBoxReportShowStyle == 1) {
                editor.put("s", this.getCheckBoxReportShowStyle());
                editor.put("tt", null == this.getOTitleReport() ? ResManager.loadKDString((String)"\u662f", (String)"ReportColumn_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : this.getOTitleReport());
                editor.put("ft", null == this.getXTitleReport() ? ResManager.loadKDString((String)"\u5426", (String)"ReportColumn_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : this.getXTitleReport());
            }
            map.put(EDITOR, editor);
        }
        if (this.style != null) {
            if (StringUtils.isNotBlank((CharSequence)this.style.getForeColor())) {
                map.put("fc", this.style.getForeColor());
            }
            if (StringUtils.isNotBlank((CharSequence)this.style.getBackColor())) {
                map.put("bc", this.style.getBackColor());
            }
            if (this.style.getFontSize() != 12) {
                map.put("fs", this.style.getFontSize());
            }
        }
        return map;
    }

    @Override
    public Object getValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        if (this.getValueHandle == null) {
            this.getValueHandle = this.fieldProperty instanceof FlexProp ? new FlexValueHandle((FlexProp)this.fieldProperty) : (this.fieldProperty instanceof BasedataProp ? (this.refBasedataProp != null ? new BasedataPropValueHandle((BasedataProp)this.fieldProperty) : new BasedataValueHandle((BasedataProp)this.fieldProperty)) : (this.fieldProperty instanceof FormulaProp ? new FormulaValueHandle((FormulaProp)this.fieldProperty) : (this.fieldProperty instanceof ComboProp ? new ComboValueHandle((ComboProp)this.fieldProperty) : (this.fieldProperty instanceof AdminDivisionProp ? new AdminDivisionPropValueHandle((AdminDivisionProp)this.fieldProperty) : new ValueHandle(this.fieldProperty, numberFormatProvider)))));
        }
        return this.getValueHandle.getValue(rowData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getDisplayValue(DynamicObject basedataObj) {
        BasedataEntityType dt = (BasedataEntityType)basedataObj.getDataEntityType();
        Object displayValue = null;
        IDataEntityProperty property = null;
        if (this.displayProp == null) {
            property = dt.findProperty(dt.getNameProperty());
            if (property == null) return null;
            Object object = ((IFieldHandle)property).getBasePropDisplayValue(basedataObj);
            return object;
        }
        String[] refProp = this.displayProp.split("\\.");
        if (refProp.length == 1) {
            property = dt.getProperty(this.getDisplayPropName(dt, refProp[0]));
            if (property != null) return ((IFieldHandle)property).getBasePropDisplayValue(basedataObj);
            return displayValue;
        }
        if (refProp.length == 2) {
            IFieldHandle refBaseDataProp;
            DynamicObjectType mulDataType;
            property = dt.getProperty(refProp[0]);
            if (property instanceof BasedataProp) {
                DynamicObject refBasedataObj = (DynamicObject)basedataObj.get(property);
                BasedataEntityType refBasedataType = (BasedataEntityType)((BasedataProp)property).getComplexType();
                DynamicProperty refBaseDataProp2 = refBasedataType.getProperty(this.getDisplayPropName(refBasedataType, refProp[1]));
                if (refBaseDataProp2 == null) return displayValue;
                if (refBasedataObj == null) return displayValue;
                return ((IFieldHandle)refBaseDataProp2).getBasePropDisplayValue(refBasedataObj);
            }
            if (!(property instanceof MulBasedataProp)) return displayValue;
            DynamicObjectCollection refMulObj = (DynamicObjectCollection)basedataObj.get(property);
            BasedataEntityType refMulType = null;
            if (!CollectionUtils.isEmpty((Collection)refMulObj) && ((DynamicObject)refMulObj.get(0)).get("fbasedataid") instanceof DynamicObject && (mulDataType = ((DynamicObject)((DynamicObject)refMulObj.get(0)).get("fbasedataid")).getDynamicObjectType()) instanceof BasedataEntityType) {
                refMulType = (BasedataEntityType)mulDataType;
            }
            if (refMulType == null) {
                refMulType = (BasedataEntityType)EntityMetadataCache.getDataEntityType(((MulBasedataProp)property).getBaseEntityId());
            }
            if ((refBaseDataProp = (IFieldHandle)refMulType.getProperty(this.getDisplayPropName(refMulType, refProp[1]))) == null) throw new KDException(new ErrorCode("basedataprop error", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff0c\u5f53\u5f15\u7528\u5c5e\u6027\u4e3a\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u65f6\uff0c\u53ea\u652f\u6301\u7f16\u7801\u540d\u79f0", (String)"ReportColumn_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])), new Object[0]);
            if (refMulObj == null) throw new KDException(new ErrorCode("basedataprop error", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff0c\u5f53\u5f15\u7528\u5c5e\u6027\u4e3a\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u65f6\uff0c\u53ea\u652f\u6301\u7f16\u7801\u540d\u79f0", (String)"ReportColumn_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])), new Object[0]);
            if (refProp[1].equals(refMulType.getNameProperty())) return refMulObj.stream().map(item -> item.get("fbasedataid")).map(refBaseDataProp::getBasePropDisplayValue).map(String::valueOf).collect(Collectors.joining(";"));
            if (!refProp[1].equals(refMulType.getNumberProperty())) throw new KDException(new ErrorCode("basedataprop error", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff0c\u5f53\u5f15\u7528\u5c5e\u6027\u4e3a\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u65f6\uff0c\u53ea\u652f\u6301\u7f16\u7801\u540d\u79f0", (String)"ReportColumn_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])), new Object[0]);
            return refMulObj.stream().map(item -> item.get("fbasedataid")).map(refBaseDataProp::getBasePropDisplayValue).map(String::valueOf).collect(Collectors.joining(";"));
        }
        if (refProp.length != 3) throw new KDException(new ErrorCode("basedataPropEdit erroe", ResManager.loadKDString((String)"\u5f15\u7528\u5c5e\u6027\u4e0d\u8d85\u8fc7\u4e00\u7ea7", (String)"ReportColumn_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])), new Object[0]);
        property = dt.getProperty(refProp[0]);
        if (!(property instanceof BasedataProp)) return displayValue;
        DynamicObject refObj1 = (DynamicObject)basedataObj.get(property);
        BasedataEntityType refType1 = (BasedataEntityType)((BasedataProp)property).getComplexType();
        DynamicProperty refProp2 = refType1.getProperty(refProp[1]);
        if (!(refProp2 instanceof BasedataProp)) return displayValue;
        if (refObj1 == null) return displayValue;
        DynamicObject refObj2 = (DynamicObject)refObj1.get((IDataEntityProperty)refProp2);
        BasedataEntityType refType2 = (BasedataEntityType)((BasedataProp)refProp2).getComplexType();
        DynamicProperty refProp3 = refType2.getProperty(this.getDisplayPropName(refType2, refProp[2]));
        if (refProp3 == null) return displayValue;
        if (refObj2 == null) return displayValue;
        return ((IFieldHandle)refProp3).getBasePropDisplayValue(refObj2);
    }

    private String getDisplayPropName(BasedataEntityType dt, String displayPropName) {
        String nameKey = dt.getNameProperty();
        String numberKey = dt.getNumberProperty();
        if (StringUtils.isNotBlank((CharSequence)displayPropName)) {
            if (NUMBER.equalsIgnoreCase(displayPropName)) {
                nameKey = numberKey;
            } else if ("name".equalsIgnoreCase(displayPropName)) {
                if (StringUtils.isBlank((CharSequence)nameKey)) {
                    nameKey = displayPropName;
                }
            } else {
                nameKey = displayPropName;
            }
        }
        return nameKey;
    }

    private Object getFormulaValue(String formula, DynamicObject obj) {
        if (formula == null) {
            return null;
        }
        formula = formula.trim();
        String[] vars = this.getVars(formula);
        HashMap<String, Object> formulaCtx = new HashMap<String, Object>(32);
        for (String var : vars) {
            Object val = obj.get(var);
            if (val instanceof ILocaleString) {
                val = ((ILocaleString)val).getDefaultItem();
            }
            formulaCtx.put(var, val);
        }
        Object formulaResult = FormulaEngine.execExcelFormula((String)formula, formulaCtx);
        String formulaValue = "";
        if (formulaResult != null) {
            formulaValue = formulaResult.toString();
        }
        if (formulaValue.endsWith("0E-10")) {
            return formulaValue.replaceAll("0E-10", "0");
        }
        return formulaValue;
    }

    private String[] getVars(String formula) {
        Object[] vars = this.formulaVarMap.get(formula);
        if (vars == null) {
            vars = FormulaEngine.extractVariables((String)formula);
            Arrays.sort(vars);
            this.formulaVarMap.put(formula, (String[])vars);
        }
        return vars;
    }

    public Object formatCell(DynamicObject rowData, Object value, NumberFormatProvider numberFormatProvider, DynamicProperty dynamicProperty) {
        Object localValue = null;
        if (dynamicProperty != null) {
            localValue = rowData.getDataStorage().getLocalValue((IDataEntityProperty)dynamicProperty);
        }
        if (dynamicProperty != null && (ObjectUtils.isEmpty(localValue) || ObjectUtils.isEmpty((Object)value))) {
            if (this.fieldProperty.isEnableNull()) {
                return null;
            }
            return this.getDefValue();
        }
        return this.formatCell(rowData, value, numberFormatProvider);
    }

    public Object formatCell(DynamicObject rowData, Object value, NumberFormatProvider numberFormatProvider) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        if (this.fieldProperty instanceof DecimalProp && !this.zeroShow && value instanceof Number && ((Number)value).doubleValue() == 0.0) {
            return null;
        }
        if (this.fieldProperty instanceof TextProp && ((TextProp)this.fieldProperty).isPassword()) {
            return "******";
        }
        if (this.cellFormat == null) {
            this.cellFormat = this.createCellFormat(rowData);
        }
        return this.cellFormat.format(rowData, value);
    }

    private CellFormat createCellFormat(DynamicObject rowData) {
        if (this.fieldProperty instanceof AmountProp || this.fieldProperty instanceof PriceProp) {
            return new AmountCellFormat(this.fieldKey, (AmountProp)this.fieldProperty, this.getUserFormat(), this.noDisplayScaleZero, this.zeroShow, this.isNeedFormat());
        }
        if (this.fieldProperty instanceof IntegerProp) {
            return new IntegerCellFormat(this.fieldKey, (IntegerProp)this.fieldProperty, this.getUserFormat(), this.zeroShow, this.isNeedFormat());
        }
        if (this.fieldProperty instanceof QtyProp || this.fieldProperty instanceof DecimalProp && rowData.get(this.getFieldKey()) instanceof BigDecimal) {
            return new DecimalCellFormat(this.fieldKey, (DecimalProp)this.fieldProperty, this.getUserFormat(), this.noDisplayScaleZero, this.zeroShow, this.isNeedFormat());
        }
        if (this.fieldProperty instanceof TimeProp) {
            return new TimeCellFormat(this.fieldKey, (TimeProp)this.fieldProperty, this.getUserFormat());
        }
        if (this.fieldProperty instanceof DateProp) {
            String mask = null;
            if (this instanceof DateTimeReportColumn) {
                mask = ((DateTimeReportColumn)this).getMask();
            }
            return new DateCellFormat(this.fieldKey, (DateProp)this.fieldProperty, this.getUserFormat(), mask);
        }
        if (this.fieldProperty instanceof DateTimeProp) {
            String mask = null;
            if (this instanceof DateTimeReportColumn) {
                mask = ((DateTimeReportColumn)this).getMask();
            }
            return new DateTimeCellFormat(this.fieldKey, (DateTimeProp)this.fieldProperty, this.getUserFormat(), mask);
        }
        return new OtherCellFormat();
    }

    public Object getDefValue() {
        if (this.fieldProperty instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)this.fieldProperty;
            return decimalProp.getDefValue();
        }
        if (this.fieldProperty instanceof IntegerProp) {
            IntegerProp integerProp = (IntegerProp)this.fieldProperty;
            return integerProp.getDefValue();
        }
        return null;
    }

    public boolean isDesensitized() {
        return this.isDesensitized;
    }

    public void setDesensitized(boolean desensitized) {
        this.isDesensitized = desensitized;
    }

    public static NumberFormatProvider initNumberFormatProvider(DynamicObjectCollection datas, List<ReportColumn> columns) {
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>(20);
        for (ReportColumn reportColumn : columns) {
            if (reportColumn.getFieldProperty() == null) continue;
            String controlFieldName = null;
            if (reportColumn.getCurrencyField() != null) {
                controlFieldName = reportColumn.getCurrencyField();
            } else if (reportColumn.getMeasureUnitField() != null) {
                controlFieldName = reportColumn.getMeasureUnitField();
            }
            FmtField fmtField = new FmtField((IDataEntityProperty)reportColumn.getFieldProperty(), reportColumn.getFieldKey(), controlFieldName);
            fmtField.setScale(reportColumn.getScale());
            fmtFields.add(fmtField);
        }
        return new NumberFormatProvider(fmtFields, datas);
    }

    @Override
    public String toString() {
        return "fieldKey:" + this.fieldKey + ";caption\uff1a" + super.toString() + ";fieldType:" + this.getFieldType() + ";dataIndex:" + this.getDateIndex();
    }

    private void setEditorByFieldType(String fieldType, Map<String, Object> editor) {
        switch (fieldType) {
            case "amount": {
                editor.put(NUM_TYPE, TYPE_AMOUNT);
                break;
            }
            case "qty": {
                editor.put(NUM_TYPE, TYPE_QTY);
                break;
            }
            case "price": {
                editor.put(NUM_TYPE, TYPE_PRICE);
                break;
            }
            case "integer": 
            case "decimal": 
            case "bigint": 
            case "stepper": {
                editor.put(NUM_TYPE, "D");
                break;
            }
        }
    }

    static class OtherCellFormat
    implements CellFormat {
        OtherCellFormat() {
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            if (value instanceof ILocaleString) {
                ILocaleString localeString = (ILocaleString)value;
                return localeString.getLocaleValue();
            }
            return value;
        }
    }

    static class DateTimeCellFormat
    implements CellFormat {
        private DateTimeColumnDesc columnDesc;

        public DateTimeCellFormat(String fieldKey, DateTimeProp dateProp, FormatObject userFormat, String mask) {
            this.columnDesc = new DateTimeColumnDesc(fieldKey, dateProp, (IDataEntityProperty)dateProp);
            this.columnDesc.setDisplayFormatString(mask);
            this.columnDesc.setUserFormat(userFormat);
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            return this.columnDesc.getValue(rowData);
        }
    }

    static class DateCellFormat
    implements CellFormat {
        private DateColumnDesc columnDesc;

        public DateCellFormat(String fieldKey, DateProp dateProp, FormatObject userFormat, String mask) {
            this.columnDesc = new DateColumnDesc(fieldKey, dateProp, (IDataEntityProperty)dateProp);
            this.columnDesc.setDisplayFormatString(mask);
            this.columnDesc.setUserFormat(userFormat);
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            return this.columnDesc.getValue(rowData);
        }
    }

    static class TimeCellFormat
    implements CellFormat {
        private TimeColumnDesc columnDesc;

        public TimeCellFormat(String fieldKey, TimeProp timeProp, FormatObject userFormat) {
            this.columnDesc = new TimeColumnDesc(fieldKey, timeProp, (IDataEntityProperty)timeProp);
            this.columnDesc.getFormatParams().put("columntype", "report");
            this.columnDesc.setUserFormat(userFormat);
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            return this.columnDesc.getValue(rowData);
        }
    }

    static class DecimalCellFormat
    implements CellFormat {
        private DecimalColumnDesc columnDesc;
        private boolean needFormat;

        public DecimalCellFormat(String fieldKey, DecimalProp decimalProp, FormatObject userFormat, boolean noDisplayScaleZero, boolean zeroShow, boolean needFormat) {
            this.columnDesc = new DecimalColumnDesc(fieldKey, decimalProp, (IDataEntityProperty)decimalProp);
            this.columnDesc.getFormatParams().put("columntype", "report");
            this.columnDesc.getFormatParams().put(ReportColumn.NO_DISPLAY_SCALE_ZERO, noDisplayScaleZero);
            this.columnDesc.setUserFormat(userFormat);
            this.columnDesc.setZeroShow(zeroShow);
            this.needFormat = needFormat;
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            Object newValue = this.columnDesc.getValue(rowData);
            if (!this.needFormat && newValue instanceof Object[]) {
                Object[] val = (Object[])newValue;
                return val[0] == null ? Integer.valueOf(0) : val[0];
            }
            return newValue;
        }
    }

    static class IntegerCellFormat
    implements CellFormat {
        private IntegerColumnDesc integerColumnDesc;
        private boolean needFormat;

        public IntegerCellFormat(String fieldKey, IntegerProp integerProp, FormatObject userFormat, boolean zeroShow, boolean needFormat) {
            this.integerColumnDesc = new IntegerColumnDesc(fieldKey, integerProp, (IDataEntityProperty)integerProp);
            this.integerColumnDesc.setUserFormat(userFormat);
            this.integerColumnDesc.setZeroShow(zeroShow);
            this.needFormat = needFormat;
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            Object newValue = this.integerColumnDesc.getValue(rowData);
            if (!this.needFormat && newValue instanceof Object[]) {
                Object[] val = (Object[])newValue;
                return val[0] == null ? Integer.valueOf(0) : val[0];
            }
            return newValue;
        }
    }

    static class AmountCellFormat
    implements CellFormat {
        private AmountColumnDesc amountColumnDesc;
        private boolean needFormat;

        public AmountCellFormat(String fieldKey, AmountProp priceProp, FormatObject userFormat, boolean noDisplayScaleZero, boolean zeroShow, boolean needFormat) {
            this.amountColumnDesc = new AmountColumnDesc(fieldKey, priceProp, (IDataEntityProperty)priceProp);
            this.amountColumnDesc.getFormatParams().put("columntype", "report");
            this.amountColumnDesc.getFormatParams().put(ReportColumn.NO_DISPLAY_SCALE_ZERO, noDisplayScaleZero);
            this.amountColumnDesc.setUserFormat(userFormat);
            this.amountColumnDesc.setZeroShow(zeroShow);
            this.needFormat = needFormat;
        }

        @Override
        public Object format(DynamicObject rowData, Object value) {
            Object newValue = this.amountColumnDesc.getValue(rowData);
            if (!this.needFormat && newValue instanceof Object[]) {
                Object[] val = (Object[])newValue;
                return val[0] == null ? Integer.valueOf(0) : val[0];
            }
            return newValue;
        }
    }

    static interface CellFormat {
        public Object format(DynamicObject var1, Object var2);
    }

    class FormulaValueHandle
    extends ValueHandle {
        FormulaValueHandle(FormulaProp prop) {
            super((DynamicProperty)prop);
        }

        @Override
        public Object getValue(DynamicObject rowData) {
            FormulaProp p = (FormulaProp)this.getProp();
            return ReportColumn.this.getFormulaValue(p.getFormula(), rowData);
        }
    }

    class FlexValueHandle
    extends ValueHandle {
        FlexValueHandle(FlexProp prop) {
            super((DynamicProperty)prop);
        }

        @Override
        public Object getValue(DynamicObject rowData) {
            FlexProp p = (FlexProp)this.getProp();
            return p.getValueFast(rowData);
        }
    }

    class AdminDivisionPropValueHandle
    extends ValueHandle {
        AdminDivisionPropValueHandle(AdminDivisionProp prop) {
            super((DynamicProperty)prop);
        }

        @Override
        public Object getValue(DynamicObject rowData) {
            AdminDivisionProp p = (AdminDivisionProp)this.getProp();
            Object oV = p.getBasePropDisplayValue(rowData);
            if (oV == null) {
                return "";
            }
            return oV;
        }
    }

    class BasedataPropValueHandle
    extends ValueHandle {
        BasedataPropValueHandle(BasedataProp prop) {
            super((DynamicProperty)prop);
        }

        @Override
        public Object getValue(DynamicObject rowData) {
            DynamicObject dynamicObject = (DynamicObject)rowData.get(this.getProp().getName());
            if (dynamicObject == null) {
                return null;
            }
            return ReportColumn.this.getDisplayValue(dynamicObject);
        }
    }

    class BasedataValueHandle
    extends ValueHandle {
        private BasedataProp basedataProp;
        private BDPropValue bdPropValue;

        BasedataValueHandle(BasedataProp prop) {
            super((DynamicProperty)prop);
            this.basedataProp = prop;
        }

        @Override
        public Object getValue(DynamicObject rowData) {
            if (this.basedataProp == null) {
                return "";
            }
            Object value = this.basedataProp.getValueFast(rowData);
            if (!(value instanceof DynamicObject)) {
                return "";
            }
            if (this.bdPropValue == null) {
                this.bdPropValue = this.createBDPropValue((DynamicObject)value);
            }
            return this.bdPropValue.getValue((DynamicObject)value);
        }

        private BDPropValue createBDPropValue(DynamicObject value) {
            DynamicProperty masterProp;
            BasedataEntityType baseType = value.getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)value.getDataEntityType() : (BasedataEntityType)this.basedataProp.getComplexType();
            boolean readMasterProp = false;
            if (baseType.getMasteridType() == 2 && (masterProp = baseType.getProperty(baseType.getMasteridPropName())) instanceof BasedataProp) {
                baseType = (BasedataEntityType)((BasedataProp)masterProp).getComplexType();
                readMasterProp = true;
            }
            BDPropValue propValueGetter = this.createBDPropValue(baseType);
            if (readMasterProp) {
                return new MasterPropValue(baseType.getMasteridPropName(), propValueGetter);
            }
            return propValueGetter;
        }

        private BDPropValue createBDPropValue(BasedataEntityType baseType) {
            String nameProperty = baseType.getNameProperty();
            String numberProperty = baseType.getNumberProperty();
            if (StringUtils.isNotBlank((CharSequence)numberProperty) && StringUtils.isNotBlank((CharSequence)nameProperty) && ReportColumn.this.displayProp.contains(ReportColumn.NUMBER) && ReportColumn.this.displayProp.contains("name")) {
                if (baseType.findProperty(numberProperty) == null) {
                    nameProperty = null;
                }
                if (baseType.findProperty(nameProperty) == null) {
                    nameProperty = null;
                }
                return new BDNumberAndNamePropValue(numberProperty, nameProperty);
            }
            if (ReportColumn.NUMBER.equalsIgnoreCase(ReportColumn.this.displayProp) && baseType.findProperty(numberProperty) != null) {
                return new BDDisplayPropValue(numberProperty);
            }
            if (ReportColumn.LONG_NUMBER.equalsIgnoreCase(ReportColumn.this.displayProp) || ReportColumn.FULL_NAME.equalsIgnoreCase(ReportColumn.this.displayProp) && baseType.findProperty(ReportColumn.this.displayProp) != null) {
                if ("bos_org".equals(baseType.getName()) || "bos_adminorg".equals(baseType.getName())) {
                    return new OrgFullNameOrLongNumberDisplayPropValue(ReportColumn.this.displayProp, this.basedataProp);
                }
                return new BDDisplayPropValue(ReportColumn.this.displayProp);
            }
            if (ReportColumn.SIMPLE_NAME.equalsIgnoreCase(ReportColumn.this.displayProp) && baseType.findProperty(ReportColumn.this.displayProp) != null) {
                return new BDDisplayPropValue(ReportColumn.this.displayProp);
            }
            if (baseType.findProperty(nameProperty) != null) {
                return new BDDisplayPropValue(nameProperty);
            }
            return new BDDisplayEmptyValue();
        }
    }

    static class OrgFullNameOrLongNumberDisplayPropValue
    implements BDPropValue {
        private String displayProp;
        private BasedataProp basedataProp;

        public OrgFullNameOrLongNumberDisplayPropValue(String displayProp, BasedataProp basedataProp) {
            this.displayProp = displayProp;
            this.basedataProp = basedataProp;
        }

        @Override
        public String getValue(DynamicObject baseObject) {
            DynamicObjectCollection collection = baseObject.getDynamicObjectCollection("structure");
            if (collection.isEmpty()) {
                return baseObject.getString("name");
            }
            if (!((DynamicObject)collection.get(0)).containsProperty("view")) {
                return baseObject.getString("name");
            }
            String orgFunc = this.basedataProp.getOrgFunc();
            if (StringUtils.isBlank((CharSequence)orgFunc)) {
                if ("bos_org".equals(this.basedataProp.getBaseEntityId())) {
                    orgFunc = "15";
                } else if ("bos_adminorg".equals(this.basedataProp.getBaseEntityId())) {
                    orgFunc = "01";
                }
            }
            for (DynamicObject dobj : collection) {
                DynamicObject viewObj = dobj.getDynamicObject("view");
                if (viewObj == null) {
                    return baseObject.getString("name");
                }
                String viewNum = viewObj.getString(ReportColumn.NUMBER);
                if (!orgFunc.equals(viewNum)) continue;
                return dobj.get(this.displayProp) == null ? baseObject.getString("name") : dobj.get(this.displayProp).toString();
            }
            return baseObject.getString("name");
        }
    }

    static class MasterPropValue
    implements BDPropValue {
        private String masterPropName;
        BDPropValue masterPropValue;

        public MasterPropValue(String masterPropName, BDPropValue masterPropValue) {
            this.masterPropName = masterPropName;
            this.masterPropValue = masterPropValue;
        }

        @Override
        public String getValue(DynamicObject baseObject) {
            DynamicObject masterObj = baseObject.getDynamicObject(this.masterPropName);
            if (masterObj == null) {
                return "";
            }
            return this.masterPropValue.getValue(masterObj);
        }
    }

    static class BDNumberAndNamePropValue
    implements BDPropValue {
        private String numberProp;
        private String nameProp;

        public BDNumberAndNamePropValue(String numberProp, String nameProp) {
            this.numberProp = numberProp;
            this.nameProp = nameProp;
        }

        @Override
        public String getValue(DynamicObject baseObject) {
            String numberValue = null;
            if (StringUtils.isNotEmpty((CharSequence)this.numberProp)) {
                numberValue = baseObject.getString(this.numberProp);
            }
            if (numberValue == null) {
                numberValue = "";
            }
            String nameValue = null;
            if (StringUtils.isNotEmpty((CharSequence)this.nameProp)) {
                nameValue = baseObject.getString(this.nameProp);
            }
            if (nameValue == null) {
                nameValue = numberValue;
            }
            return String.format("%s %s", numberValue, nameValue);
        }
    }

    static class BDDisplayPropValue
    implements BDPropValue {
        private String displayProp;

        public BDDisplayPropValue(String displayProp) {
            this.displayProp = displayProp;
        }

        @Override
        public String getValue(DynamicObject baseObject) {
            return baseObject.getString(this.displayProp);
        }
    }

    static class BDDisplayEmptyValue
    implements BDPropValue {
        @Override
        public String getValue(DynamicObject baseObject) {
            return "";
        }
    }

    static interface BDPropValue {
        public String getValue(DynamicObject var1);
    }

    class ComboValueHandle
    extends ValueHandle {
        ComboValueHandle(ComboProp prop) {
            super((DynamicProperty)prop);
        }

        @Override
        public Object getValue(DynamicObject rowData) {
            ComboProp p = (ComboProp)this.getProp();
            Object oV = p.getValueFast(rowData);
            return oV == null ? "" : oV;
        }
    }

    class ValueHandle {
        private DynamicProperty prop;
        private NumberFormatProvider numberFormatProvider;

        ValueHandle(DynamicProperty prop) {
            this.prop = prop;
        }

        ValueHandle(DynamicProperty prop, NumberFormatProvider numberFormatProvider) {
            this.prop = prop;
            this.numberFormatProvider = numberFormatProvider;
        }

        public Object getValue(DynamicObject rowData) {
            if (this.prop == null) {
                return "";
            }
            Object val = this.prop.getValueFast((Object)rowData);
            return ReportColumn.this.formatCell(rowData, val, this.numberFormatProvider);
        }

        public DynamicProperty getProp() {
            return this.prop;
        }
    }
}

