/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.IColumnGroup;
import kd.bos.entity.report.AbstractReportColumn;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportColumnGroup
extends AbstractReportColumn
implements IColumnGroup<AbstractReportColumn>,
Serializable {
    private static final long serialVersionUID = -8321501886128808566L;
    private List<AbstractReportColumn> children = new ArrayList<AbstractReportColumn>();
    private String fieldKey;
    private String textAlign = "default";
    public static final String GroupCollapsible = "groupcollapsible";
    public static final String GroupDefaultCollapse = "groupdefaultcollapse";
    private boolean groupCollapsible;
    private boolean groupDefaultCollapse;
    private boolean isMerge_i;

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    @SimplePropertyAttribute
    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String key) {
        this.fieldKey = key;
    }

    @SimplePropertyAttribute(name="Merge")
    public boolean isMerge() {
        return this.isMerge_i;
    }

    public void setMerge(boolean isMerge) {
        this.isMerge_i = isMerge;
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=AbstractReportColumn.class)
    public List<AbstractReportColumn> getChildren() {
        return this.children;
    }

    @SimplePropertyAttribute(name="GroupCollapsible")
    public boolean isGroupCollapsible() {
        return this.groupCollapsible;
    }

    public void setGroupCollapsible(boolean groupCollapsible) {
        this.groupCollapsible = groupCollapsible;
    }

    @SimplePropertyAttribute(name="GroupDefaultCollapse")
    public boolean isGroupDefaultCollapse() {
        return this.groupDefaultCollapse;
    }

    public void setGroupDefaultCollapse(boolean groupDefaultCollapse) {
        this.groupDefaultCollapse = groupDefaultCollapse;
    }

    @Override
    public Map<String, Object> createColumn() {
        Map<String, Object> ctl = super.createColumn();
        ctl.put(GroupCollapsible, this.isGroupCollapsible());
        ctl.put(GroupDefaultCollapse, this.isGroupDefaultCollapse());
        if (this.isMerge()) {
            ctl.put("items", this.createColumns());
        } else {
            ctl.put("children", this.createColumns());
        }
        ctl.put("text-align", this.getTextAlign());
        if (this.fieldKey != null) {
            ctl.put("dataIndex", this.fieldKey.replace(".", "_"));
        }
        ctl.put("sort", false);
        ctl.put("filter", false);
        return ctl;
    }

    private List<Object> createColumns() {
        ArrayList<Object> cols = new ArrayList<Object>(20);
        for (AbstractReportColumn item : this.getChildren()) {
            cols.add(item.createColumn());
        }
        return cols;
    }
}

