/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report.parser;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.report.parser.IParser;

public class QFilterParserFactory {
    private static Map<String, String> processorMap = new HashMap<String, String>();

    private QFilterParserFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static IParser createQFilterProcessor(String compareType) {
        String className = processorMap.get(compareType);
        if (className == null) {
            className = processorMap.get("default");
        }
        return (IParser)TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        String prefix = "kd.bos.entity.report.parser.";
        String likeProcessor = "LikeParser";
        String equalProcessor = "EqualParser";
        String emptyProcessor = "EmptyParser";
        String numberProcessor = "NumberParser";
        String dateProcessor = "DateParser";
        processorMap.put("LIKE", prefix + likeProcessor);
        processorMap.put("NOT LIKE", prefix + likeProcessor);
        processorMap.put("lIKE", prefix + likeProcessor);
        processorMap.put("like", prefix + likeProcessor);
        processorMap.put("=", prefix + equalProcessor);
        processorMap.put("<>", prefix + equalProcessor);
        processorMap.put("IN", prefix + equalProcessor);
        processorMap.put("Not IN", prefix + equalProcessor);
        processorMap.put("ISNULL", prefix + emptyProcessor);
        processorMap.put("NOTISNULL", prefix + emptyProcessor);
        processorMap.put(">", prefix + numberProcessor);
        processorMap.put(">=", prefix + numberProcessor);
        processorMap.put("<", prefix + numberProcessor);
        processorMap.put("<=", prefix + numberProcessor);
        processorMap.put("TODAY", prefix + dateProcessor);
        processorMap.put("THISWEEK", prefix + dateProcessor);
        processorMap.put("THISMONTH", prefix + dateProcessor);
        processorMap.put("LASTMONTH", prefix + dateProcessor);
        processorMap.put("LASTTHREEMONTH", prefix + dateProcessor);
        processorMap.put("BETWEEN", prefix + dateProcessor);
        processorMap.put("default", prefix + likeProcessor);
    }
}

