/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.formula.FormulaEngine;

public abstract class AbstractRule {
    private String source;
    private String id;
    private int ret;
    private int seq;
    private String preCondition;
    private LocaleString preDescription = new LocaleString();
    private String description;
    private boolean enabled;
    private List<Map<String, Object>> trueActions = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> falseActions = new ArrayList<Map<String, Object>>();
    private String depFldKeys;
    private Set<String> depFldSet;

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = DB.genStringId((String)"");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute(name="Enabled")
    @DefaultValueAttribute(value="true")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SimplePropertyAttribute
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @SimplePropertyAttribute
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    @Deprecated
    @SimplePropertyAttribute
    public int getRET() {
        return this.ret;
    }

    @Deprecated
    public void setRET(int raiseEventType) {
        this.ret = raiseEventType;
    }

    @SimplePropertyAttribute
    public String getPreCondition() {
        return this.preCondition;
    }

    public void setPreCondition(String preCondition) {
        this.preCondition = preCondition;
    }

    @SimplePropertyAttribute
    public String getDepFldKeys() {
        return this.depFldKeys;
    }

    public void setDepFldKeys(String depFldKeys) {
        this.depFldKeys = depFldKeys;
    }

    public Set<String> getDepFldSet() {
        if (this.depFldSet == null) {
            this.depFldSet = new HashSet<String>();
            String[] keys = null;
            keys = StringUtils.isBlank((CharSequence)this.depFldKeys) ? FormulaEngine.extractVariables((String)this.preCondition) : this.depFldKeys.split(",");
            for (String key : keys) {
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                this.depFldSet.add(key.split("\\.")[0]);
            }
        }
        return this.depFldSet;
    }

    @SimplePropertyAttribute
    public List<Map<String, Object>> getTrueActions() {
        return this.trueActions;
    }

    public void setTrueActions(List<Map<String, Object>> actions) {
        this.trueActions = actions;
    }

    @SimplePropertyAttribute
    public List<Map<String, Object>> getFalseActions() {
        return this.falseActions;
    }

    public void setFalseActions(List<Map<String, Object>> actions) {
        this.falseActions = actions;
    }

    public abstract void execute(RuleExecuteContext var1);

    @SimplePropertyAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public String getPreDescription() {
        String description = this.preDescription.toString();
        return description == null ? "" : description;
    }

    public void setPreDescription(String preDescription) {
        this.preDescription = new LocaleString(preDescription);
    }

    @SimplePropertyAttribute(name="PreDescription")
    public LocaleString getLocalPreDescription() {
        return this.preDescription;
    }

    public void setLocalPreDescription(LocaleString localPreDescription) {
        this.preDescription = localPreDescription;
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractRule)) {
            return false;
        }
        AbstractRule other = (AbstractRule)obj;
        if (!StringUtils.equals((CharSequence)this.getId(), (CharSequence)other.getId())) {
            return false;
        }
        return this.actionEquals(this.getTrueActions(), other.getTrueActions()) && this.actionEquals(this.getFalseActions(), other.getFalseActions());
    }

    private boolean actionEquals(List<Map<String, Object>> actions1, List<Map<String, Object>> actions2) {
        String actionId;
        if (actions1.size() != actions2.size()) {
            return false;
        }
        HashSet<String> actionIds = new HashSet<String>(32);
        for (Map<String, Object> action : actions1) {
            actionId = (String)action.get("actionId");
            actionIds.add(actionId);
        }
        for (Map<String, Object> action : actions2) {
            actionId = (String)action.get("actionId");
            if (actionIds.contains(actionId)) continue;
            return false;
        }
        return true;
    }
}

