/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BRErrorCode;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.entity.rule.RuleAction;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.exception.KDBizException;

public class BR
extends AbstractRule {
    private static final String TRACE_TYPE_RULE = "formrule";
    protected List<RuleAction<RuleExecuteContext>> trueActionRuns;
    protected List<RuleAction<RuleExecuteContext>> falseActionRuns;
    private String ruleType;
    private Map<String, Object> extProps;
    private List<Map<String, Object>> currActions = null;
    private Map<String, Object> currAction = null;

    @Override
    public void execute(RuleExecuteContext executeContext) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_RULE, (String)"BR.execute");){
            if (span.isRealtime()) {
                span.addTag("desc", this.getDescription());
                span.addTag("preCondition", this.getPreCondition());
            }
            BRExecuteContext eContext = (BRExecuteContext)executeContext;
            RowDataModel rowModel = new RowDataModel(this.getSource(), eContext.getModel());
            ExpressionParameter parameter = new ExpressionParameter(this.getPreCondition(), rowModel);
            HashSet<DynamicObject> dataEntities = new HashSet<DynamicObject>(32);
            ArrayList<RowDataEntity> trueDataEntities = new ArrayList<RowDataEntity>(20);
            ArrayList<RowDataEntity> falseDataEntities = new ArrayList<RowDataEntity>(20);
            for (RowDataEntity dataEntity : eContext.getDataEntities()) {
                if (dataEntities.contains(dataEntity.getDataEntity())) continue;
                dataEntities.add(dataEntity.getDataEntity());
                parameter.setActiveRow(dataEntity.getDataEntity());
                parameter.setRowIndex(dataEntity.getRowIndex());
                if (this.executePreCondition(parameter)) {
                    trueDataEntities.add(dataEntity);
                    continue;
                }
                falseDataEntities.add(dataEntity);
            }
            if (!trueDataEntities.isEmpty()) {
                eContext._dataEntities = trueDataEntities;
                this.currActions = this.getTrueActions();
                this.buildTrueActionRuns();
                this.executeActions(eContext, this.trueActionRuns);
                this.currActions = null;
            }
            if (!falseDataEntities.isEmpty()) {
                eContext._dataEntities = falseDataEntities;
                this.currActions = this.getFalseActions();
                this.buildFalseActionRuns();
                this.executeActions(eContext, this.falseActionRuns);
                this.currActions = null;
            }
        }
    }

    private boolean executePreCondition(ExpressionParameter parameter) {
        Object expValue = null;
        try {
            expValue = CalcExprParser.getExpressionValue(parameter);
            if (expValue == null) {
                return false;
            }
            return (Boolean)expValue;
        }
        catch (RuntimeException exp) {
            StringBuilder sb = new StringBuilder();
            if (expValue == null) {
                sb.append(ResManager.loadKDString((String)"\u89c4\u5219\u524d\u7f6e\u6761\u4ef6\u6267\u884c\u51fa\u9519", (String)"BR_03", (String)"bos-entity-metadata", (Object[])new Object[0]));
            } else {
                sb.append(ResManager.loadKDString((String)"\u89c4\u5219\u524d\u7f6e\u6761\u4ef6\u7ed3\u679c\u4e0d\u662fBoolean\u503c", (String)"BR_04", (String)"bos-entity-metadata", (Object[])new Object[0]));
            }
            sb.append(System.lineSeparator());
            sb.append(ResManager.loadKDString((String)"\u6761\u4ef6\uff1a", (String)"BR_06", (String)"bos-entity-metadata", (Object[])new Object[0])).append(parameter.getExpression()).append(System.lineSeparator());
            if (expValue != null) {
                sb.append(ResManager.loadKDString((String)"\u7ed3\u679c\uff1a", (String)"BR_07", (String)"bos-entity-metadata", (Object[])new Object[0])).append(expValue).append(System.lineSeparator());
            }
            this.addBRDescErrMsg(sb);
            this.addCauseErrMsg(sb, exp);
            throw new KDBizException((Throwable)exp, expValue == null ? BRErrorCode.ERROR_PRECONDITION_RUN : BRErrorCode.ERROR_PRECONDITION_RESULT_NOT_BOOL, new Object[]{sb.toString()});
        }
    }

    protected void executeActions(BRExecuteContext executeContext, List<RuleAction<RuleExecuteContext>> actions) {
        int index = 0;
        for (RuleAction<RuleExecuteContext> action : actions) {
            this.currAction = this.currActions != null && this.currActions.size() > index ? this.currActions.get(index) : null;
            this.executeAction(executeContext, action);
            this.currAction = null;
            ++index;
        }
    }

    protected void executeAction(BRExecuteContext executeContext, RuleAction<RuleExecuteContext> action) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_RULE, (String)(action.getClass().getSimpleName() + ".execute"));){
            if (span.isRealtime()) {
                span.addTag("action", action.toString());
                span.addLocaleTag("param", this.currAction);
            }
            action.execute(executeContext);
        }
    }

    protected void buildTrueActionRuns() {
        if (this.trueActionRuns == null) {
            this.trueActionRuns = new ArrayList<RuleAction<RuleExecuteContext>>(20);
            for (Map<String, Object> action : this.getTrueActions()) {
                RuleAction<RuleExecuteContext> actionRun = this.createAction(action);
                this.trueActionRuns.add(actionRun);
            }
        }
    }

    protected void buildFalseActionRuns() {
        if (this.falseActionRuns == null) {
            this.falseActionRuns = new ArrayList<RuleAction<RuleExecuteContext>>(20);
            for (Map<String, Object> action : this.getFalseActions()) {
                RuleAction<RuleExecuteContext> actionRun = this.createAction(action);
                this.falseActionRuns.add(actionRun);
            }
        }
    }

    private RuleAction<RuleExecuteContext> createAction(Map<String, Object> action) {
        String className = (String)action.get("class");
        RuleAction act = (RuleAction)TypesContainer.createInstance((String)className);
        act.setParameter(action);
        return act;
    }

    @SimplePropertyAttribute(name="RuleType")
    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    @SimplePropertyAttribute(name="ExtProps")
    public Map<String, Object> getExtProps() {
        return this.extProps;
    }

    public void setExtProps(Map<String, Object> extProps) {
        this.extProps = extProps;
    }

    private void addBRDescErrMsg(StringBuilder sb) {
        sb.append(ResManager.loadKDString((String)"\u6240\u5c5e\u89c4\u5219\uff1a", (String)"BR_09", (String)"bos-entity-metadata", (Object[])new Object[0])).append(this.getDescription()).append(System.lineSeparator());
    }

    private void addCauseErrMsg(StringBuilder sb, RuntimeException exp) {
        sb.append(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0\uff1a", (String)"BR_01", (String)"bos-entity-metadata", (Object[])new Object[0]));
        String msg = exp.getMessage();
        if (msg != null) {
            sb.append(msg);
        } else {
            sb.append(exp.getClass().getName());
        }
    }
}

