/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FieldMustInputBR
extends BR {
    private static final Log log = LogFactory.getLog(FieldMustInputBR.class);
    private String fieldKeyForMsg;
    private String fieldNameForMsg;

    public FieldMustInputBR() {
    }

    public FieldMustInputBR(String fieldKeyForMsg, String fieldNameForMsg) {
        this.fieldKeyForMsg = fieldKeyForMsg;
        this.fieldNameForMsg = fieldNameForMsg;
    }

    public String getFieldKeyForMsg() {
        return this.fieldKeyForMsg;
    }

    public void setFieldKeyForMsg(String fieldKeyForMsg) {
        this.fieldKeyForMsg = fieldKeyForMsg;
    }

    public String getFieldNameForMsg() {
        return this.fieldNameForMsg;
    }

    public void setFieldNameForMsg(String fieldNameForMsg) {
        this.fieldNameForMsg = fieldNameForMsg;
    }

    @Override
    public void execute(RuleExecuteContext executeContext) {
        block22: {
            try (EntityTraceSpan span = EntityTracer.create((String)"formrule", (String)"FieldMustInputBR.execute");){
                BRExecuteContext eContext;
                if (span.isRealtime()) {
                    span.addTag("desc", this.getDescription());
                    span.addTag("preDesc", this.getPreDescription());
                    span.addTag("preCondition", this.getPreCondition());
                    span.addTag("source", this.getSource());
                }
                if (((eContext = (BRExecuteContext)executeContext).getDataEntities() == null || eContext.getDataEntities().isEmpty()) && executeContext instanceof BRExecuteContext && this.isOnlyHeadFiledCondition((BRExecuteContext)executeContext, this.getPreCondition())) {
                    ArrayList<RowDataEntity> falseDataEntities;
                    ArrayList<RowDataEntity> trueDataEntities;
                    block21: {
                        DynamicObject headObj = ((BRExecuteContext)executeContext).getModel().getDataEntity(false);
                        RowDataModel rowModel = new RowDataModel(this.getSource(), eContext.getModel());
                        ExpressionParameter parameter = new ExpressionParameter(this.getPreCondition(), rowModel);
                        trueDataEntities = new ArrayList<RowDataEntity>(20);
                        falseDataEntities = new ArrayList<RowDataEntity>(20);
                        parameter.setActiveRow(headObj);
                        parameter.setRowIndex(0);
                        try {
                            Object expValue = CalcExprParser.getExpressionValue(parameter);
                            if (expValue != null && ((Boolean)expValue).booleanValue()) {
                                trueDataEntities.add(new RowDataEntity(0, headObj));
                            } else {
                                falseDataEntities.add(new RowDataEntity(0, headObj));
                            }
                        }
                        catch (ORMArgInvalidException e) {
                            Map<String, IDataEntityProperty> allFields = eContext.getModel().getDataEntityType().getAllFields();
                            Set<String> vars = parameter.getBOSExpression().getVars();
                            boolean isExistField = false;
                            for (String var : vars) {
                                if (!allFields.containsKey(var)) continue;
                                isExistField = true;
                                break;
                            }
                            if (isExistField) break block21;
                            throw new KDBizException(this.getORMExceptionMsg());
                        }
                    }
                    if (!trueDataEntities.isEmpty()) {
                        eContext._dataEntities = trueDataEntities;
                        this.buildTrueActionRuns();
                        this.executeActions(eContext, this.trueActionRuns);
                    }
                    if (!falseDataEntities.isEmpty()) {
                        eContext._dataEntities = falseDataEntities;
                        this.buildFalseActionRuns();
                        this.executeActions(eContext, this.falseActionRuns);
                    }
                    break block22;
                }
                super.execute(executeContext);
            }
        }
    }

    private boolean isOnlyHeadFiledCondition(BRExecuteContext executeContext, String condition) {
        BOSExpression expr = new BOSExpression(condition);
        Set<String> vars = expr.getVars();
        if (vars != null && executeContext.getModel() != null) {
            MainEntityType mainEntityType = executeContext.getModel().getDataEntityType();
            for (String var : vars) {
                if (mainEntityType.getProperty(var) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getORMExceptionMsg() {
        return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s(%2$s)\u7684\u5fc5\u5f55\u6761\u4ef6\u5b57\u6bb5\u4e0d\u5728\u5f53\u524d\u5b9e\u4f53\u7684\u7236\u5b50\u5c42\u7ea7\u4e2d\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"FieldMustInputBR_0", (String)"bos-entity-metadata", (Object[])new Object[0]), this.fieldNameForMsg, this.fieldKeyForMsg);
    }

    private boolean existEntryDepFld(MainEntityType mainEntityType) {
        Set<String> fields = this.getDepFldSet();
        for (String field : fields) {
            IDataEntityType parent;
            IDataEntityProperty fieldProp = mainEntityType.findProperty(field);
            if (fieldProp == null || (parent = fieldProp.getParent()) == null || !(mainEntityType.findProperty(parent.getName()) instanceof EntryProp)) continue;
            return true;
        }
        return false;
    }
}

