/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.IRuleCompariseon;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleDataEntities;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.entity.rule.RuleUtils;
import kd.bos.entity.rule.TaskCollection;
import kd.bos.entity.rule.kflow.KR;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;

public abstract class RuleContainer<T extends RuleExecuteContext> {
    private TaskCollection _suspendTasks;
    private int _initLevel;
    private static final Log log = LogFactory.getLog(RuleContainer.class);

    protected IDataModel getModel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raise(RaiseEventSource arg, T executeContext) {
        block9: {
            if (arg == null) {
                throw new IllegalArgumentException("arg");
            }
            try {
                this.suspend();
                TaskCollection taskContext = this._suspendTasks;
                taskContext.addRaiseEventSource(arg);
                if (arg.getRaiseEventType() == RaiseEventType.FieldChanged) {
                    this.onFieldChanged(arg, taskContext);
                    break block9;
                }
                if (arg.getRaiseEventType() == RaiseEventType.Initialized) {
                    this.onInitialized(arg, taskContext);
                    break block9;
                }
                if (arg.getRaiseEventType() == RaiseEventType.ItemAdded || arg.getRaiseEventType() == RaiseEventType.ItemReset) {
                    this.onItemAddedOrItemReset(arg, taskContext);
                    break block9;
                }
                if (arg.getRaiseEventType() == RaiseEventType.Reset) {
                    this.onReset(arg, taskContext);
                    break block9;
                }
                if (arg.getRaiseEventType() == RaiseEventType.ItemRemoved) {
                    this.onItemRemoved(arg, taskContext);
                    break block9;
                }
                throw new UnsupportedOperationException(arg.getRaiseEventType().toString());
            }
            finally {
                this.resume(executeContext);
            }
        }
    }

    private void onItemRemoved(RaiseEventSource arg, TaskCollection taskContext) {
    }

    private void onReset(RaiseEventSource arg, TaskCollection taskContext) {
    }

    protected void onItemAddedOrItemReset(RaiseEventSource arg, TaskCollection taskContext) {
        List<AbstractRule> fieldRules;
        List<AbstractRule> childEntityRules;
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        List<AbstractRule> entityRules = this.getEntityDependencyRules(arg.getDataEntityType(), arg.getRaiseEventType());
        if (entityRules != null) {
            rules.addAll(entityRules);
        }
        if ((childEntityRules = this.getChildEntityDependencyRules(arg.getDataEntityType(), arg.getRaiseEventType())) != null) {
            rules.addAll(childEntityRules);
        }
        if ((fieldRules = this.getFieldDependencyRulesByEntityType(arg.getDataEntityType(), arg.getRaiseEventType())).size() != 0) {
            rules.addAll(fieldRules);
        }
        List<RowDataEntity> eventDataEntities = this.rebuildRowDataEntities(arg.getRaiseEventType(), rules, arg.getDataEntityType(), arg.getDataEntities());
        taskContext.addAll(RuleUtils.mapingRulesDataEntites(this.getModel(), arg.getRaiseEventType(), rules, arg.getDataEntityType(), eventDataEntities));
    }

    protected void onInitialized(RaiseEventSource arg, TaskCollection taskContext) {
        List<AbstractRule> fieldRules;
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        for (RowDataEntity row : arg.getDataEntities()) {
            if (row.getDataEntity().getDataEntityType() instanceof MainEntityType) {
                List<AbstractRule> entryRules = this.getEntityDependencyRules(arg.getDataEntityType(), arg.getRaiseEventType());
                if (entryRules == null) break;
                rules.addAll(entryRules);
                break;
            }
            if (!(row.getDataEntity().getDataEntityType() instanceof EntryType)) continue;
            List<AbstractRule> entryRules = this.getEntityDependencyRules(row.getDataEntity().getDataEntityType(), arg.getRaiseEventType());
            if (entryRules == null) break;
            rules.addAll(entryRules);
            break;
        }
        if ((fieldRules = this.getFieldDependencyRulesByEntityType(arg.getDataEntityType(), arg.getRaiseEventType())).size() != 0) {
            rules.addAll(fieldRules);
        }
        ArrayList<RowDataEntity> eventDataEntities = new ArrayList<RowDataEntity>();
        eventDataEntities.addAll(arg.getDataEntities());
        taskContext.addAll(RuleUtils.mapingRulesDataEntites(this.getModel(), arg.getRaiseEventType(), rules, arg.getDataEntityType(), eventDataEntities));
    }

    protected void onFieldChanged(RaiseEventSource arg, TaskCollection taskContext) {
        if (arg.getProperty() == null) {
            throw new IllegalArgumentException("arg.getProperty is null");
        }
        if (arg.getDataEntities() == null) {
            throw new IllegalArgumentException("arg.DataEntity is null");
        }
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        List<AbstractRule> fieldRule = this.getFieldDependencyRules(arg.getProperty(), arg.getRaiseEventType());
        rules.addAll(fieldRule);
        if (rules.size() == 0) {
            return;
        }
        List<RowDataEntity> eventDataEntities = this.rebuildRowDataEntities(arg.getRaiseEventType(), rules, arg.getProperty().getParent(), arg.getDataEntities());
        taskContext.addAll(RuleUtils.mapingRulesDataEntites(this.getModel(), arg.getRaiseEventType(), rules, arg.getProperty().getParent(), eventDataEntities));
    }

    protected abstract List<AbstractRule> getFieldDependencyRules(IDataEntityProperty var1, RaiseEventType var2);

    protected abstract List<AbstractRule> getFieldDependencyRulesByEntityType(IDataEntityType var1, RaiseEventType var2);

    protected abstract List<AbstractRule> getEntityDependencyRules(IDataEntityType var1, RaiseEventType var2);

    protected List<AbstractRule> getChildEntityDependencyRules(IDataEntityType entity, RaiseEventType raiseEventType) {
        return new ArrayList<AbstractRule>();
    }

    protected List<RowDataEntity> rebuildRowDataEntities(RaiseEventType raiseEventType, List<AbstractRule> rules, IDataEntityType eventTable, List<RowDataEntity> eventDataEntities) {
        ArrayList<RowDataEntity> dataEntities = new ArrayList<RowDataEntity>();
        dataEntities.addAll(eventDataEntities);
        return dataEntities;
    }

    public void resume(T executeContext) {
        try {
            if (this._initLevel == 1 && this._suspendTasks != null) {
                if (this._suspendTasks.size() > 0) {
                    ((RuleExecuteContext)executeContext)._raiseEventSources = this._suspendTasks.getRaiseEventSources();
                    ((RuleExecuteContext)executeContext)._raiseEventTypeFlag = this.getRaiseEventTypeFlag(((RuleExecuteContext)executeContext)._raiseEventSources);
                    this.execute(executeContext, this._suspendTasks);
                }
                ((RuleExecuteContext)executeContext)._raiseEventSources = null;
                this._suspendTasks.clear();
                this._suspendTasks = null;
            }
        }
        catch (KDBizException bizexp) {
            this.doFailRecoder(executeContext, (Exception)((Object)bizexp));
            throw bizexp;
        }
        catch (Exception exp) {
            this.doFailRecoder(executeContext, exp);
            throw exp;
        }
        finally {
            --this._initLevel;
        }
    }

    private void doFailRecoder(T executeContext, Exception exp) {
        if (executeContext != null) {
            ((RuleExecuteContext)executeContext)._raiseEventSources = null;
        }
        if (this._suspendTasks != null) {
            this._suspendTasks.clear();
            this._suspendTasks = null;
        }
    }

    private RaiseEventType getRaiseEventTypeFlag(List<RaiseEventSource> args) {
        int eventType = 0;
        if (args != null) {
            for (RaiseEventSource eventSource : args) {
                eventType |= eventSource.getRaiseEventType().getValue();
            }
        }
        return RaiseEventType.forValue(eventType);
    }

    private void execute(T executeContext, TaskCollection tasks) {
        RefObject task = new RefObject(null);
        while (tasks.dequeue((RefObject<RuleDataEntities>)task)) {
            if (((RuleDataEntities)task.argvalue).DataEntities == null) continue;
            ((RuleExecuteContext)executeContext)._dataEntities = ((RuleDataEntities)task.argvalue).DataEntities;
            if (((RuleDataEntities)task.argvalue).Rule instanceof KR) {
                ArrayList<KR> kRules;
                KR kr = (KR)((RuleDataEntities)task.argvalue).Rule;
                Map<String, Object> contextObj = ((RuleExecuteContext)executeContext).getContextObj();
                if (contextObj == null) {
                    contextObj = new HashMap<String, Object>(16);
                    ((RuleExecuteContext)executeContext).setContextObj(contextObj);
                }
                if ((kRules = (ArrayList<KR>)contextObj.get("kRules")) == null) {
                    kRules = new ArrayList<KR>(10);
                    contextObj.put("kRules", kRules);
                }
                kRules.add(kr);
            }
            if (((RuleDataEntities)task.argvalue).Rule instanceof BR) {
                IParameterReaderService service = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class);
                IDataModel model = this.getModel();
                if (model != null && service != null) {
                    boolean isPrintRuleLog;
                    String formId;
                    DynamicObject billParamObj;
                    BR rule = (BR)((RuleDataEntities)task.argvalue).Rule;
                    MainEntityType entityType = model.getDataEntityType();
                    if (entityType != null && (billParamObj = service.getBillParameter(formId = entityType.getName())) != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)"printrulelog") && (isPrintRuleLog = billParamObj.getBoolean("printrulelog"))) {
                        log.info("\u5355\u636e\u7f16\u7801\uff1a{} \u89c4\u5219\u63cf\u8ff0\uff1a{} \u524d\u7f6e\u6761\u4ef6\u89c4\u5219\uff1a{} \u6761\u4ef6\u6210\u7acb\u65f6\u6267\u884c\u7684\u89c4\u5219\u52a8\u4f5c\u96c6\u5408\uff1a{} \u6761\u4ef6\u4e0d\u6210\u7acb\u65f6\u6267\u884c\u7684\u89c4\u5219\u52a8\u4f5c\u96c6\u5408\uff1a{}", new Object[]{formId, rule.getDescription(), rule.getPreCondition(), rule.getTrueActions(), rule.getFalseActions()});
                    }
                }
            }
            ((RuleDataEntities)task.argvalue).Rule.execute((RuleExecuteContext)executeContext);
            ((RuleExecuteContext)executeContext)._dataEntities = null;
        }
    }

    private String buildErrContext(T executeContext) {
        return null;
    }

    public void suspend() {
        this.suspend(0L);
    }

    public void suspend(long dataSize) {
        ++this._initLevel;
        this.setMaxTaskCount(dataSize);
    }

    public void setMaxTaskCount(long dataSize) {
        int constant;
        if (this._suspendTasks == null) {
            this._suspendTasks = new TaskCollection(this.getRuleComparison());
        }
        if (Long.compare(dataSize * (long)(constant = 100), this._suspendTasks.get_maxTaskCount()) > 0) {
            this._suspendTasks.set_maxTaskCount(dataSize * (long)constant);
        }
    }

    protected abstract IRuleCompariseon getRuleComparison();
}

