/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.ClientBR;
import kd.bos.entity.rule.FieldMustInputBR;
import kd.bos.entity.rule.GetDownDataEntities;
import kd.bos.entity.rule.GetUpDataEntities;
import kd.bos.entity.rule.RuleDataEntities;
import kd.bos.entity.rule.kflow.KR;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.BeanUtils;

@SdkPublic
public class RuleUtils {
    private static final Log log = LogFactory.getLog(RuleUtils.class);

    public static List<RuleDataEntities> mapingRulesDataEntites(IDataModel model, RaiseEventType raiseEventType, List<AbstractRule> rules, IDataEntityType eventTable, List<RowDataEntity> eventDataEntities) {
        IDataEntityType mainType;
        if (RuleUtils.canShip(rules) || eventDataEntities == null) {
            return null;
        }
        HashMap mapRules = new HashMap();
        for (AbstractRule rule : rules) {
            BR br;
            String ruleType;
            int ret;
            if (!rule.isEnabled() || rule instanceof BR && "KFlowRule".equalsIgnoreCase(((BR)rule).getRuleType()) && eventTable instanceof FlexEntityType) continue;
            ArrayList<AbstractRule> lst = (ArrayList<AbstractRule>)mapRules.get(rule.getSource());
            if (lst == null) {
                lst = new ArrayList<AbstractRule>();
                mapRules.put(rule.getSource(), lst);
            }
            List<Map<String, Object>> trueActions = rule.getTrueActions();
            List<Map<String, Object>> falseActions = rule.getFalseActions();
            ArrayList<Map<String, Object>> tmpTrueActions = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> tmpFalseActions = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> trueMap : trueActions) {
                ret = trueMap.get("ret") == null ? 0 : (StringUtils.isEmpty((CharSequence)trueMap.get("ret").toString()) ? 0 : Integer.parseInt(trueMap.get("ret").toString()));
                if ((ret & raiseEventType.getValue()) == 0) continue;
                tmpTrueActions.add(trueMap);
            }
            for (Map<String, Object> falseMap : falseActions) {
                ret = falseMap.get("ret") == null ? 0 : (StringUtils.isEmpty((CharSequence)falseMap.get("ret").toString()) ? 0 : Integer.parseInt(falseMap.get("ret").toString()));
                if ((ret & raiseEventType.getValue()) == 0) continue;
                tmpFalseActions.add(falseMap);
            }
            if (!(lst.contains(rule) || tmpTrueActions.size() <= 0 && tmpFalseActions.size() <= 0)) {
                AbstractRule tmpRule = new BR();
                if (rule instanceof FieldMustInputBR) {
                    try {
                        tmpRule = (AbstractRule)rule.getClass().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        log.error((Throwable)e);
                    }
                }
                try {
                    BeanUtils.copyProperties((Object)tmpRule, (Object)rule);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.info(e.getMessage());
                }
                tmpRule.setTrueActions(tmpTrueActions);
                tmpRule.setFalseActions(tmpFalseActions);
                lst.add(tmpRule);
            }
            if (!(rule instanceof BR) || !"KFlowRule".equalsIgnoreCase(ruleType = (br = (BR)rule).getRuleType())) continue;
            KR kr = new KR().convertFromBR(br);
            if ((raiseEventType.getValue() & kr.getTriggerTime()) == 0 || raiseEventType == RaiseEventType.ItemAdded && !(eventTable instanceof MainEntityType)) continue;
            lst.add(kr);
        }
        ArrayList<RuleDataEntities> rets = new ArrayList<RuleDataEntities>();
        for (mainType = eventTable; mainType != null && !(mainType instanceof MainEntityType); mainType = mainType.getParent()) {
        }
        for (Map.Entry entry : mapRules.entrySet()) {
            List<RowDataEntity> dataEntities = null;
            if (mainType != null) {
                String entryKey = (String)entry.getKey();
                Map<String, EntityType> entities = ((MainEntityType)mainType).getAllEntities();
                if (!entities.containsKey(entryKey)) {
                    IDataEntityProperty property = model.getProperty(entryKey);
                    entryKey = property.getParent().getName();
                }
                dataEntities = RuleUtils.getDataEntities(model, eventTable, (IDataEntityType)entities.get(entryKey), eventDataEntities);
            }
            for (AbstractRule rule : (List)entry.getValue()) {
                RuleDataEntities res = new RuleDataEntities();
                res.DataEntities = dataEntities;
                res.Rule = rule;
                rets.add(res);
            }
        }
        return rets;
    }

    private static List<RowDataEntity> getDataEntities(IDataModel model, IDataEntityType eventTable, IDataEntityType targetTable, List<RowDataEntity> eventDataEntities) {
        if (eventTable.getName().equalsIgnoreCase(targetTable.getName())) {
            ArrayList<RowDataEntity> list = new ArrayList<RowDataEntity>();
            list.addAll(eventDataEntities);
            return list;
        }
        int m = Integer.compare(RuleUtils.getEntityLevel(eventTable), RuleUtils.getEntityLevel(targetTable));
        if (m < 0) {
            GetDownDataEntities rowsSearch = new GetDownDataEntities(model, eventTable, targetTable, eventDataEntities);
            return rowsSearch.getRowDataEntitys();
        }
        if (m > 0) {
            GetUpDataEntities rowsSearch = new GetUpDataEntities(model, eventTable, targetTable, eventDataEntities);
            return rowsSearch.getRowDataEntitys();
        }
        return eventDataEntities;
    }

    private static boolean canShip(List<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.size() == 0;
    }

    public static String[] getConditionFields(String condition) {
        ArrayList<String> fieldlist = new ArrayList<String>();
        Pattern pattern = Pattern.compile("g\\(\\'(.+?)\\'\\)");
        Matcher matcher = pattern.matcher(condition);
        while (matcher.find()) {
            fieldlist.add(matcher.group(1));
        }
        String[] arr = new String[fieldlist.size()];
        return fieldlist.toArray(arr);
    }

    public static Map<String, Object> parseRules(ClientBR clientRule, Map<String, String> feildIds) {
        HashMap<String, Object> ruleMap = null;
        ruleMap = new HashMap<String, Object>();
        ruleMap.put("condition", RuleUtils.handlePreCondtion(clientRule.getPreCondition()));
        List<Map<String, Object>> trueActions = clientRule.getTrueActions();
        ArrayList<String> actions = new ArrayList<String>();
        for (Map<String, Object> bizRuleAction : trueActions) {
            actions.addAll(RuleUtils.handleActions(bizRuleAction, feildIds));
        }
        ruleMap.put("actions", actions);
        return ruleMap;
    }

    private static String handlePreCondtion(String preCondition) {
        String regex = "[\\s|+|-|*|/]";
        String[] vars = FormulaEngine.extractVariables((String)preCondition);
        preCondition = " " + preCondition + " ";
        for (String str : vars) {
            String replaceStr = " g('" + str + "') ";
            preCondition = preCondition.replaceAll(regex + str + regex, replaceStr);
        }
        preCondition = preCondition.replace("\"", "'");
        preCondition = preCondition.replaceAll(regex + "((?i)and)" + regex, " && ");
        preCondition = preCondition.replaceAll(regex + "((?i)or)" + regex, " || ");
        return preCondition.trim();
    }

    private static List<String> handleActions(Map<String, Object> rule, Map<String, String> fieldMap) {
        ArrayList<String> actionLists = new ArrayList<String>();
        List actions = (List)rule.get("actionList");
        String actionName = rule.get("actionName").toString();
        for (Map actionList : actions) {
            switch (rule.get("actionClass").toString()) {
                case "ClientSetMulPropAction": {
                    Map prop = (Map)actionList.get("prop");
                    String fieldName = prop.get("fieldId").toString();
                    actionLists.add(actionName + "('" + fieldName + "', '" + prop.get("propertyName") + "', '" + prop.get("propertyValue") + "')");
                    break;
                }
                case "ClientSetPropAction": {
                    Map prop = (Map)actionList.get("prop");
                    String fieldName = prop.get("fieldId").toString();
                    actionLists.add(actionName + "('" + fieldName + "')");
                    break;
                }
                case "ClientSetFieldfmtAction": {
                    Map styles = (Map)actionList.get("style");
                    String fieldName = actionList.get("fieldKey").toString();
                    if (StringUtils.isNotBlank(styles.get("bc"))) {
                        actionLists.add(actionName + "('" + fieldName + "', 'backgroundColor', '" + styles.get("bc") + "')");
                    }
                    if (StringUtils.isNotBlank(styles.get("fc"))) {
                        actionLists.add(actionName + "('" + fieldName + "', 'color', '" + styles.get("fc") + "')");
                    }
                    if (!"0".equals(String.valueOf(styles.get("fs")))) {
                        actionLists.add(actionName + "('" + fieldName + "', 'fontSize', '" + styles.get("fs") + "')");
                    }
                    if (!"0".equals(String.valueOf(styles.get("vfs")))) {
                        actionLists.add(actionName + "('" + fieldName + "', 'valueFontSize', '" + styles.get("vfs") + "')");
                    }
                    if (StringUtils.isNotBlank(styles.get("vbc"))) {
                        actionLists.add(actionName + "('" + fieldName + "', 'valueBackgroundColor', '" + styles.get("vbc") + "')");
                    }
                    if (!StringUtils.isNotBlank(styles.get("vfc"))) break;
                    actionLists.add(actionName + "('" + fieldName + "', 'valueColor', '" + styles.get("vfc") + "')");
                    break;
                }
            }
        }
        return actionLists;
    }

    private static int getEntityLevel(IDataEntityType entityType) {
        int entityLevel = -1;
        if (entityType instanceof MainEntityType) {
            entityLevel = 0;
        } else if (entityType instanceof SubEntryType) {
            entityLevel = 2;
        } else if (entityType instanceof LinkEntryType) {
            LinkEntryType linkEntryType = (LinkEntryType)entityType;
            entityLevel = RuleUtils.getEntityLevel((IDataEntityType)((EntityType)linkEntryType.getParent())) + 1;
        } else if (entityType instanceof EntryType) {
            entityLevel = 1;
        } else if (entityType == null) {
            entityLevel = -1;
        }
        return entityLevel;
    }
}

