/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.IRuleCompariseon;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleDataEntities;

public class TaskCollection {
    private long _maxTaskCount = 1000L;
    private List<RuleDataEntities> _tasks;
    private List<RaiseEventSource> _raiseEventSources = new ArrayList<RaiseEventSource>();
    private int _head;
    private IRuleCompariseon _sortComparison;

    public TaskCollection(IRuleCompariseon sortComparison) {
        this._sortComparison = sortComparison;
    }

    public void clear() {
        if (this._raiseEventSources != null) {
            this._raiseEventSources.clear();
        }
        if (this._tasks != null) {
            this._tasks.clear();
        }
        this._sortComparison = null;
    }

    public void addRaiseEventSource(RaiseEventSource eventSource) {
        this._raiseEventSources.add(eventSource);
    }

    public List<RaiseEventSource> getRaiseEventSources() {
        return this._raiseEventSources;
    }

    public void addAll(List<RuleDataEntities> newTasks) {
        if (newTasks == null) {
            return;
        }
        if (this._tasks != null && (long)this._tasks.size() > this._maxTaskCount) {
            StringBuilder sb = new StringBuilder();
            String errMessage = ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u5b9e\u4f53\u670d\u52a1\u89c4\u5219\u7684\u5b9a\u4e49\u53ef\u80fd\u5bfc\u81f4\u4e86\u6b7b\u5faa\u73af\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u8ba1\u7b97\u6b63\u786e\uff01", (String)"TaskCollection_0", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]);
            sb.append(errMessage);
            sb.append(ResManager.loadKDString((String)"\u53ef\u7591\u5b9e\u4f53\u670d\u52a1\u89c4\u5219\uff1a", (String)"TaskCollection_1", (SubSystemType)SubSystemType.BOS, (Object[])new Object[0]));
            int seq = 1;
            for (RuleDataEntities task : newTasks) {
                if (seq > 5) break;
                sb.append(seq).append(". ").append(task.Rule.toString());
                ++seq;
            }
            throw new RuntimeException(sb.toString());
        }
        RefObject item = new RefObject(null);
        for (RuleDataEntities task : newTasks) {
            if (this.tryGetTask(task.Rule, (RefObject<RuleDataEntities>)item)) {
                if (ObjectUtils.nullSafeEquals(task.DataEntities, ((RuleDataEntities)item.argvalue).DataEntities)) continue;
                ((RuleDataEntities)item.argvalue).addAll(task);
                continue;
            }
            if (this._tasks == null) {
                this._tasks = new ArrayList<RuleDataEntities>(4);
            }
            this._tasks.add(task);
        }
    }

    private boolean tryGetTask(AbstractRule rule, RefObject<RuleDataEntities> item) {
        if (this._tasks != null) {
            for (int i = this._head; i < this._tasks.size(); ++i) {
                item.argvalue = this._tasks.get(i);
                if (!((RuleDataEntities)item.argvalue).Rule.equals(rule)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean dequeue(RefObject<RuleDataEntities> result) {
        if (this._tasks != null && this._head < this._tasks.size()) {
            this.moveMinRuleToHead();
            result.argvalue = this._tasks.get(this._head);
            this._tasks.set(this._head, null);
            ++this._head;
            return true;
        }
        return false;
    }

    private void moveMinRuleToHead() {
        if (this._sortComparison != null) {
            RuleDataEntities first = this._tasks.get(this._head);
            for (int i = this._head + 1; i < this._tasks.size(); ++i) {
                if (this._sortComparison.compare(first.Rule, this._tasks.get((int)i).Rule) <= 0) continue;
                this._tasks.set(this._head, this._tasks.get(i));
                this._tasks.set(i, first);
                first = this._tasks.get(this._head);
            }
        }
    }

    public int size() {
        if (this._tasks != null) {
            return Math.max(0, this._tasks.size() - this._head);
        }
        return 0;
    }

    public long get_maxTaskCount() {
        return this._maxTaskCount;
    }

    public void set_maxTaskCount(long _maxTaskCount) {
        this._maxTaskCount = _maxTaskCount;
    }
}

